/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.brain;

import com.github.ptran779.aegisops.brain.behavior.AbsAction;
import com.github.ptran779.aegisops.brain.sensor.AbsSensor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class Brain {
    protected Map<String, AbsSensor<?>> sensorMap = new HashMap();
    protected Map<String, AbsAction> actionMap = new HashMap<String, AbsAction>();
    protected HashSet<String> runningActions = new HashSet();
    private static final EnumSet<AbsAction.Flag> ALL_FLAGS = EnumSet.allOf(AbsAction.Flag.class);
    private EnumSet<AbsAction.Flag> freeFlag = EnumSet.noneOf(AbsAction.Flag.class);
    protected int tcount;
    protected boolean triggerCompute = false;
    protected final int throttle_time;

    public Brain(int throttle_time) {
        this.throttle_time = throttle_time;
        this.tcount = throttle_time;
    }

    public void forceEval() {
        this.triggerCompute = true;
    }

    public void tick() {
        if (++this.tcount >= this.throttle_time || this.triggerCompute) {
            this.tcount = 0;
            this.triggerCompute = false;
            for (AbsSensor<?> absSensor : this.sensorMap.values()) {
                absSensor.update();
            }
            this.freeFlag.addAll(ALL_FLAGS);
            HashSet<String> newActions = new HashSet<String>();
            for (String oldAction : this.runningActions) {
                AbsAction action = this.actionMap.get(oldAction);
                if (action != null && !action.isInterruptible()) {
                    this.freeFlag.removeAll(action.getFlags());
                    continue;
                }
                newActions.add(oldAction);
            }
            Comparator<ScoreActionPair> comparator = Comparator.comparingDouble(p -> p.score).reversed();
            ArrayList<ScoreActionPair> candidates = new ArrayList<ScoreActionPair>();
            for (Map.Entry<String, AbsAction> entry : this.actionMap.entrySet()) {
                if (!this.freeFlag.containsAll(entry.getValue().getFlags()) || !entry.getValue().canUse()) continue;
                float score = entry.getValue().computeScore(this.sensorMap);
                candidates.add(new ScoreActionPair(score, entry.getKey()));
            }
            candidates.sort(comparator);
            for (ScoreActionPair pair : candidates) {
                if (this.freeFlag.isEmpty()) break;
                AbsAction action = this.actionMap.get(pair.action);
                if (!this.freeFlag.containsAll(action.getFlags())) continue;
                this.freeFlag.removeAll(action.getFlags());
                newActions.add(pair.action);
            }
            for (String oldAction : this.runningActions) {
                if (newActions.contains(oldAction)) continue;
                this.actionMap.get(oldAction).end();
            }
            for (String newAction : newActions) {
                if (this.runningActions.contains(newAction)) continue;
                this.actionMap.get(newAction).start();
            }
            this.runningActions = newActions;
        }
        Iterator<String> it = this.runningActions.iterator();
        while (it.hasNext()) {
            String string = it.next();
            AbsAction actionObj = this.actionMap.get(string);
            if (!actionObj.keepUsing()) {
                actionObj.end();
                it.remove();
                continue;
            }
            actionObj.tick();
        }
    }

    public void registerSensor(String key, AbsSensor<?> sensor) {
        this.sensorMap.put(key, sensor);
    }

    public void registerBehavior(String key, AbsAction action) {
        this.actionMap.put(key, action);
    }

    public void removeSensor(String key) {
        this.sensorMap.remove(key);
    }

    public void removeBehavior(String key) {
        this.actionMap.remove(key);
    }

    public record ScoreActionPair(float score, String action) {
    }
}

