/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.brain.behavior;

import com.github.ptran779.aegisops.brain.sensor.AbsSensor;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public abstract class AbsAction {
    private final EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
    private final HashMap<String, WeightBias> sensorWeights = new HashMap();

    public void setFlags(EnumSet<Flag> pFlagSet) {
        this.flags.clear();
        this.flags.addAll(pFlagSet);
    }

    public EnumSet<Flag> getFlags() {
        return this.flags;
    }

    public void setWeightBias(String sensorName, WeightBias wb) {
        this.sensorWeights.put(sensorName, wb);
    }

    public WeightBias getWeightBias(String sensorName) {
        return this.sensorWeights.get(sensorName);
    }

    public float computeScore(Map<String, AbsSensor<?>> sensorValues) {
        float score = 0.0f;
        for (Map.Entry<String, WeightBias> entry : this.sensorWeights.entrySet()) {
            WeightBias wb = entry.getValue();
            Float sensorVal = (Float)sensorValues.get(entry.getKey()).getValue();
            if (sensorVal == null) continue;
            score += wb.weight * sensorVal.floatValue() + wb.bias;
        }
        return score;
    }

    public boolean canUse() {
        return false;
    }

    public void start() {
    }

    public void end() {
    }

    public boolean keepUsing() {
        return false;
    }

    public boolean isInterruptible() {
        return true;
    }

    public void tick() {
    }

    public static enum Flag {
        MOVE,
        LOOK,
        JUMP,
        TARGET,
        USE;

    }

    public static class WeightBias {
        public float weight;
        public float bias;

        public WeightBias(float weight, float bias) {
            this.weight = weight;
            this.bias = bias;
        }
    }
}

