/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.client;

import com.github.ptran779.aegisops.Utils;
import com.github.ptran779.aegisops.client.AgentAdvanceConfigScreen;
import com.github.ptran779.aegisops.entity.agent.AbstractAgentEntity;
import com.github.ptran779.aegisops.entity.inventory.AgentAdvanceConfigMenu;
import com.github.ptran779.aegisops.entity.inventory.AgentInventoryMenu;
import com.github.ptran779.aegisops.network.Agent.AgentDismissPacket;
import com.github.ptran779.aegisops.network.Agent.AgentFollowPacket;
import com.github.ptran779.aegisops.network.Agent.AgentHostilePacket;
import com.github.ptran779.aegisops.network.Agent.AgentSpecialPacket;
import com.github.ptran779.aegisops.network.PacketHandler;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class AgentInventoryScreen
extends AbstractContainerScreen<AgentInventoryMenu> {
    private static final Font font = Minecraft.m_91087_().f_91062_;
    private static final ResourceLocation CONTAINER_BACKGROUND = new ResourceLocation("aegisops", "textures/inventory.png");
    private final Player player;
    private final AbstractAgentEntity agent;
    DecimalFormat df = new DecimalFormat("#.#");

    protected void m_7856_() {
        super.m_7856_();
        PlainTextButton movementBtn = new PlainTextButton(this.f_97735_ + 227, this.f_97736_ + 7, 65, 25, (Component)Component.m_237119_(), btn -> {
            int next = (this.agent.getFollowMode().ordinal() + 1) % Utils.FollowMode.values().length;
            PacketHandler.CHANNELS.sendToServer((Object)new AgentFollowPacket(this.agent.m_19879_(), next, this.player.m_20148_()));
        }, font);
        movementBtn.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Toggle Movement Mode")));
        this.m_142416_((GuiEventListener)movementBtn);
        PlainTextButton targetingBtn = new PlainTextButton(this.f_97735_ + 227, this.f_97736_ + 36, 65, 25, (Component)Component.m_237119_(), btn -> {
            int next = (this.agent.getTargetMode().ordinal() + 1) % Utils.TargetMode.values().length;
            PacketHandler.CHANNELS.sendToServer((Object)new AgentHostilePacket(this.agent.m_19879_(), next));
        }, font);
        targetingBtn.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Toggle Targeting Mode")));
        this.m_142416_((GuiEventListener)targetingBtn);
        PlainTextButton specialBtn = new PlainTextButton(this.f_97735_ + 227, this.f_97736_ + 65, 65, 25, (Component)Component.m_237119_(), btn -> PacketHandler.CHANNELS.sendToServer((Object)new AgentSpecialPacket(this.agent.m_19879_(), !this.agent.getAllowSpecial())), font);
        specialBtn.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Toggle Special Move")));
        this.m_142416_((GuiEventListener)specialBtn);
        PlainTextButton dismissBtn = new PlainTextButton(this.f_97735_ + 227, this.f_97736_ + 151, 65, 15, (Component)Component.m_237119_(), btn -> {
            PacketHandler.CHANNELS.sendToServer((Object)new AgentDismissPacket(this.agent.m_19879_(), true));
            Minecraft.m_91087_().m_91152_(null);
        }, font);
        dismissBtn.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Dismiss Agent")));
        this.m_142416_((GuiEventListener)dismissBtn);
        PlainTextButton advanceCfg = new PlainTextButton(this.f_97735_ + 205, this.f_97736_ + 37, 18, 18, (Component)Component.m_237119_(), btn -> Minecraft.m_91087_().m_91152_((Screen)new AgentAdvanceConfigScreen(new AgentAdvanceConfigMenu(((AgentInventoryMenu)this.f_97732_).f_38840_, this.player.m_150109_(), ((AgentInventoryMenu)this.f_97732_).agent), this.player.m_150109_(), this.f_169604_)), font);
        advanceCfg.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Advance Configuration")));
        this.m_142416_((GuiEventListener)advanceCfg);
    }

    public AgentInventoryScreen(AgentInventoryMenu container, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)container, pPlayerInventory, pTitle);
        this.f_97727_ = 166;
        this.f_97726_ = 300;
        this.agent = container.agent;
        this.f_97731_ = this.f_97727_ - 94;
        this.player = pPlayerInventory.f_35978_;
        this.df.setRoundingMode(RoundingMode.CEILING);
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
        this.renderCom(pGuiGraphics);
    }

    protected void renderCom(GuiGraphics pGuiGraphics) {
        Vec3 look = this.agent.m_20154_();
        double angleRad = Math.atan2(-look.f_82481_, look.f_82479_);
        float pitch = (float)Math.PI;
        float yaw = 1.5707964f + (float)angleRad;
        Quaternionf pose = new Quaternionf().rotationYXZ(yaw, -pitch, 0.0f);
        InventoryScreen.m_280432_((GuiGraphics)pGuiGraphics, (int)(this.f_97735_ + 33), (int)(this.f_97736_ + 72), (int)30, (Quaternionf)pose, null, (LivingEntity)this.agent);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        this.m_280273_(pGuiGraphics);
        pGuiGraphics.m_280163_(CONTAINER_BACKGROUND, (this.f_96543_ - this.f_97726_) / 2, (this.f_96544_ - this.f_97727_) / 2, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 300, 166);
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.m_280056_(font, this.agent.m_7755_().getString() + " the " + this.agent.agentType, 65, 15, 53247, false);
        pGuiGraphics.m_280056_(font, "Commander: " + this.agent.getOwner(), 65, 40, 53247, false);
        String followDisp = switch (this.agent.getFollowMode()) {
            default -> throw new IncompatibleClassChangeError();
            case Utils.FollowMode.STAY -> "Guard";
            case Utils.FollowMode.FOLLOW -> "Follow";
            case Utils.FollowMode.WANDER -> "Wander";
        };
        pGuiGraphics.m_280056_(font, followDisp, 242, 16, 53247, false);
        String hostileDisp = switch (this.agent.getTargetMode()) {
            default -> throw new IncompatibleClassChangeError();
            case Utils.TargetMode.OFF -> "None";
            case Utils.TargetMode.HOSTILE_ONLY -> "Hostile";
            case Utils.TargetMode.ENEMY_AGENTS -> "Humanoid";
            case Utils.TargetMode.ALL -> "All";
        };
        pGuiGraphics.m_280056_(font, hostileDisp, 242, 44, 53247, false);
        pGuiGraphics.m_280056_(font, this.agent.getAllowSpecial() ? "Spec On" : "Spec Off", 242, 72, 53247, false);
        pGuiGraphics.m_280056_(font, this.agent.getVirtualAmmo() + "/" + this.agent.getMaxVirtualAmmo(), 242, 100, 53247, false);
        pGuiGraphics.m_280056_(font, this.agent.getFood() + "/" + this.agent.maxfood, 242, 128, 53247, false);
    }

    protected void m_280072_(GuiGraphics pGuiGraphics, int x, int y) {
        super.m_280072_(pGuiGraphics, x, y);
        if (this.isHovering(x, y, this.f_97735_ + 227, this.f_97736_ + 94, 65, 25)) {
            pGuiGraphics.m_280557_(font, (Component)Component.m_237113_((String)"Virtual Ammo"), x, y);
        } else if (this.isHovering(x, y, this.f_97735_ + 227, this.f_97736_ + 123, 65, 25)) {
            pGuiGraphics.m_280557_(font, (Component)Component.m_237113_((String)"Food"), x, y);
        }
    }

    private boolean isHovering(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }
}

