/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.client;

import com.github.ptran779.aegisops.client.IBoneHierachy;
import com.github.ptran779.aegisops.entity.agent.AbstractAgentEntity;
import java.util.List;
import java.util.Map;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import org.joml.Vector3f;

public class AnimationHelper {
    private static final Vector3f scratch = new Vector3f();

    public static void animate(IBoneHierachy model, AnimationDefinition animDef, float timeSeconds, float scale, boolean loop) {
        model.getRoot().m_171331_().forEach(ModelPart::m_233569_);
        AnimationHelper.recurseAndApply(model.getRootBoneName(), model, animDef.f_232257_(), loop ? timeSeconds % animDef.f_232255_() : timeSeconds, scale);
    }

    public static void animateHumanoid(PlayerModel<AbstractAgentEntity> model, AnimationDefinition animDef, Map<String, ModelPart> boneKeys, float timeSeconds, float scale, boolean loop) {
        float aniTime = timeSeconds;
        if (loop) {
            aniTime = timeSeconds % animDef.f_232255_();
        }
        for (String boneKey : boneKeys.keySet()) {
            List animBones = (List)animDef.f_232257_().get(boneKey);
            if (animBones == null) continue;
            AnimationHelper.applyAnimation(boneKeys.get(boneKey), animBones, aniTime, scale);
        }
        model.f_103374_.m_104315_(model.f_102812_);
        model.f_103375_.m_104315_(model.f_102811_);
        model.f_103376_.m_104315_(model.f_102814_);
        model.f_103377_.m_104315_(model.f_102813_);
        model.f_103378_.m_104315_(model.f_102810_);
        model.f_102809_.m_104315_(model.f_102808_);
    }

    private static void recurseAndApply(String partName, IBoneHierachy model, Map<String, List<AnimationChannel>> channels, float timeSeconds, float scale) {
        AnimationHelper.applyAnimation(model.get(partName), channels.get(partName), timeSeconds, scale);
        List<String> childs = model.getBoneChild(partName);
        if (childs == null) {
            return;
        }
        for (String child : childs) {
            AnimationHelper.recurseAndApply(child, model, channels, timeSeconds, scale);
        }
    }

    private static void applyAnimation(ModelPart part, List<AnimationChannel> channels, float timeSeconds, float scale) {
        if (channels == null) {
            return;
        }
        for (AnimationChannel channel : channels) {
            Keyframe[] keyframes = channel.f_232212_();
            if (keyframes.length == 0) continue;
            int i = Math.max(0, Mth.m_14049_((int)0, (int)keyframes.length, k -> timeSeconds <= keyframes[k].f_232283_()) - 1);
            int j = Math.min(keyframes.length - 1, i + 1);
            Keyframe from = keyframes[i];
            Keyframe to = keyframes[j];
            float t = j != i ? Mth.m_14036_((float)((timeSeconds - from.f_232283_()) / (to.f_232283_() - from.f_232283_())), (float)0.0f, (float)1.0f) : 0.0f;
            to.f_232285_().m_232222_(scratch, t, keyframes, i, j, scale);
            channel.f_232211_().m_232247_(part, scratch);
        }
    }
}

