/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.client;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class DropDownWidget
extends AbstractWidget {
    private final List<String> options = new ArrayList<String>();
    private final Consumer<String> onSelect;
    private boolean open = false;
    private int scroll = 0;
    private String currentOption = "";
    private static final int MAX_VISIBLE = 6;
    private static final int ENTRY_HEIGHT = 14;

    public DropDownWidget(int x, int y, int width, int height, Iterable<String> options, String currentOption, Consumer<String> onSelect) {
        super(x, y, width, height, (Component)Component.m_237113_((String)"Select Skin"));
        options.forEach(this.options::add);
        this.currentOption = currentOption;
        this.onSelect = onSelect;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        this.m_5716_(mouseX, mouseY);
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (!this.open) {
            return false;
        }
        if (this.options.size() <= 6) {
            return false;
        }
        int startY = this.m_252907_() + this.f_93619_;
        int endY = startY + 84;
        if (mouseX < (double)this.m_252754_() || mouseX > (double)(this.m_252754_() + this.f_93618_) || mouseY < (double)startY || mouseY > (double)endY) {
            return false;
        }
        this.scroll = (int)((double)this.scroll - Math.signum(delta));
        this.scroll = Math.max(0, Math.min(this.scroll, this.options.size() - 6));
        return true;
    }

    public void m_5716_(double mouseX, double mouseY) {
        if (mouseX >= (double)this.m_252754_() && mouseX <= (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY <= (double)(this.m_252907_() + this.f_93619_)) {
            this.open = !this.open;
            return;
        }
        if (this.open) {
            int startY = this.m_252907_() + this.f_93619_;
            int endY = startY + 84;
            if (mouseX >= (double)this.m_252754_() && mouseX <= (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)startY && mouseY <= (double)endY) {
                int idx = (int)((mouseY - (double)startY) / 14.0) + this.scroll;
                if (idx >= 0 && idx < this.options.size()) {
                    this.onSelect.accept(this.options.get(idx));
                    this.currentOption = this.options.get(idx);
                    this.open = false;
                }
            } else {
                this.open = false;
            }
        }
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    protected void m_87963_(GuiGraphics g, int mouseX, int mouseY, float delta) {
        int idx;
        g.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -11184811);
        g.m_280488_(Minecraft.m_91087_().f_91062_, this.currentOption, this.m_252754_() + 2, this.m_252907_() + 2, 0xFFFFFF);
        if (!this.open) {
            return;
        }
        int startY = this.m_252907_() + this.f_93619_;
        g.m_280509_(this.m_252754_(), startY, this.m_252754_() + this.f_93618_, startY + 84, -13421773);
        for (int i = 0; i < 6 && (idx = this.scroll + i) < this.options.size(); ++i) {
            int y = startY + i * 14;
            g.m_280488_(Minecraft.m_91087_().f_91062_, this.options.get(idx), this.m_252754_() + 2, y + 3, 0xFFFFFF);
        }
        if (this.options.size() > 6) {
            int arrowX = this.m_252754_() + this.f_93618_ + 3;
            g.m_280488_(Minecraft.m_91087_().f_91062_, "\u25b2", arrowX, startY, 0xFFFFFF);
            g.m_280488_(Minecraft.m_91087_().f_91062_, "\u25bc", arrowX, startY + 84 - 10, 0xFFFFFF);
        }
    }
}

