/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.client.render;

import com.github.ptran779.aegisops.client.AnimationHelper;
import com.github.ptran779.aegisops.client.animation.DBTurretAnimation;
import com.github.ptran779.aegisops.client.model.DBTurretModel;
import com.github.ptran779.aegisops.client.model.DBTurretReadyModel;
import com.github.ptran779.aegisops.entity.structure.DBTurret;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class DBTurretRender
extends EntityRenderer<DBTurret> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("aegisops", "textures/entities/dbturret.png");
    private final DBTurretModel model;
    private final DBTurretReadyModel modelReady;

    public DBTurretRender(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new DBTurretModel(pContext.m_174023_(DBTurretModel.LAYER_LOCATION));
        this.modelReady = new DBTurretReadyModel(pContext.m_174023_(DBTurretReadyModel.LAYER_LOCATION));
    }

    public void render(DBTurret pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.0, 1.8, 0.0);
        pPoseStack.m_85841_(-1.25f, -1.25f, 1.25f);
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        if (!((Boolean)pEntity.m_20088_().m_135370_(DBTurret.DEPLOYED)).booleanValue()) {
            float time = Math.max(((float)pEntity.f_19797_ + pPartialTick + -40.0f) / 20.0f, 0.0f);
            AnimationHelper.animate(this.model, DBTurretAnimation.deploy, time, 1.0f, false);
            VertexConsumer vertexConsumer = pBuffer.m_6299_(this.model.m_103119_(TEXTURE));
            this.model.m_7695_(pPoseStack, vertexConsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            this.modelReady.Main.m_171331_().forEach(ModelPart::m_233569_);
            this.modelReady.Head.f_104203_ = (float)Math.toRadians(pEntity.m_146909_());
            this.modelReady.Neck.f_104204_ = (float)Math.toRadians(pEntity.m_6080_());
            if (pEntity.cannonProgress < 16.0f) {
                ModelPart cBarrel;
                pEntity.cannonProgress += pPartialTick;
                ModelPart cTip = (Boolean)pEntity.m_20088_().m_135370_(DBTurret.LEFT_BARREL) != false ? this.modelReady.LCtip : this.modelReady.RCtip;
                ModelPart modelPart = cBarrel = (Boolean)pEntity.m_20088_().m_135370_(DBTurret.LEFT_BARREL) != false ? this.modelReady.LBarrel : this.modelReady.RBarrel;
                if (pEntity.cannonProgress < 2.0f) {
                    cTip.f_104201_ -= pEntity.cannonProgress / 2.0f * 5.0f;
                    cBarrel.f_104202_ += pEntity.cannonProgress / 2.0f * 1.0f;
                } else if (pEntity.cannonProgress < 16.0f) {
                    cTip.f_104201_ -= (1.0f - (pEntity.cannonProgress - 2.0f) / 14.0f) * 5.0f;
                    cBarrel.f_104202_ += (1.0f - (pEntity.cannonProgress - 2.0f) / 14.0f) * 1.0f;
                }
            }
            VertexConsumer vertexConsumer = pBuffer.m_6299_(this.modelReady.m_103119_(TEXTURE));
            this.modelReady.m_7695_(pPoseStack, vertexConsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        pPoseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(DBTurret turret) {
        return TEXTURE;
    }
}

