/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.client.render;

import com.github.ptran779.aegisops.client.AnimationHelper;
import com.github.ptran779.aegisops.client.animation.PortDispAnimation;
import com.github.ptran779.aegisops.client.model.PortDispModel;
import com.github.ptran779.aegisops.entity.structure.PortDisp;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class PortDispRender
extends EntityRenderer<PortDisp> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("aegisops", "textures/entities/portdisp.png");
    private final PortDispModel model;

    public PortDispRender(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new PortDispModel(pContext.m_174023_(PortDispModel.LAYER_LOCATION));
    }

    public void render(PortDisp disp, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.0, 1.5, 0.0);
        pPoseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        float aniTick = (float)disp.f_19797_ - disp.timeTrigger + pPartialTick;
        if (disp.getOpen()) {
            AnimationHelper.animate(this.model, PortDispAnimation.DEPLOY, aniTick / 20.0f, 1.0f, false);
        } else if (aniTick < PortDispAnimation.DEPLOY.f_232255_() * 20.0f) {
            AnimationHelper.animate(this.model, PortDispAnimation.DEPLOY, PortDispAnimation.DEPLOY.f_232255_() - aniTick / 20.0f, 1.0f, false);
        } else {
            this.model.getRoot().m_171331_().forEach(ModelPart::m_233569_);
        }
        VertexConsumer vertexConsumer = pBuffer.m_6299_(this.model.m_103119_(TEXTURE));
        this.model.m_7695_(pPoseStack, vertexConsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        pPoseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(PortDisp disp) {
        return TEXTURE;
    }
}

