/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.config;

import com.github.ptran779.aegisops.config.AgentConfig;
import com.github.ptran779.aegisops.entity.agent.Demolition;
import com.github.ptran779.aegisops.entity.agent.Engineer;
import com.github.ptran779.aegisops.entity.agent.Heavy;
import com.github.ptran779.aegisops.entity.agent.Medic;
import com.github.ptran779.aegisops.entity.agent.Sniper;
import com.github.ptran779.aegisops.entity.agent.Soldier;
import com.github.ptran779.aegisops.entity.agent.Swordman;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.resource.index.CommonGunIndex;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public class AgentConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = Path.of("config/aegisops/classes", new String[0]);
    private static final Map<String, AgentConfig> CLASS_CONFIGS = new HashMap<String, AgentConfig>();

    public static void reloadCache() {
        CLASS_CONFIGS.clear();
        try {
            if (!Files.exists(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(CONFIG_DIR, "*.json");){
                for (Path file : stream) {
                    String classId = file.getFileName().toString().replace(".json", "");
                    try {
                        BufferedReader reader = Files.newBufferedReader(file);
                        try {
                            AgentConfig config = (AgentConfig)GSON.fromJson((Reader)reader, AgentConfig.class);
                            if (config == null) continue;
                            CLASS_CONFIGS.put(classId, config);
                        }
                        finally {
                            if (reader == null) continue;
                            ((Reader)reader).close();
                        }
                    }
                    catch (IOException e) {
                        System.err.println("[AegisOps] Failed to read config for class: " + classId);
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException e) {
            System.err.println("[AegisOps] Failed to scan config folder.");
            e.printStackTrace();
        }
    }

    private static void loadOrGenerateClassConfig(String classId, List<GunTabType> defaultGunTypes, int maxVirtAmmo, int chargePerAmmo) {
        AgentConfig result;
        block22: {
            Path path = CONFIG_DIR.resolve(classId + ".json");
            AgentConfig defaultConfig = new AgentConfig();
            defaultConfig.allowGuns = AgentConfigManager.getDefaultGuns(defaultGunTypes);
            defaultConfig.allowMelees = AgentConfigManager.getDefaultMelees();
            defaultConfig.maxVirtualAmmo = maxVirtAmmo;
            defaultConfig.chargePerAmmo = chargePerAmmo;
            try {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
                if (!Files.exists(path, new LinkOption[0])) {
                    try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                        GSON.toJson((Object)defaultConfig, (Appendable)writer);
                        result = defaultConfig;
                        break block22;
                    }
                }
                try (BufferedReader reader = Files.newBufferedReader(path);){
                    AgentConfig loaded = (AgentConfig)GSON.fromJson((Reader)reader, AgentConfig.class);
                    if (loaded != null && loaded.isValid()) {
                        result = loaded;
                        break block22;
                    }
                    System.err.println("[AegisOps] Invalid or incomplete config for " + classId + ", regenerating...");
                    try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                        GSON.toJson((Object)defaultConfig, (Appendable)writer);
                        result = defaultConfig;
                    }
                }
            }
            catch (IOException e) {
                System.err.println("[AegisOps] Failed to load or write config for: " + classId);
                e.printStackTrace();
                result = defaultConfig;
            }
        }
        CLASS_CONFIGS.put(classId, result);
    }

    private static Set<String> getDefaultGuns(List<GunTabType> defaultGunTypes) {
        Set allowedTypes = defaultGunTypes.stream().map(type -> type.name().toLowerCase(Locale.US)).collect(Collectors.toSet());
        HashSet<String> defaultGuns = new HashSet<String>();
        TimelessAPI.getAllCommonGunIndex().forEach(entry -> {
            String gunType = ((CommonGunIndex)entry.getValue()).getType();
            if (allowedTypes.contains(gunType)) {
                defaultGuns.add(((ResourceLocation)entry.getKey()).toString());
            }
        });
        return defaultGuns;
    }

    private static Set<String> getDefaultMelees() {
        HashSet<String> defaultMelees = new HashSet<String>();
        defaultMelees.add("minecraft:wooden_sword");
        defaultMelees.add("minecraft:stone_sword");
        defaultMelees.add("minecraft:iron_sword");
        defaultMelees.add("minecraft:golden_sword");
        defaultMelees.add("minecraft:diamond_sword");
        defaultMelees.add("minecraft:netherite_sword");
        defaultMelees.add("minecraft:wooden_axe");
        defaultMelees.add("minecraft:stone_axe");
        defaultMelees.add("minecraft:iron_axe");
        defaultMelees.add("minecraft:golden_axe");
        defaultMelees.add("minecraft:diamond_axe");
        defaultMelees.add("minecraft:netherite_axe");
        return defaultMelees;
    }

    private static AgentConfig getConfig(String classId) {
        AgentConfig out = CLASS_CONFIGS.get(classId);
        if (out == null) {
            return new AgentConfig();
        }
        return out;
    }

    public static void serverGenerateDefault() {
        AgentConfigManager.loadOrGenerateClassConfig("soldier", List.of(GunTabType.PISTOL, GunTabType.RIFLE, GunTabType.SMG), 100, 1);
        AgentConfigManager.loadOrGenerateClassConfig("sniper", List.of(GunTabType.PISTOL, GunTabType.RIFLE, GunTabType.SNIPER), 50, 3);
        AgentConfigManager.loadOrGenerateClassConfig("heavy", List.of(GunTabType.PISTOL, GunTabType.SHOTGUN, GunTabType.MG), 200, 2);
        AgentConfigManager.loadOrGenerateClassConfig("demolition", List.of(GunTabType.PISTOL, GunTabType.SMG), 100, 1);
        AgentConfigManager.loadOrGenerateClassConfig("medic", List.of(GunTabType.PISTOL, GunTabType.SMG), 100, 1);
        AgentConfigManager.loadOrGenerateClassConfig("engineer", List.of(GunTabType.PISTOL, GunTabType.RIFLE), 100, 1);
        AgentConfigManager.loadOrGenerateClassConfig("swordman", List.of(GunTabType.PISTOL, GunTabType.SHOTGUN), 50, 2);
        AgentConfigManager.reloadCache();
        Soldier.updateClassConfig(AgentConfigManager.getConfig("soldier"));
        Sniper.updateClassConfig(AgentConfigManager.getConfig("sniper"));
        Heavy.updateClassConfig(AgentConfigManager.getConfig("heavy"));
        Demolition.updateClassConfig(AgentConfigManager.getConfig("demolition"));
        Medic.updateClassConfig(AgentConfigManager.getConfig("medic"));
        Engineer.updateClassConfig(AgentConfigManager.getConfig("engineer"));
        Swordman.updateClassConfig(AgentConfigManager.getConfig("swordman"));
    }
}

