/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.entity.structure;

import com.github.ptran779.aegisops.entity.api.IEntityRender;
import com.github.ptran779.aegisops.entity.api.IEntityTeam;
import java.util.Collections;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class AbstractAgentStruct
extends Mob
implements IEntityTeam,
IEntityRender {
    private UUID bossUUID;
    public int charge = 0;

    public AbstractAgentStruct(EntityType<? extends Mob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21530_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21183_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    @Override
    public UUID getBossUUID() {
        return this.bossUUID;
    }

    public void setBossUUID(UUID bossID) {
        this.bossUUID = bossID;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Level level;
        LivingEntity living;
        Entity entity = source.m_7639_();
        if (entity != null && entity instanceof LivingEntity && !this.sameTeam(living = (LivingEntity)entity)) {
            this.m_6710_(living);
        }
        if ((level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123798_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 4, 0.2, 0.2, 0.2, 0.01);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 4, 0.2, 0.2, 0.2, 0.01);
        }
        return super.m_6469_(source, amount);
    }

    protected boolean sameTeam(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return this.isFriendlyPlayer(player, this.m_9236_());
        }
        if (entity instanceof IEntityTeam) {
            IEntityTeam teamer = (IEntityTeam)entity;
            return this.isFriendlyMod(teamer, this.m_9236_());
        }
        return false;
    }

    public Iterable<ItemStack> m_6168_() {
        return Collections.emptyList();
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot equipmentSlot, ItemStack itemStack) {
    }

    public HumanoidArm m_5737_() {
        return null;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_147240_(double strength, double xRatio, double zRatio) {
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("charge", this.charge);
        if (this.getBossUUID() != null) {
            nbt.m_128362_("owner_uuid", this.getBossUUID());
        }
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.charge = nbt.m_128451_("charge");
        if (nbt.m_128441_("owner_uuid")) {
            this.setBossUUID(nbt.m_128342_("owner_uuid"));
        } else {
            this.setBossUUID(null);
        }
    }

    public int getMaxCharge() {
        return 0;
    }
}

