/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.goal.special;

import com.github.ptran779.aegisops.Utils;
import com.github.ptran779.aegisops.config.ServerConfig;
import com.github.ptran779.aegisops.entity.agent.AbstractAgentEntity;
import com.github.ptran779.aegisops.entity.extra.VectorPursuer;
import com.github.ptran779.aegisops.goal.AbstractThrottleGoal;
import com.github.ptran779.aegisops.item.VPTerminalItem;
import com.github.ptran779.aegisops.network.PacketHandler;
import com.github.ptran779.aegisops.network.render.EntityRenderPacket;
import com.github.ptran779.aegisops.server.EntityInit;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;

public class DeployVPGoal
extends AbstractThrottleGoal {
    AbstractAgentEntity agent;
    protected int lastCooldown;
    protected final int COOLDOWN;
    public static final double SCAN_DISTANCE = 40.0;
    protected boolean done = false;
    LivingEntity target;

    public DeployVPGoal(AbstractAgentEntity agent, int checkInterval, int cooldown) {
        super((LivingEntity)agent, checkInterval);
        this.agent = agent;
        this.COOLDOWN = cooldown;
        this.lastCooldown = agent.f_19797_;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    @Override
    public boolean m_8036_() {
        if (!(this.agent.getAllowSpecial() && this.agent.getTargetMode() != Utils.TargetMode.OFF && this.agent.f_19797_ - this.lastCooldown >= this.COOLDOWN && this.agent.getSpecialSlot().m_41720_() instanceof VPTerminalItem && super.m_8036_())) {
            return false;
        }
        this.resetThrottle();
        this.target = Utils.findNearestEntity(this.agent, LivingEntity.class, 40.0, entity -> entity.m_21223_() >= (float)((Integer)ServerConfig.VP_MIN_TARGET_HEALTH.get()).intValue() && this.agent.shouldTargetEntity(this.agent, (LivingEntity)entity));
        return this.target != null && this.target.m_6084_();
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8056_() {
        this.agent.setSpecialMove(1);
        PacketHandler.CHANNELS.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.agent), (Object)new EntityRenderPacket(this.agent.m_19879_(), 1));
        this.lastCooldown = this.agent.f_19797_;
        this.done = false;
    }

    public boolean m_8045_() {
        return !this.done && this.agent.getSpecialSlot().m_41720_() instanceof VPTerminalItem;
    }

    public void m_8041_() {
        this.agent.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
        this.agent.setAniMove(Utils.AniMove.NORM);
        this.lastCooldown = this.agent.f_19797_;
    }

    public void m_8037_() {
        int dummy = this.agent.f_19797_ - this.lastCooldown;
        if (this.target == null || !this.target.m_6084_()) {
            this.done = true;
            return;
        }
        this.agent.m_21563_().m_148051_((Entity)this.target);
        if (dummy == 10) {
            this.agent.equipSpecial(true);
            this.agent.m_9236_().m_6263_(null, this.agent.m_20185_(), this.agent.m_20186_(), this.agent.m_20189_(), (SoundEvent)SoundEvents.f_12170_.m_203334_(), SoundSource.PLAYERS, 1.0f, 1.25f);
        } else if (dummy == 30) {
            this.agent.m_9236_().m_6263_(null, this.agent.m_20185_(), this.agent.m_20186_(), this.agent.m_20189_(), (SoundEvent)SoundEvents.f_12170_.m_203334_(), SoundSource.PLAYERS, 1.0f, 1.25f);
        } else if (dummy == 20 || dummy == 40) {
            this.agent.m_9236_().m_6263_(null, this.agent.m_20185_(), this.agent.m_20186_(), this.agent.m_20189_(), (SoundEvent)SoundEvents.f_12170_.m_203334_(), SoundSource.PLAYERS, 1.0f, 0.75f);
        } else if (dummy == 50) {
            VectorPursuer drone = new VectorPursuer((EntityType<? extends VectorPursuer>)((EntityType)EntityInit.VECTOR_PURSUER.get()), this.agent.m_9236_());
            this.agent.m_9236_().m_6263_(null, this.agent.m_20185_(), this.agent.m_20186_(), this.agent.m_20189_(), (SoundEvent)SoundEvents.f_12170_.m_203334_(), SoundSource.PLAYERS, 1.0f, 1.25f);
            drone.m_6034_(this.agent.m_20185_(), this.agent.m_20186_() + 1.0, this.agent.m_20189_());
            drone.deployerUUID = this.agent.m_20148_();
            drone.m_6710_(this.target);
            this.agent.m_9236_().m_7967_((Entity)drone);
            this.agent.getSpecialSlot().m_41774_(1);
        } else if (dummy == 60) {
            this.done = true;
        }
    }
}

