/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.goal.special;

import com.github.ptran779.aegisops.Utils;
import com.github.ptran779.aegisops.config.ServerConfig;
import com.github.ptran779.aegisops.entity.agent.AbstractAgentEntity;
import com.github.ptran779.aegisops.entity.extra.Grenade;
import com.github.ptran779.aegisops.goal.AbstractThrottleGoal;
import com.github.ptran779.aegisops.item.GrenadeItem;
import com.github.ptran779.aegisops.network.PacketHandler;
import com.github.ptran779.aegisops.network.render.EntityRenderPacket;
import com.github.ptran779.aegisops.server.EntityInit;
import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class ThrowGrenadeGoal
extends AbstractThrottleGoal {
    AbstractAgentEntity agent;
    protected int lastCooldown;
    protected final int COOLDOWN;
    protected final int CLUSTER_RADIUS = 3;
    protected boolean done;
    protected LivingEntity target;
    public final double[] THROW_ANGLES = new double[]{15.0, 30.0, 45.0, 60.0, 75.0};
    public final double RAY_ANGLE_OFFSET = 5.0;
    public final double SCAN_DISTANCE = 6.0;

    public ThrowGrenadeGoal(AbstractAgentEntity agent, int checkInterval, int cooldown) {
        super((LivingEntity)agent, checkInterval);
        this.agent = agent;
        this.COOLDOWN = cooldown;
        this.lastCooldown = agent.f_19797_;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    @Override
    public boolean m_8036_() {
        if (!(this.agent.getAllowSpecial() && this.agent.f_19797_ - this.lastCooldown >= this.COOLDOWN && this.agent.getSpecialSlot().m_41720_() instanceof GrenadeItem && super.m_8036_())) {
            return false;
        }
        this.resetThrottle();
        this.target = this.agent.m_5448_();
        if (this.target == null || !this.target.m_6084_()) {
            return false;
        }
        int clusterCount = this.agent.m_9236_().m_6443_(LivingEntity.class, this.target.m_20191_().m_82400_(3.0), e -> this.agent.shouldTargetEntity(this.agent, (LivingEntity)e)).size();
        return clusterCount >= (Integer)ServerConfig.GRENADE_CLUSTER.get();
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8056_() {
        this.agent.setSpecialMove(0);
        PacketHandler.CHANNELS.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.agent), (Object)new EntityRenderPacket(this.agent.m_19879_(), 1));
        this.lastCooldown = this.agent.f_19797_;
        this.done = false;
        this.target = this.agent.m_5448_();
    }

    public boolean m_8045_() {
        return !this.done && this.agent.getSpecialSlot().m_41720_() instanceof GrenadeItem;
    }

    public void m_8041_() {
        this.agent.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        this.agent.setAniMove(Utils.AniMove.NORM);
        this.lastCooldown = this.agent.f_19797_;
    }

    public void m_8037_() {
        if (this.target == null || !this.target.m_6084_()) {
            this.done = true;
            return;
        }
        int dummy = this.agent.f_19797_ - this.lastCooldown;
        this.agent.m_21563_().m_148051_((Entity)this.target);
        if (dummy == 3) {
            this.agent.equipSpecial(false);
        } else if (dummy == 25) {
            this.agent.getSpecialSlot().m_41784_().m_128356_("DeployTick", this.agent.m_9236_().m_46467_());
        } else if (dummy == 60) {
            Vec3 from = this.agent.m_146892_();
            Vec3 delta = this.target.m_20182_().m_82520_(0.0, 1.0, 0.0).m_82546_(from);
            double dxz = Math.hypot(delta.f_82479_, delta.f_82481_);
            if (dxz < 1.0E-6) {
                return;
            }
            Vec3 flat = new Vec3(delta.f_82479_ / dxz, 0.0, delta.f_82481_ / dxz);
            double speedNeeded = -1.0;
            double angleNeeded = 0.0;
            for (double angle : this.THROW_ANGLES) {
                double speed;
                double v2;
                double testRad = Math.toRadians(angle - 5.0);
                double cosT = Math.cos(testRad);
                double sinT = Math.sin(testRad);
                Vec3 testDir = new Vec3(flat.f_82479_ * cosT, sinT, flat.f_82481_ * cosT).m_82541_();
                Vec3 rayEnd = from.m_82549_(testDir.m_82490_(6.0));
                if (this.agent.m_9236_().m_45547_(new ClipContext(from, rayEnd, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null)).m_6662_() != HitResult.Type.MISS) continue;
                double pitch = Math.toRadians(angle);
                double cosP = Math.cos(pitch);
                double tanP = Math.tan(pitch);
                double denom = 2.0 * (dxz * tanP - delta.f_82480_) * cosP * cosP;
                if (denom <= 0.0 || (v2 = (double)0.04f * dxz * dxz / denom) <= 0.0 || (speed = Math.sqrt(v2)) > 1.15) continue;
                speedNeeded = speed;
                angleNeeded = angle;
                break;
            }
            if (speedNeeded > 0.0) {
                Vec3 throwDir = new Vec3(flat.f_82479_ * Math.cos(Math.toRadians(angleNeeded)), Math.sin(Math.toRadians(angleNeeded)), flat.f_82481_ * Math.cos(Math.toRadians(angleNeeded))).m_82541_();
                Grenade g = new Grenade((EntityType<? extends Grenade>)((EntityType)EntityInit.GRENADE.get()), this.agent.m_9236_());
                g.m_6034_(this.agent.m_20185_(), this.agent.m_20188_() - 0.1, this.agent.m_20189_());
                g.setFuseTick(100);
                g.m_20256_(throwDir.m_82490_(speedNeeded));
                this.agent.m_9236_().m_7967_((Entity)g);
                this.agent.getSpecialSlot().m_41774_(1);
                this.agent.getSpecialSlot().m_41784_().m_128473_("DeployTick");
            }
            this.agent.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        } else if (dummy >= 90) {
            this.done = true;
        }
    }
}

