/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.network.Agent;

import com.github.ptran779.aegisops.entity.agent.AbstractAgentEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class AgentDismissPacket {
    private final int entityId;
    private final boolean payload;

    public AgentDismissPacket(int entityId, boolean flag) {
        this.entityId = entityId;
        this.payload = flag;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeBoolean(this.payload);
    }

    public static AgentDismissPacket decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        boolean payload = buf.readBoolean();
        return new AgentDismissPacket(entityId, payload);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Entity e = player.m_9236_().m_6815_(this.entityId);
            if (!(e instanceof AbstractAgentEntity)) {
                return;
            }
            AbstractAgentEntity agent = (AbstractAgentEntity)e;
            agent.setBossUUID(null);
        });
        ctx.get().setPacketHandled(true);
    }
}

