/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.network.Agent;

import com.github.ptran779.aegisops.Utils;
import com.github.ptran779.aegisops.entity.agent.AbstractAgentEntity;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class AgentFollowPacket {
    private final int entityId;
    private final int payload;
    private final UUID targetUUID;

    public AgentFollowPacket(int entityId, int flag, UUID targetUUID) {
        this.entityId = entityId;
        this.payload = flag;
        this.targetUUID = targetUUID;
    }

    public AgentFollowPacket(int entityId, int flag) {
        this(entityId, flag, null);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.payload);
        buf.m_130077_(this.targetUUID);
    }

    public static AgentFollowPacket decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        int payload = buf.readInt();
        UUID optinalData = buf.m_130259_();
        return new AgentFollowPacket(entityId, payload, optinalData);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Entity patt1480$temp = player.m_9236_().m_6815_(this.entityId);
            if (patt1480$temp instanceof AbstractAgentEntity) {
                AbstractAgentEntity agent = (AbstractAgentEntity)patt1480$temp;
                agent.setFollowMode(Utils.FollowMode.values()[this.payload], this.targetUUID);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

