/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.network.player;

import com.github.ptran779.aegisops.Utils;
import com.github.ptran779.aegisops.entity.agent.AbstractAgentEntity;
import com.github.ptran779.aegisops.player.TaticalCommandProvider;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkEvent;

public class KeyBindPacket {
    private static final int SCAN_RADIUS = 16;
    private final int payload;

    public KeyBindPacket(int payload) {
        this.payload = payload;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.payload);
    }

    public static KeyBindPacket decode(FriendlyByteBuf buf) {
        int payload = buf.readInt();
        return new KeyBindPacket(payload);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            player.getCapability(TaticalCommandProvider.TATICAL_COMMAND_CAPABILITY).ifPresent(cap -> {
                switch (this.payload) {
                    case 0: {
                        cap.cycleFollowMode();
                        player.m_213846_((Component)Component.m_237113_((String)("All nearby agent set to " + (switch (cap.getFollowMode()) {
                            default -> throw new IncompatibleClassChangeError();
                            case Utils.FollowMode.WANDER -> "Wandering";
                            case Utils.FollowMode.STAY -> "Staying Guard";
                            case Utils.FollowMode.FOLLOW -> "Following";
                        }))));
                        AABB scanBox = player.m_20191_().m_82400_(16.0);
                        List agents = player.m_9236_().m_6443_(AbstractAgentEntity.class, scanBox, agent -> agent.isBoss((Player)player));
                        for (AbstractAgentEntity agent2 : agents) {
                            agent2.setFollowMode(cap.getFollowMode(), player.m_20148_());
                        }
                        break;
                    }
                    case 1: {
                        cap.cycleTargetMode();
                        player.m_213846_((Component)Component.m_237113_((String)("All nearby agent set to " + (switch (cap.getTargetMode()) {
                            default -> throw new IncompatibleClassChangeError();
                            case Utils.TargetMode.OFF -> "relax";
                            case Utils.TargetMode.HOSTILE_ONLY -> "hunt hostiles";
                            case Utils.TargetMode.ENEMY_AGENTS -> "hunt enemy agents";
                            case Utils.TargetMode.ALL -> "hunt all dangers";
                        }))));
                        AABB scanBox = player.m_20191_().m_82400_(16.0);
                        List agents = player.m_9236_().m_6443_(AbstractAgentEntity.class, scanBox, agent -> agent.isBoss((Player)player));
                        for (AbstractAgentEntity agent3 : agents) {
                            agent3.setTargetMode(cap.getTargetMode());
                        }
                        break;
                    }
                    case 2: {
                        cap.toggleSpecialMode();
                        player.m_213846_((Component)Component.m_237113_((String)("All nearby agents set to " + (cap.isSpecialMode() ? "use special" : "don't use special"))));
                        AABB scanBox = player.m_20191_().m_82400_(16.0);
                        List agents = player.m_9236_().m_6443_(AbstractAgentEntity.class, scanBox, agent -> agent.isBoss((Player)player));
                        for (AbstractAgentEntity agent4 : agents) {
                            agent4.setAllowSpecial(cap.isSpecialMode());
                        }
                        break;
                    }
                }
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

