/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.network.render;

import com.github.ptran779.aegisops.entity.structure.DBTurret;
import com.github.ptran779.aegisops.entity.structure.PortDisp;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class StructureRenderPacket {
    private final int entityId;
    private final float payload;

    public StructureRenderPacket(int entityId, float payload) {
        this.entityId = entityId;
        this.payload = payload;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeFloat(this.payload);
    }

    public static StructureRenderPacket decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        int payload = buf.readInt();
        return new StructureRenderPacket(entityId, payload);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            Entity entity = level.m_6815_(this.entityId);
            if (entity instanceof DBTurret) {
                DBTurret turret = (DBTurret)entity;
                turret.cannonProgress = this.payload;
            } else if (entity instanceof PortDisp) {
                PortDisp disp = (PortDisp)entity;
                disp.timeTrigger = disp.f_19797_;
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

