/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.Config;

import com.github.ptran779.aegisops.Config.AgentConfig;
import com.github.ptran779.aegisops.entity.Demolition;
import com.github.ptran779.aegisops.entity.Engineer;
import com.github.ptran779.aegisops.entity.Heavy;
import com.github.ptran779.aegisops.entity.Medic;
import com.github.ptran779.aegisops.entity.Sniper;
import com.github.ptran779.aegisops.entity.Soldier;
import com.github.ptran779.aegisops.entity.Swordman;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.resource.index.CommonGunIndex;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public class AgentConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = Path.of("config/aegisops/classes", new String[0]);
    private static final Map<String, AgentConfig> CLASS_CONFIGS = new HashMap<String, AgentConfig>();

    public static void reloadCache() {
        CLASS_CONFIGS.clear();
        try {
            if (!Files.exists(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(CONFIG_DIR, "*.json");){
                for (Path file : stream) {
                    String classId = file.getFileName().toString().replace(".json", "");
                    try {
                        BufferedReader reader = Files.newBufferedReader(file);
                        try {
                            AgentConfig config = (AgentConfig)GSON.fromJson((Reader)reader, AgentConfig.class);
                            if (config == null) continue;
                            CLASS_CONFIGS.put(classId, config);
                        }
                        finally {
                            if (reader == null) continue;
                            ((Reader)reader).close();
                        }
                    }
                    catch (IOException e) {
                        System.err.println("[AegisOps] Failed to read config for class: " + classId);
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException e) {
            System.err.println("[AegisOps] Failed to scan config folder.");
            e.printStackTrace();
        }
    }

    private static void generateDefaultIfMissing(String classId, List<GunTabType> defaultGunTypes) {
        Path path = CONFIG_DIR.resolve(classId + ".json");
        if (!Files.exists(path, new LinkOption[0])) {
            AgentConfig config = new AgentConfig();
            config.allowGuns = AgentConfigManager.getDefaultGuns(defaultGunTypes);
            config.allowMelees = AgentConfigManager.getDefaultMelees();
            try {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                    GSON.toJson((Object)config, (Appendable)writer);
                }
            }
            catch (IOException e) {
                System.err.println("[AegisOps] Failed to write default config for: " + classId);
                e.printStackTrace();
            }
        }
    }

    private static Set<String> getDefaultGuns(List<GunTabType> defaultGunTypes) {
        Set allowedTypes = defaultGunTypes.stream().map(type -> type.name().toLowerCase(Locale.US)).collect(Collectors.toSet());
        HashSet<String> defaultGuns = new HashSet<String>();
        TimelessAPI.getAllCommonGunIndex().forEach(entry -> {
            String gunType = ((CommonGunIndex)entry.getValue()).getType();
            if (allowedTypes.contains(gunType)) {
                defaultGuns.add(((ResourceLocation)entry.getKey()).toString());
            }
        });
        return defaultGuns;
    }

    private static Set<String> getDefaultMelees() {
        HashSet<String> defaultMelees = new HashSet<String>();
        defaultMelees.add("minecraft:wooden_sword");
        defaultMelees.add("minecraft:stone_sword");
        defaultMelees.add("minecraft:iron_sword");
        defaultMelees.add("minecraft:golden_sword");
        defaultMelees.add("minecraft:diamond_sword");
        defaultMelees.add("minecraft:netherite_sword");
        defaultMelees.add("minecraft:wooden_axe");
        defaultMelees.add("minecraft:stone_axe");
        defaultMelees.add("minecraft:iron_axe");
        defaultMelees.add("minecraft:golden_axe");
        defaultMelees.add("minecraft:diamond_axe");
        defaultMelees.add("minecraft:netherite_axe");
        return defaultMelees;
    }

    private static AgentConfig getConfig(String classId) {
        AgentConfig out = CLASS_CONFIGS.get(classId);
        if (out == null) {
            return new AgentConfig();
        }
        return out;
    }

    public static void serverGenerateDefault() {
        AgentConfigManager.generateDefaultIfMissing("soldier", List.of(GunTabType.PISTOL, GunTabType.RIFLE, GunTabType.SMG));
        AgentConfigManager.generateDefaultIfMissing("sniper", List.of(GunTabType.PISTOL, GunTabType.RIFLE, GunTabType.SNIPER));
        AgentConfigManager.generateDefaultIfMissing("heavy", List.of(GunTabType.PISTOL, GunTabType.SHOTGUN, GunTabType.MG));
        AgentConfigManager.generateDefaultIfMissing("demolition", List.of(GunTabType.PISTOL, GunTabType.SMG));
        AgentConfigManager.generateDefaultIfMissing("medic", List.of(GunTabType.PISTOL, GunTabType.SMG));
        AgentConfigManager.generateDefaultIfMissing("engineer", List.of(GunTabType.PISTOL, GunTabType.RIFLE));
        AgentConfigManager.generateDefaultIfMissing("swordman", List.of(GunTabType.PISTOL, GunTabType.SHOTGUN));
        AgentConfigManager.reloadCache();
        Soldier.updateClassConfig(AgentConfigManager.getConfig("soldier"));
        Sniper.updateClassConfig(AgentConfigManager.getConfig("sniper"));
        Heavy.updateClassConfig(AgentConfigManager.getConfig("heavy"));
        Demolition.updateClassConfig(AgentConfigManager.getConfig("demolition"));
        Medic.updateClassConfig(AgentConfigManager.getConfig("medic"));
        Engineer.updateClassConfig(AgentConfigManager.getConfig("engineer"));
        Swordman.updateClassConfig(AgentConfigManager.getConfig("swordman"));
    }
}

