/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.client;

import com.github.ptran779.aegisops.entity.util.AbstractAgentEntity;
import com.github.ptran779.aegisops.entity.util.AgentInventoryMenu;
import com.github.ptran779.aegisops.network.AgentBoolPacket;
import com.github.ptran779.aegisops.network.AgentCommandType;
import com.github.ptran779.aegisops.network.AgentFollowPacket;
import com.github.ptran779.aegisops.network.AgentHostilePacket;
import com.github.ptran779.aegisops.network.PacketHandler;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class AgentInventoryScreen
extends AbstractContainerScreen<AgentInventoryMenu> {
    private static final Font font = Minecraft.m_91087_().f_91062_;
    private static final ResourceLocation CONTAINER_BACKGROUND = new ResourceLocation("aegisops", "textures/inventory.png");
    private static final ResourceLocation BUTTON_STATE = new ResourceLocation("aegisops", "textures/button.png");
    private final Player player;
    private final AbstractAgentEntity agent;
    DecimalFormat df = new DecimalFormat("#.#");

    protected void m_7856_() {
        super.m_7856_();
        PlainTextButton movementBtn = new PlainTextButton(this.f_97735_ + 227, this.f_97736_ + 7, 65, 25, (Component)Component.m_237119_(), btn -> PacketHandler.CHANNELS.sendToServer((Object)new AgentFollowPacket(this.agent.m_19879_(), this.agent.getMovement() == 2 ? 0 : this.agent.getMovement() + 1, this.player.m_20148_())), font);
        movementBtn.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Toggle Movement Mode")));
        this.m_142416_((GuiEventListener)movementBtn);
        PlainTextButton targetingBtn = new PlainTextButton(this.f_97735_ + 227, this.f_97736_ + 36, 65, 25, (Component)Component.m_237119_(), btn -> PacketHandler.CHANNELS.sendToServer((Object)new AgentHostilePacket(this.agent.m_19879_(), this.agent.getAutoHostile() == 3 ? 0 : this.agent.getAutoHostile() + 1)), font);
        targetingBtn.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Toggle Targeting Mode")));
        this.m_142416_((GuiEventListener)targetingBtn);
        PlainTextButton dismissBtn = new PlainTextButton(this.f_97735_ + 227, this.f_97736_ + 151, 65, 15, (Component)Component.m_237119_(), btn -> {
            PacketHandler.CHANNELS.sendToServer((Object)new AgentBoolPacket(this.agent.m_19879_(), AgentCommandType.REMOVE, true));
            Minecraft.m_91087_().m_91152_(null);
        }, font);
        dismissBtn.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Dismiss Agent")));
        this.m_142416_((GuiEventListener)dismissBtn);
    }

    public AgentInventoryScreen(AgentInventoryMenu container, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)container, pPlayerInventory, pTitle);
        this.f_97727_ = 166;
        this.f_97726_ = 300;
        this.agent = container.agent;
        this.f_97731_ = this.f_97727_ - 94;
        this.player = pPlayerInventory.f_35978_;
        this.df.setRoundingMode(RoundingMode.CEILING);
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
        this.renderCom(pGuiGraphics);
    }

    protected void renderCom(GuiGraphics pGuiGraphics) {
        Vec3 look = this.agent.m_20154_();
        double angleRad = Math.atan2(-look.f_82481_, look.f_82479_);
        float pitch = (float)Math.PI;
        float yaw = 1.5707964f + (float)angleRad;
        Quaternionf pose = new Quaternionf().rotationYXZ(yaw, -pitch, 0.0f);
        InventoryScreen.m_280432_((GuiGraphics)pGuiGraphics, (int)(this.f_97735_ + 33), (int)(this.f_97736_ + 72), (int)30, (Quaternionf)pose, null, (LivingEntity)this.agent);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        this.m_280273_(pGuiGraphics);
        pGuiGraphics.m_280163_(CONTAINER_BACKGROUND, (this.f_96543_ - this.f_97726_) / 2, (this.f_96544_ - this.f_97727_) / 2, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 300, 166);
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.m_280056_(font, this.agent.m_7755_().getString() + " the " + this.agent.agentType, 65, 15, 53247, false);
        pGuiGraphics.m_280056_(font, "Commander: " + this.agent.getOwner(), 65, 40, 53247, false);
        String followDisp = switch (this.agent.getMovement()) {
            case 0 -> "Wander";
            case 1 -> "Guard";
            case 2 -> "Follow";
            default -> "not sure";
        };
        pGuiGraphics.m_280056_(font, followDisp, 245, 15, 53247, false);
        String hostileDisp = switch (this.agent.getAutoHostile()) {
            case 0 -> "None";
            case 1 -> "Hostile";
            case 2 -> "Humanoid";
            case 3 -> "All";
            default -> "not sure";
        };
        pGuiGraphics.m_280056_(font, hostileDisp, 245, 45, 53247, false);
        pGuiGraphics.m_280056_(font, this.agent.getFood() + " / " + this.agent.maxfood, 245, 126, 53247, false);
    }

    protected void m_280072_(GuiGraphics pGuiGraphics, int x, int y) {
        super.m_280072_(pGuiGraphics, x, y);
    }
}

