/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.client;

import com.github.ptran779.aegisops.client.BoneHierachy;
import java.util.List;
import java.util.Map;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import org.joml.Vector3f;

public class RecursiveAnimationHelper {
    public static void animate(BoneHierachy model, AnimationDefinition animDef, float timeSeconds, float scale, Vector3f scratch) {
        model.getRoot().m_171331_().forEach(ModelPart::m_233569_);
        RecursiveAnimationHelper.recurseAndApply(model.getRootBoneName(), model, animDef.f_232257_(), timeSeconds, scale, scratch);
    }

    private static void recurseAndApply(String partName, BoneHierachy model, Map<String, List<AnimationChannel>> channels, float timeSeconds, float scale, Vector3f scratch) {
        RecursiveAnimationHelper.applyAnimation(model.get(partName), channels.get(partName), timeSeconds, scale, scratch);
        List<String> childs = model.getBoneChild(partName);
        if (childs == null) {
            return;
        }
        for (String child : childs) {
            RecursiveAnimationHelper.recurseAndApply(child, model, channels, timeSeconds, scale, scratch);
        }
    }

    private static void applyAnimation(ModelPart part, List<AnimationChannel> channels, float timeSeconds, float scale, Vector3f scratch) {
        if (channels == null) {
            return;
        }
        for (AnimationChannel channel : channels) {
            Keyframe[] keyframes = channel.f_232212_();
            if (keyframes.length == 0) continue;
            int i = Math.max(0, Mth.m_14049_((int)0, (int)keyframes.length, k -> timeSeconds <= keyframes[k].f_232283_()) - 1);
            int j = Math.min(keyframes.length - 1, i + 1);
            Keyframe from = keyframes[i];
            Keyframe to = keyframes[j];
            float t = j != i ? Mth.m_14036_((float)((timeSeconds - from.f_232283_()) / (to.f_232283_() - from.f_232283_())), (float)0.0f, (float)1.0f) : 0.0f;
            to.f_232285_().m_232222_(scratch, t, keyframes, i, j, scale);
            channel.f_232211_().m_232247_(part, scratch);
        }
    }
}

