/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.entity.util;

import com.github.ptran779.aegisops.Config.SkinManager;
import com.github.ptran779.aegisops.Utils;
import com.github.ptran779.aegisops.attribute.AgentAttribute;
import com.github.ptran779.aegisops.entity.util.AgentInventory;
import com.github.ptran779.aegisops.entity.util.AgentInventoryMenu;
import com.github.ptran779.aegisops.entity.util.IAgentEntity;
import com.github.ptran779.aegisops.goal.CustomRandomStrollGoal;
import com.github.ptran779.aegisops.goal.EatFoodGoal;
import com.github.ptran779.aegisops.goal.FollowGoal;
import com.tacz.guns.api.entity.IGunOperator;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.scores.Team;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAgentEntity
extends PathfinderMob
implements MenuProvider,
IAgentEntity {
    public String agentType = "Template";
    private boolean persistedFromNBT = false;
    public AgentInventory inventory = new AgentInventory(16, this);
    public final int[] gearSlots = new int[]{this.inventory.m_6643_() - 4, this.inventory.m_6643_() - 3, this.inventory.m_6643_() - 2, this.inventory.m_6643_() - 1};
    public final int gunSlot = this.inventory.m_6643_() - 7;
    public final int meleeSlot = this.inventory.m_6643_() - 6;
    public final int specialSlot = this.inventory.m_6643_() - 5;
    private UUID bossUUID = null;
    public UUID followPlayer = null;
    public int maxfood = 40;
    private static final EntityDataAccessor<Boolean> AUTO_ARMOR_F = SynchedEntityData.m_135353_(AbstractAgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> MOVEMENT_F = SynchedEntityData.m_135353_(AbstractAgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AUTO_HOSTILE_F = SynchedEntityData.m_135353_(AbstractAgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> PLAYER_HOSTILE_F = SynchedEntityData.m_135353_(AbstractAgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> KEEP_EAT_F = SynchedEntityData.m_135353_(AbstractAgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> FOOD_VALUE = SynchedEntityData.m_135353_(AbstractAgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> OWNER = SynchedEntityData.m_135353_(AbstractAgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> TEAM = SynchedEntityData.m_135353_(AbstractAgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Boolean> FEMALE = SynchedEntityData.m_135353_(AbstractAgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> SKIN = SynchedEntityData.m_135353_(AbstractAgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private transient ResourceLocation cachedSkin;

    public AbstractAgentEntity(EntityType<? extends AbstractAgentEntity> entityType, Level level) {
        super(entityType, level);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.m_21573_().m_7008_(true);
        this.m_21530_();
    }

    public ResourceLocation getResolvedSkin() {
        if (this.cachedSkin == null) {
            this.cachedSkin = SkinManager.get((Boolean)this.f_19804_.m_135370_(FEMALE), (String)this.f_19804_.m_135370_(SKIN));
        }
        return this.cachedSkin;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22288_, 1.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(AgentAttribute.AGENT_ATTACK_SPEED, 1.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(AUTO_ARMOR_F, (Object)false);
        this.f_19804_.m_135372_(MOVEMENT_F, (Object)0);
        this.f_19804_.m_135372_(AUTO_HOSTILE_F, (Object)0);
        this.f_19804_.m_135372_(KEEP_EAT_F, (Object)false);
        this.f_19804_.m_135372_(FOOD_VALUE, (Object)0);
        this.f_19804_.m_135372_(PLAYER_HOSTILE_F, (Object)false);
        this.f_19804_.m_135372_(FEMALE, (Object)false);
        this.f_19804_.m_135372_(SKIN, (Object)"");
        this.f_19804_.m_135372_(OWNER, (Object)"");
        this.f_19804_.m_135372_(TEAM, (Object)"");
    }

    public String getOwner() {
        return (String)this.f_19804_.m_135370_(OWNER);
    }

    public void setOwner(String boss) {
        this.f_19804_.m_135381_(OWNER, (Object)boss);
    }

    public UUID getOwnerUUID() {
        return this.bossUUID;
    }

    public void setOwnerUUID(UUID uuid) {
        this.bossUUID = uuid;
        ServerPlayer boss = this.m_9236_().m_7654_().m_6846_().m_11259_(uuid);
        if (boss != null) {
            this.setOwner(boss.m_36316_().getName());
        } else {
            this.setOwner("");
        }
    }

    public String getBossTeam() {
        return (String)this.f_19804_.m_135370_(TEAM);
    }

    public void setBossTeam(String bossTeam) {
        this.f_19804_.m_135381_(TEAM, (Object)bossTeam);
    }

    public void updateBossInfo() {
        if (this.getOwnerUUID() == null) {
            this.setBossTeam("");
            return;
        }
        ServerPlayer boss = this.m_9236_().m_7654_().m_6846_().m_11259_(this.getOwnerUUID());
        if (boss != null) {
            this.setOwner(boss.m_36316_().getName());
            Team team = boss.m_5647_();
            this.setBossTeam(team != null ? team.m_5758_() : "");
        }
    }

    public boolean getAutoArmor() {
        return (Boolean)this.f_19804_.m_135370_(AUTO_ARMOR_F);
    }

    public void setAutoArmor(boolean flag) {
        this.f_19804_.m_135381_(AUTO_ARMOR_F, (Object)flag);
    }

    public boolean getKeepEating() {
        return (Boolean)this.f_19804_.m_135370_(KEEP_EAT_F);
    }

    public void setKeepEating(boolean flag) {
        this.f_19804_.m_135381_(KEEP_EAT_F, (Object)flag);
    }

    public int getMovement() {
        return (Integer)this.f_19804_.m_135370_(MOVEMENT_F);
    }

    public void setMovement(int flag, UUID player) {
        this.f_19804_.m_135381_(MOVEMENT_F, (Object)flag);
        this.followPlayer = this.getMovement() == 2 ? player : null;
    }

    public int getAutoHostile() {
        return (Integer)this.f_19804_.m_135370_(AUTO_HOSTILE_F);
    }

    public void setAutoHostile(int flag) {
        this.f_19804_.m_135381_(AUTO_HOSTILE_F, (Object)flag);
    }

    public boolean getAttackPlayer() {
        return (Boolean)this.f_19804_.m_135370_(PLAYER_HOSTILE_F);
    }

    public void setAttackPlayer(boolean flag) {
        this.f_19804_.m_135381_(PLAYER_HOSTILE_F, (Object)flag);
    }

    public Integer getFood() {
        return (Integer)this.f_19804_.m_135370_(FOOD_VALUE);
    }

    public void setFood(Integer val) {
        this.f_19804_.m_135381_(FOOD_VALUE, (Object)val);
    }

    public boolean getFemale() {
        return (Boolean)this.f_19804_.m_135370_(FEMALE);
    }

    public void setFemale(boolean flag) {
        this.f_19804_.m_135381_(FEMALE, (Object)flag);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(9, (Goal)new CustomRandomStrollGoal(this, 0.4, 80));
        this.f_21345_.m_25352_(4, (Goal)new EatFoodGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new FollowGoal(this));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.m_9236_().m_5776_()) {
            this.updateBossInfo();
            if (this.getOwnerUUID() == null) {
                this.setOwnerUUID(player.m_20148_());
            }
            if (this.sameTeam((LivingEntity)player)) {
                if (player.m_21205_().m_41720_() instanceof SwordItem) {
                    int i = this.getAutoHostile() == 3 ? 0 : this.getAutoHostile() + 1;
                    this.setAutoHostile(i);
                    String disp = switch (i) {
                        case 0 -> this.m_7755_().getString() + " shall not seek battle";
                        case 1 -> this.m_7755_().getString() + " shall hunt down hostile";
                        case 2 -> this.m_7755_().getString() + " shall hunt down other players";
                        case 3 -> this.m_7755_().getString() + " shall hunt down hostile and other players";
                        default -> "";
                    };
                    player.m_5661_((Component)Component.m_237113_((String)disp), true);
                } else if (player.m_6047_()) {
                    int i = this.getMovement() == 2 ? 0 : this.getMovement() + 1;
                    this.setMovement(i, this.getOwnerUUID());
                    String disp = switch (i) {
                        case 0 -> this.m_7755_().getString() + " will wander around here";
                        case 1 -> this.m_7755_().getString() + " will stand guard";
                        case 2 -> {
                            Entity target = ((ServerLevel)this.m_9236_()).m_8791_(this.followPlayer);
                            String name = target != null ? target.m_7755_().getString() : "???";
                            yield this.m_7755_().getString() + " will follow " + name;
                        }
                        default -> "";
                    };
                    player.m_5661_((Component)Component.m_237113_((String)disp), true);
                } else {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buf -> buf.writeInt(this.m_19879_()));
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    private boolean sameTeam(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return this.friendlyPlayer(player);
        }
        if (entity instanceof AbstractAgentEntity) {
            AbstractAgentEntity otherAgent = (AbstractAgentEntity)entity;
            return this.friendlyAgent(otherAgent);
        }
        return false;
    }

    private boolean friendlyPlayer(Player player) {
        if (this.getOwnerUUID() == null) {
            return false;
        }
        if (this.getOwnerUUID().equals(player.m_20148_())) {
            return true;
        }
        if (this.getBossTeam().isEmpty()) {
            return false;
        }
        return this.getBossTeam().equals(player.m_5647_().m_5758_());
    }

    private boolean friendlyAgent(AbstractAgentEntity otherAgent) {
        UUID myUUID = this.getOwnerUUID();
        UUID theirUUID = otherAgent.getOwnerUUID();
        if (myUUID == null || theirUUID == null) {
            return false;
        }
        if (myUUID.equals(theirUUID)) {
            return true;
        }
        if (this.getBossTeam().isEmpty() || otherAgent.getBossTeam().isEmpty()) {
            return false;
        }
        return this.getBossTeam().equals(otherAgent.getBossTeam());
    }

    public boolean shouldTargetEntity(LivingEntity entity) {
        int mode = this.getAutoHostile();
        if (mode == 0) {
            return false;
        }
        if ((mode & 1) != 0 && entity instanceof Enemy) {
            return true;
        }
        if ((mode & 2) != 0) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !this.friendlyPlayer(player);
            }
            if (entity instanceof AbstractAgentEntity) {
                AbstractAgentEntity otherAgent = (AbstractAgentEntity)entity;
                return !this.friendlyAgent(otherAgent);
            }
        }
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        LivingEntity living;
        Entity entity = source.m_7639_();
        if (entity != null && entity instanceof LivingEntity && !this.sameTeam(living = (LivingEntity)entity)) {
            this.m_6710_(living);
        }
        return super.m_6469_(source, amount);
    }

    protected void m_6472_(DamageSource pSource, float pDamage) {
        if (!(pDamage <= 0.0f)) {
            if ((pDamage /= 4.0f) < 1.0f) {
                pDamage = 1.0f;
            }
            AtomicBoolean brokenArmorPiece = new AtomicBoolean(false);
            for (ItemStack piece : this.m_6168_()) {
                if (pSource.m_269533_(DamageTypeTags.f_268745_) && piece.m_41720_().m_41475_() || !(piece.m_41720_() instanceof ArmorItem)) continue;
                piece.m_41622_((int)pDamage, (LivingEntity)this, e -> {
                    e.m_21166_(LivingEntity.m_147233_((ItemStack)piece));
                    brokenArmorPiece.set(true);
                });
            }
            if (brokenArmorPiece.get()) {
                this.inventory.loadArmor();
                brokenArmorPiece.set(false);
            }
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        ListTag invTag = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack stack = this.inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128344_("Slot", (byte)i);
            stack.m_41739_(itemTag);
            invTag.add((Object)itemTag);
        }
        nbt.m_128365_("AgentInventory", (Tag)invTag);
        nbt.m_128405_("Food", this.getFood().intValue());
        if (this.getOwnerUUID() != null) {
            nbt.m_128362_("owner_uuid", this.getOwnerUUID());
        }
        nbt.m_128359_("boss_team", this.getBossTeam());
        nbt.m_128379_("auto_armor", this.getAutoArmor());
        nbt.m_128405_("auto_hostile", this.getAutoHostile());
        nbt.m_128379_("is_female", this.getFemale());
        nbt.m_128359_("skin", (String)this.f_19804_.m_135370_(SKIN));
        nbt.m_128379_("attack_player", this.getAttackPlayer());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.persistedFromNBT = true;
        ListTag invTag = nbt.m_128437_("AgentInventory", 10);
        for (int i = 0; i < invTag.size(); ++i) {
            CompoundTag itemTag = invTag.m_128728_(i);
            int slot = itemTag.m_128445_("Slot") & 0xFF;
            if (slot >= this.inventory.m_6643_()) continue;
            this.inventory.m_6836_(slot, ItemStack.m_41712_((CompoundTag)itemTag));
        }
        this.setFood(nbt.m_128451_("Food"));
        if (nbt.m_128441_("owner_uuid")) {
            this.setOwnerUUID(nbt.m_128342_("owner_uuid"));
        } else {
            this.setOwnerUUID(null);
        }
        this.setBossTeam(nbt.m_128461_("boss_team"));
        this.updateBossInfo();
        this.setAutoArmor(nbt.m_128471_("auto_armor"));
        this.setAutoHostile(nbt.m_128451_("auto_hostile"));
        this.setFemale(nbt.m_128471_("is_female"));
        this.f_19804_.m_135381_(SKIN, (Object)nbt.m_128461_("skin"));
        this.setAttackPlayer(nbt.m_128471_("attack_player"));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(level, difficulty, reason, spawnData, dataTag);
        if (!this.persistedFromNBT) {
            boolean isFemale = ThreadLocalRandom.current().nextBoolean();
            this.m_6593_((Component)Component.m_237113_((String)Utils.randomName(isFemale)));
            this.setFemale(isFemale);
            this.f_19804_.m_135381_(SKIN, (Object)SkinManager.renerateRandom(isFemale));
        }
        return data;
    }

    public void initCosmetic() {
        boolean isFemale = ThreadLocalRandom.current().nextBoolean();
        this.m_6593_((Component)Component.m_237113_((String)Utils.randomName(isFemale)));
        this.setFemale(isFemale);
        this.f_19804_.m_135381_(SKIN, (Object)SkinManager.renerateRandom(isFemale));
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHit) {
        super.m_7472_(source, looting, recentlyHit);
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack stack = this.inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            this.m_19983_(stack);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.f_19797_ % 80 == 0) {
            AttributeInstance attr = this.m_21051_(Attributes.f_22279_);
            if ((double)this.getFood().intValue() >= (double)this.maxfood * 0.4) {
                if (attr != null && !attr.m_22109_(AgentAttribute.WELL_FEED_SPEED_BOOST)) {
                    attr.m_22118_(AgentAttribute.WELL_FEED_SPEED_BOOST);
                }
            } else if (attr != null && attr.m_22109_(AgentAttribute.WELL_FEED_SPEED_BOOST)) {
                attr.m_22130_(AgentAttribute.WELL_FEED_SPEED_BOOST);
            }
            if (this.m_21223_() < this.m_21233_() && (double)this.getFood().intValue() >= (double)this.maxfood * 0.25) {
                this.passiveRegen();
            }
        }
    }

    private void passiveRegen() {
        this.setFood(this.getFood() - 1);
        this.m_5634_(1.0f);
    }

    public AbstractContainerMenu m_7208_(int containerID, Inventory inventory, Player player) {
        return new AgentInventoryMenu(containerID, inventory, this);
    }

    public void m_21203_() {
        super.m_21203_();
    }

    public void clearTarget() {
        this.m_6710_(null);
    }

    public void equipGun() {
        if (this.m_21205_() != this.inventory.m_8020_(this.gunSlot)) {
            this.m_8061_(EquipmentSlot.MAINHAND, this.inventory.m_8020_(this.gunSlot));
            IGunOperator op = IGunOperator.fromLivingEntity((LivingEntity)this);
            op.draw(() -> ((AbstractAgentEntity)this).m_21205_());
        }
    }

    public void equipMelee() {
        this.m_8061_(EquipmentSlot.MAINHAND, this.inventory.m_8020_(this.meleeSlot));
    }
}

