/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.entity.util;

import com.github.ptran779.aegisops.entity.util.AbstractAgentEntity;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.item.ModernKineticGunItem;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AgentInventory
extends SimpleContainer {
    private final AbstractAgentEntity agent;
    private int lastAmmoSlot = -1;

    public AgentInventory(int size, AbstractAgentEntity owner) {
        super(size);
        this.agent = owner;
    }

    protected void equipBestArmor() {
        ItemStack helmet = this.agent.m_6844_(EquipmentSlot.HEAD);
        ItemStack chest = this.agent.m_6844_(EquipmentSlot.CHEST);
        ItemStack legs = this.agent.m_6844_(EquipmentSlot.LEGS);
        ItemStack boots = this.agent.m_6844_(EquipmentSlot.FEET);
        block6: for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack stack = this.m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof ArmorItem)) continue;
            ArmorItem armor = (ArmorItem)item;
            switch (armor.m_40402_()) {
                case HEAD: {
                    if (!helmet.m_41619_() && armor.m_40404_() <= ((ArmorItem)helmet.m_41720_()).m_40404_()) continue block6;
                    helmet = stack;
                    this.swapItem(this.agent.gearSlots[0], i);
                    this.agent.m_8061_(armor.m_40402_(), helmet);
                    continue block6;
                }
                case CHEST: {
                    if (!chest.m_41619_() && armor.m_40404_() <= ((ArmorItem)chest.m_41720_()).m_40404_()) continue block6;
                    chest = stack;
                    this.swapItem(this.agent.gearSlots[1], i);
                    this.agent.m_8061_(armor.m_40402_(), chest);
                    continue block6;
                }
                case LEGS: {
                    if (!legs.m_41619_() && armor.m_40404_() <= ((ArmorItem)legs.m_41720_()).m_40404_()) continue block6;
                    legs = stack;
                    this.swapItem(this.agent.gearSlots[2], i);
                    this.agent.m_8061_(armor.m_40402_(), legs);
                    continue block6;
                }
                case FEET: {
                    if (!boots.m_41619_() && armor.m_40404_() <= ((ArmorItem)boots.m_41720_()).m_40404_()) continue block6;
                    boots = stack;
                    this.swapItem(this.agent.gearSlots[3], i);
                    this.agent.m_8061_(armor.m_40402_(), boots);
                }
            }
        }
    }

    public void loadArmor() {
        if (this.agent.getAutoArmor()) {
            this.equipBestArmor();
        } else {
            for (int i : this.agent.gearSlots) {
                ItemStack piece = this.m_8020_(i);
                Item item = piece.m_41720_();
                if (!(item instanceof ArmorItem)) continue;
                ArmorItem armor = (ArmorItem)item;
                this.agent.m_8061_(armor.m_40402_(), piece);
            }
        }
    }

    public void syncArmor() {
        ItemStack[] fullLoad = new ItemStack[]{this.agent.m_6844_(EquipmentSlot.HEAD), this.agent.m_6844_(EquipmentSlot.CHEST), this.agent.m_6844_(EquipmentSlot.LEGS), this.agent.m_6844_(EquipmentSlot.FEET)};
        for (int i = 0; i < 4; ++i) {
            if (!(fullLoad[i].m_41720_() instanceof ArmorItem)) continue;
            this.m_6836_(this.agent.gearSlots[i], fullLoad[i]);
        }
    }

    public boolean checkFood() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (!this.m_8020_(i).m_41614_()) continue;
            return true;
        }
        return false;
    }

    public ItemStack getBestFood() {
        ItemStack out = ItemStack.f_41583_;
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack stack = this.m_8020_(i);
            if (!stack.m_41614_() || out.m_41614_() && stack.m_41720_().getFoodProperties(stack, (LivingEntity)this.agent).m_38744_() <= out.m_41720_().getFoodProperties(stack, (LivingEntity)this.agent).m_38744_()) continue;
            out = stack;
        }
        return out;
    }

    public boolean meleeExist() {
        return !this.m_8020_(this.agent.meleeSlot).m_41619_();
    }

    public boolean gunExistWithAmmo() {
        ModernKineticGunItem gunItem;
        ItemStack stack = this.m_8020_(this.agent.gunSlot);
        Item item = stack.m_41720_();
        return item instanceof ModernKineticGunItem && (this.checkGunAmmo(stack, (AbstractGunItem)(gunItem = (ModernKineticGunItem)item)) > 0 || this.findGunAmmo(stack) != -1);
    }

    public int checkGunAmmo(ItemStack gunStack, AbstractGunItem gunItem) {
        return gunItem.getCurrentAmmoCount(gunStack);
    }

    private int isAmmoGunSlot(int slotId, ItemStack gunStack) {
        ItemStack checkAmmoStack = this.m_8020_(slotId);
        Item item = checkAmmoStack.m_41720_();
        if (item instanceof IAmmo) {
            IAmmo iAmmo = (IAmmo)item;
            if (iAmmo.isAmmoOfGun(gunStack, checkAmmoStack)) {
                this.lastAmmoSlot = slotId;
                return slotId;
            }
        } else {
            IAmmoBox iAmmoBox;
            item = checkAmmoStack.m_41720_();
            if (item instanceof IAmmoBox && (iAmmoBox = (IAmmoBox)item).isAmmoBoxOfGun(gunStack, checkAmmoStack)) {
                this.lastAmmoSlot = slotId;
                return slotId;
            }
        }
        return -1;
    }

    public int findGunAmmo(ItemStack gunStack) {
        int out;
        if (this.lastAmmoSlot != -1 && (out = this.isAmmoGunSlot(this.lastAmmoSlot, gunStack)) != -1) {
            return out;
        }
        for (int i = 0; i < this.m_6643_(); ++i) {
            out = this.isAmmoGunSlot(i, gunStack);
            if (out == -1) continue;
            return out;
        }
        return -1;
    }

    public boolean haveWeapon() {
        return this.gunExistWithAmmo() || this.meleeExist();
    }

    protected void swapItem(int id1, int id2) {
        if (id1 != id2) {
            ItemStack tmp = this.m_8020_(id2);
            this.m_6836_(id2, this.m_8020_(id1));
            this.m_6836_(id1, tmp);
        }
    }

    public AbstractAgentEntity getAgent() {
        return this.agent;
    }
}

