/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.goal;

import com.github.ptran779.aegisops.attribute.AgentAttribute;
import com.github.ptran779.aegisops.entity.util.AbstractAgentEntity;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.util.AttachmentDataUtils;
import java.util.EnumSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AgentAttackGoal
extends Goal {
    private final AbstractAgentEntity agent;
    private int attackCoolDown = 0;
    private int seeTime = 0;
    private final double meleeRangeSq;
    private final double gunLowRangeSq;
    private final double gunHighRangeSq;
    private final double maxRangeSq;
    IGunOperator op;

    public AgentAttackGoal(AbstractAgentEntity agent, double meleeRange, double gunLowRange, double gunHighRange, double maxRange) {
        this.agent = agent;
        this.meleeRangeSq = meleeRange * meleeRange;
        this.gunLowRangeSq = gunLowRange * gunLowRange;
        this.gunHighRangeSq = gunHighRange * gunHighRange;
        this.maxRangeSq = maxRange * maxRange;
        this.op = IGunOperator.fromLivingEntity((LivingEntity)agent);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    private int computeAttackCooldown() {
        return (int)(20.0 / this.agent.m_21051_(AgentAttribute.AGENT_ATTACK_SPEED).m_22135_());
    }

    private void shootGun(boolean precision) {
        if (this.op.getSynIsBolting()) {
            this.op.aim(false);
        }
        if (this.op.getSynIsAiming() != precision) {
            this.op.aim(precision);
        }
        switch (this.op.shoot(() -> Float.valueOf(this.agent.m_5686_(1.0f)), () -> Float.valueOf(this.agent.m_5675_(1.0f)))) {
            case SUCCESS: {
                this.attackCoolDown = this.computeAttackCooldown();
                break;
            }
            case NOT_DRAW: {
                this.op.draw(() -> ((AbstractAgentEntity)this.agent).m_21205_());
                break;
            }
            case NEED_BOLT: {
                this.op.bolt();
                this.attackCoolDown = this.computeAttackCooldown();
                break;
            }
            case NO_AMMO: {
                this.reloadGun();
                this.attackCoolDown = this.computeAttackCooldown();
            }
        }
    }

    private void reloadGun() {
        int curAmmoCount;
        ItemStack gunStack = this.agent.m_21205_();
        int i = this.agent.inventory.findGunAmmo(gunStack);
        if (i == -1) {
            return;
        }
        ItemStack ammoStack = this.agent.inventory.m_8020_(i);
        AbstractGunItem gunItem = (AbstractGunItem)gunStack.m_41720_();
        ResourceLocation gunResource = gunItem.getGunId(gunStack);
        CommonGunIndex gunIndex = TimelessAPI.getCommonGunIndex((ResourceLocation)gunResource).orElse(null);
        int maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment((ItemStack)gunStack, (GunData)gunIndex.getGunData());
        int reloadAmount = curAmmoCount = this.agent.inventory.checkGunAmmo(gunStack, gunItem);
        Item item = ammoStack.m_41720_();
        if (item instanceof IAmmoBox) {
            IAmmoBox iAmmoBoxItem = (IAmmoBox)item;
            reloadAmount = Math.min(maxAmmoCount - curAmmoCount, iAmmoBoxItem.getAmmoCount(ammoStack));
            iAmmoBoxItem.setAmmoCount(ammoStack, iAmmoBoxItem.getAmmoCount(ammoStack) - reloadAmount);
        } else if (ammoStack.m_41720_() instanceof IAmmo) {
            reloadAmount = Math.min(maxAmmoCount - curAmmoCount, ammoStack.m_41613_());
            ammoStack.m_41764_(ammoStack.m_41613_() - reloadAmount);
        }
        gunItem.setCurrentAmmoCount(gunStack, curAmmoCount + reloadAmount);
    }

    protected double getAttackReachSqr(LivingEntity target) {
        return Math.pow((this.agent.m_20205_() + target.m_20205_()) / 2.0f + 2.0f, 2.0);
    }

    public boolean m_8036_() {
        return this.agent.m_5448_() != null && !this.agent.m_6117_() && this.agent.m_5448_().m_6084_();
    }

    public boolean m_8045_() {
        return this.agent.m_5448_() != null && this.agent.m_5448_().m_6084_() && this.seeTime > -100 && this.agent.m_20280_((Entity)this.agent.m_5448_()) < this.maxRangeSq;
    }

    public void m_8056_() {
        this.agent.m_21561_(true);
        this.seeTime = 0;
        this.attackCoolDown = 0;
    }

    public void m_8041_() {
        this.agent.m_21561_(false);
        this.agent.clearTarget();
        this.agent.m_21573_().m_26573_();
        this.op.aim(false);
        this.agent.m_5810_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity target = this.agent.m_5448_();
        if (target == null) {
            return;
        }
        this.agent.m_21563_().m_148051_((Entity)target);
        if (this.agent.f_19797_ % 5 == 0) {
            this.seeTime = this.agent.m_21574_().m_148306_((Entity)target) ? Math.min(20, this.seeTime + 5) : (this.seeTime -= 5);
        }
        if (this.attackCoolDown > 0) {
            --this.attackCoolDown;
        }
        if (this.attackCoolDown <= 0 && this.seeTime == 20) {
            double targetDistSq = this.agent.m_20280_((Entity)target);
            boolean meleeYes = this.agent.inventory.meleeExist();
            boolean gunYes = this.agent.inventory.gunExistWithAmmo();
            if (meleeYes && targetDistSq < this.meleeRangeSq) {
                this.agent.equipMelee();
                if (this.getAttackReachSqr(target) > targetDistSq) {
                    this.agent.m_21573_().m_26573_();
                    this.agent.m_21011_(InteractionHand.MAIN_HAND, true);
                    this.agent.m_7327_((Entity)target);
                    this.agent.m_21205_().m_41622_(1, (LivingEntity)this.agent, e -> e.m_21190_(InteractionHand.MAIN_HAND));
                    this.attackCoolDown = this.computeAttackCooldown();
                } else {
                    this.agent.m_21573_().m_5624_((Entity)target, this.agent.m_21051_(Attributes.f_22279_).m_22135_());
                }
            } else if (gunYes) {
                this.agent.equipGun();
                if (targetDistSq > this.gunHighRangeSq) {
                    this.agent.m_21573_().m_5624_((Entity)target, this.agent.m_21051_(Attributes.f_22279_).m_22135_());
                } else if (targetDistSq > this.gunLowRangeSq) {
                    this.agent.m_21573_().m_26573_();
                    this.shootGun(true);
                } else if (targetDistSq > this.meleeRangeSq || !meleeYes) {
                    this.agent.m_21566_().m_24988_(-0.5f, 0.0f);
                    this.shootGun(false);
                }
            } else {
                this.agent.clearTarget();
                return;
            }
        }
    }
}

