/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.network;

import com.github.ptran779.aegisops.entity.util.AbstractAgentEntity;
import com.github.ptran779.aegisops.network.AgentCommandType;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class AgentBoolPacket {
    private final int entityId;
    private final AgentCommandType cType;
    private final boolean payload;

    public AgentBoolPacket(int entityId, AgentCommandType cType, boolean flag) {
        this.entityId = entityId;
        this.cType = cType;
        this.payload = flag;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.m_130068_((Enum)this.cType);
        buf.writeBoolean(this.payload);
    }

    public static AgentBoolPacket decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        AgentCommandType cType = (AgentCommandType)buf.m_130066_(AgentCommandType.class);
        boolean payload = buf.readBoolean();
        return new AgentBoolPacket(entityId, cType, payload);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Entity e = player.m_9236_().m_6815_(this.entityId);
            if (!(e instanceof AbstractAgentEntity)) {
                return;
            }
            AbstractAgentEntity agent = (AbstractAgentEntity)e;
            switch (this.cType) {
                case AUTO_ARMOR: {
                    agent.setAutoArmor(this.payload);
                    break;
                }
                case ATTACK_PLAYER: {
                    agent.setAttackPlayer(this.payload);
                    break;
                }
                case REMOVE: {
                    agent.setOwnerUUID(null);
                    agent.updateBossInfo();
                    break;
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

