/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.Config;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class SkinManager {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final Path SKIN_DIR = Path.of("config/aegisops/skins", new String[0]);
    private static final String NAMESPACE = "aegisops_dynamic";
    private static final ResourceLocation MISSING_TEXTURE = new ResourceLocation("aegisops", "textures/entities/defaultslim.png");
    private static final Map<String, ResourceLocation> MALE_SKINS = new HashMap<String, ResourceLocation>();
    private static final Map<String, ResourceLocation> FEMALE_SKINS = new HashMap<String, ResourceLocation>();
    private static final Set<ResourceLocation> REGISTERED_TEXTURES = new HashSet<ResourceLocation>();

    public static void init() {
        Path maleDir = SKIN_DIR.resolve("male");
        Path femaleDir = SKIN_DIR.resolve("female");
        try {
            Files.createDirectories(maleDir, new FileAttribute[0]);
            Files.createDirectories(femaleDir, new FileAttribute[0]);
            if (Files.list(maleDir).findAny().isEmpty()) {
                SkinManager.copyDefault("/assets/aegisops/textures/entities/defaultwide.png", maleDir.resolve("defaultwide.png"));
            }
            if (Files.list(femaleDir).findAny().isEmpty()) {
                SkinManager.copyDefault("/assets/aegisops/textures/entities/defaultslim.png", femaleDir.resolve("defaultslim.png"));
            }
            SkinManager.loadSkinsFromFolder("male", maleDir, MALE_SKINS);
            SkinManager.loadSkinsFromFolder("female", femaleDir, FEMALE_SKINS);
        }
        catch (IOException e) {
            System.err.println("[AegisOps] Failed to initialize skin directories:");
            e.printStackTrace();
        }
    }

    private static void copyDefault(String internalPath, Path targetPath) {
        try (InputStream in = SkinManager.class.getResourceAsStream(internalPath);){
            if (in != null) {
                Files.copy(in, targetPath, new CopyOption[0]);
            }
        }
        catch (IOException e) {
            System.err.println("[AegisOps] Failed to copy default skin: " + internalPath);
            e.printStackTrace();
        }
    }

    private static void loadSkinsFromFolder(String genderKey, Path folder, Map<String, ResourceLocation> skinMap) {
        try (Stream<Path> stream = Files.walk(folder, new FileVisitOption[0]);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".png")).forEach(path -> {
                String fileName = path.getFileName().toString().replace(".png", "").toLowerCase();
                String id = genderKey + "/" + fileName;
                ResourceLocation rl = new ResourceLocation(NAMESPACE, id);
                try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                    NativeImage img = NativeImage.m_85058_((InputStream)in);
                    DynamicTexture dynTex = new DynamicTexture(img);
                    MC.m_91097_().m_118495_(rl, (AbstractTexture)dynTex);
                    skinMap.put(fileName, rl);
                    REGISTERED_TEXTURES.add(rl);
                }
                catch (IOException e) {
                    System.err.println("[AegisOps] Failed to load skin image: " + String.valueOf(path));
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            System.err.println("[AegisOps] Failed to walk folder: " + String.valueOf(folder));
            e.printStackTrace();
        }
    }

    public static ResourceLocation get(boolean slim, String key) {
        Map<String, ResourceLocation> map = slim ? FEMALE_SKINS : MALE_SKINS;
        ResourceLocation rl = map.get(key.toLowerCase());
        if (rl == null) {
            System.err.println("[AegisOps] No skin found for key: " + key + "wtf?");
        }
        return map.getOrDefault(key.toLowerCase(), MISSING_TEXTURE);
    }

    public static void reload() {
        for (ResourceLocation rl : REGISTERED_TEXTURES) {
            MC.m_91097_().m_118513_(rl);
        }
        REGISTERED_TEXTURES.clear();
        MALE_SKINS.clear();
        FEMALE_SKINS.clear();
        SkinManager.init();
    }

    public static String renerateRandom(boolean slim) {
        ArrayList<String> keys = new ArrayList<String>((slim ? FEMALE_SKINS : MALE_SKINS).keySet());
        return (String)keys.get(ThreadLocalRandom.current().nextInt(keys.size()));
    }
}

