/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.client.render;

import com.github.ptran779.aegisops.Utils;
import com.github.ptran779.aegisops.client.AnimationHelper;
import com.github.ptran779.aegisops.client.animation.AgentLivingAnimation;
import com.github.ptran779.aegisops.client.animation.AgentSpecialAnimation;
import com.github.ptran779.aegisops.client.model.AgentModel;
import com.github.ptran779.aegisops.entity.agent.AbstractAgentEntity;
import com.github.ptran779.aegisops.entity.agent.Demolition;
import com.github.ptran779.aegisops.entity.agent.Engineer;
import com.github.ptran779.aegisops.entity.agent.Heavy;
import com.github.ptran779.aegisops.entity.agent.Medic;
import com.github.ptran779.aegisops.entity.agent.Sniper;
import com.github.ptran779.aegisops.entity.agent.Soldier;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tacz.guns.item.ModernKineticGunItem;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.UseAnim;

public class AgentEntityRender
extends HumanoidMobRenderer<AbstractAgentEntity, AgentModel> {
    private final AgentModel standardModel;
    private final AgentModel slimModel;

    public AgentEntityRender(EntityRendererProvider.Context context) {
        super(context, (HumanoidModel)new AgentModel(context.m_174023_(ModelLayers.f_171162_), false), 0.25f);
        this.standardModel = (AgentModel)this.f_115290_;
        this.slimModel = new AgentModel(context.m_174023_(ModelLayers.f_171166_), true);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(context.m_174023_(ModelLayers.f_171165_)), context.m_266367_()));
    }

    public ResourceLocation getTextureLocation(AbstractAgentEntity agent) {
        return agent.getResolvedSkin();
    }

    public void render(AbstractAgentEntity agent, float pEntityYaw, float partialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        this.f_115290_ = agent.getFemale() ? this.slimModel : this.standardModel;
        for (ModelPart part : ((AgentModel)this.f_115290_).BONE_PARTS.values()) {
            part.m_233569_();
        }
        float aniTick = (float)agent.f_19797_ - agent.timeTrigger + partialTicks;
        Utils.AniMove aniMove = agent.getAniMove();
        if (aniMove == Utils.AniMove.SPECIAL) {
            if (agent instanceof Engineer) {
                if (agent.getSpecialMove() == 0) {
                    AnimationHelper.animateHumanoid((PlayerModel<AbstractAgentEntity>)((PlayerModel)this.f_115290_), AgentLivingAnimation.BONK, ((AgentModel)this.f_115290_).BONE_PARTS, aniTick / 20.0f, 1.0f, false);
                }
            } else if (agent instanceof Medic) {
                switch (agent.getSpecialMove()) {
                    case 0: {
                        AnimationHelper.animateHumanoid((PlayerModel<AbstractAgentEntity>)((PlayerModel)this.f_115290_), AgentLivingAnimation.MEDIC_BANDAGE, ((AgentModel)this.f_115290_).BONE_PARTS, aniTick / 20.0f, 1.0f, false);
                        break;
                    }
                    case 1: {
                        AnimationHelper.animateHumanoid((PlayerModel<AbstractAgentEntity>)((PlayerModel)this.f_115290_), AgentLivingAnimation.MEDIC_SYRINGE, ((AgentModel)this.f_115290_).BONE_PARTS, aniTick / 20.0f, 1.0f, false);
                    }
                }
            } else if (agent instanceof Sniper) {
                if (agent.getSpecialMove() == 0) {
                    AnimationHelper.animateHumanoid((PlayerModel<AbstractAgentEntity>)((PlayerModel)this.f_115290_), AgentLivingAnimation.PRECISION_SHOT, ((AgentModel)this.f_115290_).BONE_PARTS, aniTick / 20.0f, 1.0f, false);
                }
            } else if (agent instanceof Heavy) {
                switch (agent.getSpecialMove()) {
                    case 0: {
                        AnimationHelper.animateHumanoid((PlayerModel<AbstractAgentEntity>)((PlayerModel)this.f_115290_), AgentSpecialAnimation.SHIELD_DEPLOY, ((AgentModel)this.f_115290_).BONE_PARTS, aniTick / 20.0f, 1.0f, false);
                        break;
                    }
                    case 1: {
                        AnimationHelper.animateHumanoid((PlayerModel<AbstractAgentEntity>)((PlayerModel)this.f_115290_), AgentSpecialAnimation.SHIELD_CHARGE, ((AgentModel)this.f_115290_).BONE_PARTS, aniTick / 20.0f, 1.0f, true);
                        break;
                    }
                    case 2: {
                        AnimationHelper.animateHumanoid((PlayerModel<AbstractAgentEntity>)((PlayerModel)this.f_115290_), AgentSpecialAnimation.SHIELD_HOLD, ((AgentModel)this.f_115290_).BONE_PARTS, aniTick / 20.0f, 1.0f, false);
                        break;
                    }
                    case 3: {
                        AnimationHelper.animateHumanoid((PlayerModel<AbstractAgentEntity>)((PlayerModel)this.f_115290_), AgentSpecialAnimation.SHIELD_BONK, ((AgentModel)this.f_115290_).BONE_PARTS, aniTick / 20.0f, 1.0f, false);
                        break;
                    }
                    case 4: {
                        AnimationHelper.animateHumanoid((PlayerModel<AbstractAgentEntity>)((PlayerModel)this.f_115290_), AgentSpecialAnimation.SHIELD_RECOVER, ((AgentModel)this.f_115290_).BONE_PARTS, aniTick / 20.0f, 1.0f, false);
                        break;
                    }
                    case 5: {
                        AnimationHelper.animateHumanoid((PlayerModel<AbstractAgentEntity>)((PlayerModel)this.f_115290_), AgentSpecialAnimation.SHIELD_GUN_BURST, ((AgentModel)this.f_115290_).BONE_PARTS, aniTick / 20.0f, 1.0f, false);
                        break;
                    }
                }
            } else if (agent instanceof Soldier) {
                if (agent.getSpecialMove() == 0) {
                    AnimationHelper.animateHumanoid((PlayerModel<AbstractAgentEntity>)((PlayerModel)this.f_115290_), AgentSpecialAnimation.SODIER_HYPE, ((AgentModel)this.f_115290_).BONE_PARTS, aniTick / 20.0f, 1.0f, false);
                }
            } else if (agent instanceof Demolition) {
                switch (agent.getSpecialMove()) {
                    case 0: {
                        AnimationHelper.animateHumanoid((PlayerModel<AbstractAgentEntity>)((PlayerModel)this.f_115290_), AgentSpecialAnimation.GRENADE_THROW, ((AgentModel)this.f_115290_).BONE_PARTS, aniTick / 20.0f, 1.0f, false);
                        break;
                    }
                    case 1: {
                        AnimationHelper.animateHumanoid((PlayerModel<AbstractAgentEntity>)((PlayerModel)this.f_115290_), AgentSpecialAnimation.TERMINAL_ACTIVATE, ((AgentModel)this.f_115290_).BONE_PARTS, aniTick / 20.0f, 1.0f, false);
                    }
                }
            }
        } else if (aniMove == Utils.AniMove.SALUTE) {
            AnimationHelper.animateHumanoid((PlayerModel<AbstractAgentEntity>)((PlayerModel)this.f_115290_), AgentLivingAnimation.SALUTE, ((AgentModel)this.f_115290_).BONE_PARTS, aniTick / 20.0f, 1.0f, false);
        } else if (aniMove == Utils.AniMove.DISP_RELOAD) {
            AnimationHelper.animateHumanoid((PlayerModel<AbstractAgentEntity>)((PlayerModel)this.f_115290_), AgentLivingAnimation.STATION_RELOAD, ((AgentModel)this.f_115290_).BONE_PARTS, aniTick / 20.0f, 1.0f, false);
        } else if (aniMove == Utils.AniMove.ATTACK) {
            AnimationHelper.animateHumanoid((PlayerModel<AbstractAgentEntity>)((PlayerModel)this.f_115290_), AgentLivingAnimation.STRIKE1, ((AgentModel)this.f_115290_).BONE_PARTS, aniTick / 15.0f, 1.0f, false);
        } else {
            double speed = agent.m_20184_().m_165925_();
            if (speed > 0.015) {
                AnimationHelper.animateHumanoid((PlayerModel<AbstractAgentEntity>)((PlayerModel)this.f_115290_), AgentLivingAnimation.RUN, ((AgentModel)this.f_115290_).BONE_PARTS, ((float)agent.f_19797_ + partialTicks) / 20.0f, 1.0f, true);
            } else if (speed > 0.001) {
                AnimationHelper.animateHumanoid((PlayerModel<AbstractAgentEntity>)((PlayerModel)this.f_115290_), AgentLivingAnimation.WALK, ((AgentModel)this.f_115290_).BONE_PARTS, ((float)agent.f_19797_ + partialTicks) / 20.0f, 1.0f, true);
            } else {
                AnimationHelper.animateHumanoid((PlayerModel<AbstractAgentEntity>)((PlayerModel)this.f_115290_), AgentLivingAnimation.IDLE, ((AgentModel)this.f_115290_).BONE_PARTS, ((float)agent.f_19797_ + partialTicks) / 20.0f, 1.0f, true);
            }
            if (agent.getAniMove() == Utils.AniMove.RELOAD && aniTick < 20.0f * AgentLivingAnimation.RELOAD.f_232255_()) {
                ((AgentModel)this.f_115290_).f_102812_.m_233569_();
                ((AgentModel)this.f_115290_).f_102811_.m_233569_();
                AnimationHelper.animateHumanoid((PlayerModel<AbstractAgentEntity>)((PlayerModel)this.f_115290_), AgentLivingAnimation.RELOAD, ((AgentModel)this.f_115290_).BONE_PARTS, aniTick / 20.0f, 1.0f, false);
            } else if (agent.m_21205_().m_41720_() instanceof ModernKineticGunItem) {
                ((AgentModel)this.f_115290_).f_102811_.f_104204_ = ((AgentModel)this.f_115290_).f_102808_.f_104204_;
                ((AgentModel)this.f_115290_).f_102812_.f_104204_ = 0.5f + ((AgentModel)this.f_115290_).f_102808_.f_104204_;
                ((AgentModel)this.f_115290_).f_102811_.f_104203_ = -1.5707964f + ((AgentModel)this.f_115290_).f_102808_.f_104203_;
                ((AgentModel)this.f_115290_).f_102812_.f_104203_ = -1.5707964f + ((AgentModel)this.f_115290_).f_102808_.f_104203_;
                ((AgentModel)this.f_115290_).f_103374_.m_104315_(((AgentModel)this.f_115290_).f_102812_);
                ((AgentModel)this.f_115290_).f_103375_.m_104315_(((AgentModel)this.f_115290_).f_102811_);
            } else if (agent.m_6117_() && (agent.m_21211_().m_41780_() == UseAnim.EAT || agent.m_21211_().m_41780_() == UseAnim.DRINK)) {
                AnimationHelper.animateHumanoid((PlayerModel<AbstractAgentEntity>)((PlayerModel)this.f_115290_), AgentLivingAnimation.EATING, ((AgentModel)this.f_115290_).BONE_PARTS, aniTick / 20.0f, 1.0f, true);
            }
        }
        float headYaw = Mth.m_14189_((float)partialTicks, (float)agent.f_20886_, (float)agent.f_20885_) - agent.f_20883_;
        float headPitch = Mth.m_14179_((float)partialTicks, (float)agent.f_19860_, (float)agent.m_146909_());
        ((AgentModel)this.f_115290_).f_102808_.f_104204_ += headYaw * ((float)Math.PI / 180);
        ((AgentModel)this.f_115290_).f_102808_.f_104203_ += headPitch * ((float)Math.PI / 180);
        ((AgentModel)this.f_115290_).f_102809_.m_104315_(((AgentModel)this.f_115290_).f_102808_);
        super.m_7392_((Mob)agent, pEntityYaw, partialTicks, pPoseStack, pBuffer, pPackedLight);
    }
}

