/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.client.render;

import com.github.ptran779.aegisops.client.AnimationHelper;
import com.github.ptran779.aegisops.client.ShareModel;
import com.github.ptran779.aegisops.client.animation.HellPodAnimation;
import com.github.ptran779.aegisops.client.model.HellpodModel;
import com.github.ptran779.aegisops.entity.extra.FallingHellPod;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class FallingHellPodRender
extends EntityRenderer<FallingHellPod> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("aegisops", "textures/block/hell_pod.png");
    private final HellpodModel model;

    public FallingHellPodRender(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = ShareModel.prepHellPodModel(pContext.m_174023_(HellpodModel.LAYER_LOCATION));
    }

    public void render(FallingHellPod pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.0, 2.5, 0.0);
        pPoseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        if (pEntity.isDeployed()) {
            float aniTick = (float)pEntity.f_19797_ - pEntity.timeTrigger + pPartialTick;
            AnimationHelper.animate(this.model, HellPodAnimation.DEPLOY1, aniTick / 20.0f, 1.0f, false);
        } else {
            AnimationHelper.animate(this.model, HellPodAnimation.DEPLOY1, 0.0f, 1.0f, false);
            float spin = ((float)pEntity.f_19797_ + pPartialTick) * 5.0f;
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(spin));
        }
        VertexConsumer vertexConsumer = pBuffer.m_6299_(this.model.m_103119_(TEXTURE));
        this.model.m_7695_(pPoseStack, vertexConsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        pPoseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(FallingHellPod entity) {
        return TEXTURE;
    }
}

