/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.entity.agent;

import com.github.ptran779.aegisops.Config.SkinManager;
import com.github.ptran779.aegisops.Utils;
import com.github.ptran779.aegisops.attribute.AgentAttribute;
import com.github.ptran779.aegisops.entity.api.IEntityRender;
import com.github.ptran779.aegisops.entity.api.IEntityTarget;
import com.github.ptran779.aegisops.entity.api.IEntityTeam;
import com.github.ptran779.aegisops.entity.inventory.AgentInventory;
import com.github.ptran779.aegisops.entity.inventory.AgentInventoryMenu;
import com.github.ptran779.aegisops.goal.common.CustomRandomStrollGoal;
import com.github.ptran779.aegisops.goal.common.EatFoodGoal;
import com.github.ptran779.aegisops.goal.common.FollowGoal;
import com.github.ptran779.aegisops.goal.common.SaluteGoal;
import com.github.ptran779.aegisops.goal.special.RechargeVirtualAmmo;
import com.github.ptran779.aegisops.network.EntityRenderPacket;
import com.github.ptran779.aegisops.network.PacketHandler;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.util.AttachmentDataUtils;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAgentEntity
extends PathfinderMob
implements InventoryCarrier,
MenuProvider,
IEntityTeam,
IEntityTarget,
IEntityRender {
    public String agentType = "Template";
    private boolean persistedFromNBT = false;
    public boolean invincible = false;
    public IGunOperator op;
    public AgentInventory inventory = new AgentInventory(16, this);
    public final int[] gearSlots = new int[]{0, 1, 2, 3};
    public final int gunSlot = 4;
    public final int meleeSlot = 5;
    public final int specialSlot = 6;
    private UUID bossUUID = null;
    public UUID followPlayer = null;
    public int maxfood = 40;
    private int pathCooldown = 0;
    private static final EntityDataAccessor<Integer> MOVEMENT_F = SynchedEntityData.m_135353_(AbstractAgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ALLOW_SPECIAL_F = SynchedEntityData.m_135353_(AbstractAgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> AUTO_HOSTILE_F = SynchedEntityData.m_135353_(AbstractAgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> KEEP_EAT_F = SynchedEntityData.m_135353_(AbstractAgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> FOOD_VALUE = SynchedEntityData.m_135353_(AbstractAgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> OWNER = SynchedEntityData.m_135353_(AbstractAgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> VIRTUAL_AMMO = SynchedEntityData.m_135353_(AbstractAgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANI_MOVE = SynchedEntityData.m_135353_(AbstractAgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SPECIAL_MOVE = SynchedEntityData.m_135353_(AbstractAgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> FEMALE = SynchedEntityData.m_135353_(AbstractAgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> SKIN = SynchedEntityData.m_135353_(AbstractAgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private transient ResourceLocation cachedSkin;
    public float timeTrigger = -1000.0f;

    @Override
    public void resetRenderTick() {
        this.timeTrigger = this.f_19797_;
    }

    public AbstractAgentEntity(EntityType<? extends AbstractAgentEntity> entityType, Level level) {
        super(entityType, level);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.m_21573_().m_7008_(true);
        this.m_21530_();
        this.op = IGunOperator.fromLivingEntity((LivingEntity)this);
        this.m_21553_(true);
    }

    public ResourceLocation getResolvedSkin() {
        if (this.cachedSkin == null) {
            this.cachedSkin = SkinManager.get((Boolean)this.f_19804_.m_135370_(FEMALE), (String)this.f_19804_.m_135370_(SKIN));
        }
        return this.cachedSkin;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22288_, 1.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(AgentAttribute.AGENT_ATTACK_SPEED, 1.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ALLOW_SPECIAL_F, (Object)false);
        this.f_19804_.m_135372_(MOVEMENT_F, (Object)0);
        this.f_19804_.m_135372_(AUTO_HOSTILE_F, (Object)Utils.TargetMode.OFF.ordinal());
        this.f_19804_.m_135372_(KEEP_EAT_F, (Object)false);
        this.f_19804_.m_135372_(FOOD_VALUE, (Object)0);
        this.f_19804_.m_135372_(ANI_MOVE, (Object)Utils.AniMove.NORM.ordinal());
        this.f_19804_.m_135372_(SPECIAL_MOVE, (Object)0);
        this.f_19804_.m_135372_(FEMALE, (Object)false);
        this.f_19804_.m_135372_(SKIN, (Object)"");
        this.f_19804_.m_135372_(OWNER, (Object)"");
        this.f_19804_.m_135372_(VIRTUAL_AMMO, (Object)0);
    }

    public String getOwner() {
        return (String)this.f_19804_.m_135370_(OWNER);
    }

    public void setOwner(String boss) {
        this.f_19804_.m_135381_(OWNER, (Object)boss);
    }

    @Override
    public UUID getBossUUID() {
        return this.bossUUID;
    }

    public void setBossUUID(UUID uuid) {
        this.bossUUID = uuid;
        ServerPlayer boss = this.m_9236_().m_7654_().m_6846_().m_11259_(uuid);
        if (boss != null) {
            this.setOwner(boss.m_36316_().getName());
        } else {
            this.setOwner("");
        }
    }

    public boolean getAllowSpecial() {
        return (Boolean)this.f_19804_.m_135370_(ALLOW_SPECIAL_F);
    }

    public void setAllowSpecial(boolean flag) {
        this.f_19804_.m_135381_(ALLOW_SPECIAL_F, (Object)flag);
    }

    public boolean getKeepEating() {
        return (Boolean)this.f_19804_.m_135370_(KEEP_EAT_F);
    }

    public void setKeepEating(boolean flag) {
        this.f_19804_.m_135381_(KEEP_EAT_F, (Object)flag);
    }

    public int getMovement() {
        return (Integer)this.f_19804_.m_135370_(MOVEMENT_F);
    }

    public void setMovement(int flag, UUID player) {
        this.f_19804_.m_135381_(MOVEMENT_F, (Object)flag);
        this.followPlayer = this.getMovement() == 2 ? player : null;
    }

    @Override
    public Utils.TargetMode getTargetMode() {
        return Utils.TargetMode.fromId((Integer)this.f_19804_.m_135370_(AUTO_HOSTILE_F));
    }

    @Override
    public void setTargetMode(Utils.TargetMode mode) {
        this.f_19804_.m_135381_(AUTO_HOSTILE_F, (Object)mode.ordinal());
    }

    @Override
    public Utils.TargetMode nextTargetMode() {
        return Utils.TargetMode.nextTargetMode((Integer)this.f_19804_.m_135370_(AUTO_HOSTILE_F));
    }

    @Override
    public boolean haveWeapon() {
        return this.inventory.haveWeapon();
    }

    public int getVirtualAmmo() {
        return (Integer)this.f_19804_.m_135370_(VIRTUAL_AMMO);
    }

    public void setVirtualAmmo(int ammo) {
        this.f_19804_.m_135381_(VIRTUAL_AMMO, (Object)ammo);
    }

    public Integer getFood() {
        return (Integer)this.f_19804_.m_135370_(FOOD_VALUE);
    }

    public void setFood(Integer val) {
        this.f_19804_.m_135381_(FOOD_VALUE, (Object)val);
    }

    public boolean getFemale() {
        return (Boolean)this.f_19804_.m_135370_(FEMALE);
    }

    public void setFemale(boolean flag) {
        this.f_19804_.m_135381_(FEMALE, (Object)flag);
    }

    public Utils.AniMove getAniMove() {
        return Utils.AniMove.fromId((Integer)this.f_19804_.m_135370_(ANI_MOVE));
    }

    public void setAniMove(Utils.AniMove move) {
        this.f_19804_.m_135381_(ANI_MOVE, (Object)move.ordinal());
    }

    public int getSpecialMove() {
        return (Integer)this.f_19804_.m_135370_(SPECIAL_MOVE);
    }

    public void setSpecialMove(int move) {
        this.setAniMove(Utils.AniMove.SPECIAL);
        this.f_19804_.m_135381_(SPECIAL_MOVE, (Object)move);
    }

    public boolean shootGun(boolean precision) {
        if (Utils.hasFriendlyInLineOfFire((Mob)this, this.m_5448_())) {
            return false;
        }
        this.prepAttack();
        if (this.op.getSynIsBolting()) {
            this.op.aim(false);
        }
        if (this.op.getSynIsAiming() != precision) {
            this.op.aim(precision);
        }
        switch (this.op.shoot(() -> Float.valueOf(this.m_5686_(1.0f)), () -> Float.valueOf(this.m_5675_(1.0f)))) {
            case SUCCESS: {
                break;
            }
            case NOT_DRAW: {
                this.op.draw(() -> ((AbstractAgentEntity)this).m_21205_());
                break;
            }
            case NEED_BOLT: {
                this.op.bolt();
                break;
            }
            case NO_AMMO: {
                this.reloadGun();
                PacketHandler.CHANNELS.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new EntityRenderPacket(this.m_19879_(), 1));
                this.setAniMove(Utils.AniMove.RELOAD);
                this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12388_, SoundSource.BLOCKS, 1.2f, 0.5f);
                return true;
            }
        }
        return false;
    }

    protected void prepAttack() {
        float snapYaw = this.m_6080_();
        this.m_146922_(snapYaw);
        this.m_5618_(snapYaw);
    }

    public void reloadGun() {
        int reloadAmount = 0;
        ItemStack gunStack = this.m_21205_();
        AbstractGunItem gunItem = (AbstractGunItem)gunStack.m_41720_();
        ResourceLocation gunResource = gunItem.getGunId(gunStack);
        CommonGunIndex gunIndex = TimelessAPI.getCommonGunIndex((ResourceLocation)gunResource).orElse(null);
        int maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment((ItemStack)gunStack, (GunData)gunIndex.getGunData());
        int curAmmoCount = this.inventory.checkGunAmmo(gunStack, gunItem);
        int virtAmmo = this.getVirtualAmmo();
        if (virtAmmo > 0) {
            reloadAmount = Math.min(virtAmmo, maxAmmoCount - curAmmoCount);
            this.setVirtualAmmo(virtAmmo - reloadAmount);
        } else {
            int i = this.inventory.findGunAmmo(gunStack);
            if (i == -1) {
                return;
            }
            ItemStack ammoStack = this.inventory.m_8020_(i);
            Item item = ammoStack.m_41720_();
            if (item instanceof IAmmoBox) {
                IAmmoBox iAmmoBoxItem = (IAmmoBox)item;
                reloadAmount = Math.min(maxAmmoCount - curAmmoCount, iAmmoBoxItem.getAmmoCount(ammoStack));
                iAmmoBoxItem.setAmmoCount(ammoStack, iAmmoBoxItem.getAmmoCount(ammoStack) - reloadAmount);
            } else if (ammoStack.m_41720_() instanceof IAmmo) {
                reloadAmount = Math.min(maxAmmoCount - curAmmoCount, ammoStack.m_41613_());
                ammoStack.m_41764_(ammoStack.m_41613_() - reloadAmount);
            }
        }
        gunItem.setCurrentAmmoCount(gunStack, curAmmoCount + reloadAmount);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(9, (Goal)new CustomRandomStrollGoal(this, 0.4, 80));
        this.f_21345_.m_25352_(3, (Goal)new RechargeVirtualAmmo(this, 60));
        this.f_21345_.m_25352_(4, (Goal)new EatFoodGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new FollowGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new SaluteGoal(this, 100));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.m_9236_().m_5776_()) {
            if (this.getBossUUID() == null) {
                this.setBossUUID(player.m_20148_());
            }
            if (this.sameTeam((LivingEntity)player)) {
                if (player.m_21205_().m_41720_() instanceof SwordItem) {
                    Utils.TargetMode mode = this.nextTargetMode();
                    this.setTargetMode(mode);
                    String disp = switch (mode) {
                        default -> throw new IncompatibleClassChangeError();
                        case Utils.TargetMode.OFF -> this.m_7755_().getString() + " shall not seek battle";
                        case Utils.TargetMode.HOSTILE_ONLY -> this.m_7755_().getString() + " shall hunt down hostile";
                        case Utils.TargetMode.ENEMY_AGENTS -> this.m_7755_().getString() + " shall hunt down other players";
                        case Utils.TargetMode.ALL -> this.m_7755_().getString() + " shall hunt down hostile and other players";
                    };
                    player.m_5661_((Component)Component.m_237113_((String)disp), true);
                } else if (player.m_6047_()) {
                    int i = this.getMovement() == 2 ? 0 : this.getMovement() + 1;
                    this.setMovement(i, this.getBossUUID());
                    String disp = switch (i) {
                        case 0 -> this.m_7755_().getString() + " will wander around here";
                        case 1 -> this.m_7755_().getString() + " will stand guard";
                        case 2 -> {
                            Entity target = ((ServerLevel)this.m_9236_()).m_8791_(this.followPlayer);
                            String name = target != null ? target.m_7755_().getString() : "???";
                            yield this.m_7755_().getString() + " will follow " + name;
                        }
                        default -> "";
                    };
                    player.m_5661_((Component)Component.m_237113_((String)disp), true);
                } else {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buf -> buf.writeInt(this.m_19879_()));
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean sameTeam(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return this.isFriendlyPlayer(player, this.m_9236_());
        }
        if (entity instanceof IEntityTeam) {
            IEntityTeam teamer = (IEntityTeam)entity;
            return this.isFriendlyMod(teamer, this.m_9236_());
        }
        return false;
    }

    public SimpleContainer m_35311_() {
        return this.inventory;
    }

    public boolean m_7243_(ItemStack pStack) {
        return true;
    }

    protected void m_7581_(ItemEntity itemEntity) {
        int i;
        ItemStack input = itemEntity.m_32055_();
        if (input.m_41619_()) {
            return;
        }
        Item item = input.m_41720_();
        if (item instanceof ArmorItem) {
            int invSlot;
            ArmorItem armor = (ArmorItem)item;
            EquipmentSlot slot = armor.m_40402_();
            switch (slot) {
                case HEAD: {
                    int n = this.gearSlots[0];
                    break;
                }
                case CHEST: {
                    int n = this.gearSlots[1];
                    break;
                }
                case LEGS: {
                    int n = this.gearSlots[2];
                    break;
                }
                case FEET: {
                    int n = this.gearSlots[3];
                    break;
                }
                default: {
                    int n = invSlot = -1;
                }
            }
            if (invSlot != -1 && this.inventory.m_8020_(invSlot).m_41619_()) {
                this.inventory.m_6836_(invSlot, input);
                this.m_8061_(slot, input);
                itemEntity.m_146870_();
                return;
            }
        }
        if (this.isEquipableGun(input) && this.inventory.m_8020_(4).m_41619_()) {
            this.inventory.m_6836_(4, input);
            itemEntity.m_146870_();
            return;
        }
        if (this.isEquipableMelee(input) && this.inventory.m_8020_(5).m_41619_()) {
            this.inventory.m_6836_(5, input);
            itemEntity.m_146870_();
            return;
        }
        ItemStack special = this.inventory.m_8020_(6);
        if (special.m_41619_()) {
            this.inventory.m_6836_(6, input);
            itemEntity.m_146870_();
            return;
        }
        if (ItemStack.m_150942_((ItemStack)special, (ItemStack)input) && special.m_41613_() < special.m_41741_()) {
            int move = Math.min(input.m_41613_(), special.m_41741_() - special.m_41613_());
            special.m_41769_(move);
            input.m_41774_(move);
            if (input.m_41619_()) {
                itemEntity.m_146870_();
                return;
            }
        }
        for (i = 7; i < this.inventory.m_6643_(); ++i) {
            ItemStack slot = this.inventory.m_8020_(i);
            if (slot.m_41619_() || !ItemStack.m_150942_((ItemStack)slot, (ItemStack)input) || slot.m_41613_() >= slot.m_41741_()) continue;
            int move = Math.min(input.m_41613_(), slot.m_41741_() - slot.m_41613_());
            slot.m_41769_(move);
            input.m_41774_(move);
            if (!input.m_41619_()) continue;
            itemEntity.m_146870_();
            return;
        }
        for (i = 7; i < this.inventory.m_6643_(); ++i) {
            if (!this.inventory.m_8020_(i).m_41619_()) continue;
            this.inventory.m_6836_(i, input);
            itemEntity.m_146870_();
            return;
        }
        itemEntity.m_32045_(input);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        LivingEntity living;
        Entity entity = source.m_7639_();
        if (this.invincible) {
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12346_, SoundSource.BLOCKS, 1.0f, 0.5f);
            return false;
        }
        if (entity != null && entity instanceof LivingEntity && !this.sameTeam(living = (LivingEntity)entity)) {
            this.m_6710_(living);
        }
        return super.m_6469_(source, amount);
    }

    protected void m_6472_(DamageSource pSource, float pDamage) {
        if (!(pDamage <= 0.0f)) {
            if ((pDamage /= 4.0f) < 1.0f) {
                pDamage = 1.0f;
            }
            AtomicBoolean brokenArmorPiece = new AtomicBoolean(false);
            for (ItemStack piece : this.m_6168_()) {
                if (pSource.m_269533_(DamageTypeTags.f_268745_) && piece.m_41720_().m_41475_() || !(piece.m_41720_() instanceof ArmorItem)) continue;
                piece.m_41622_((int)pDamage, (LivingEntity)this, e -> {
                    e.m_21166_(LivingEntity.m_147233_((ItemStack)piece));
                    brokenArmorPiece.set(true);
                });
            }
            if (brokenArmorPiece.get()) {
                this.inventory.loadArmor();
                brokenArmorPiece.set(false);
            }
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        ListTag invTag = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack stack = this.inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128344_("Slot", (byte)i);
            stack.m_41739_(itemTag);
            invTag.add((Object)itemTag);
        }
        nbt.m_128365_("AgentInventory", (Tag)invTag);
        nbt.m_128405_("Food", this.getFood().intValue());
        if (this.getBossUUID() != null) {
            nbt.m_128362_("owner_uuid", this.getBossUUID());
        }
        nbt.m_128379_("allow_special", this.getAllowSpecial());
        nbt.m_128405_("auto_hostile", ((Integer)this.f_19804_.m_135370_(AUTO_HOSTILE_F)).intValue());
        nbt.m_128379_("is_female", this.getFemale());
        nbt.m_128359_("skin", (String)this.f_19804_.m_135370_(SKIN));
        nbt.m_128405_("movement", this.getMovement());
        nbt.m_128405_("virtual_ammo", this.getVirtualAmmo());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.persistedFromNBT = true;
        ListTag invTag = nbt.m_128437_("AgentInventory", 10);
        for (int i = 0; i < invTag.size(); ++i) {
            CompoundTag itemTag = invTag.m_128728_(i);
            int slot = itemTag.m_128445_("Slot") & 0xFF;
            if (slot >= this.inventory.m_6643_()) continue;
            this.inventory.m_6836_(slot, ItemStack.m_41712_((CompoundTag)itemTag));
        }
        this.setFood(nbt.m_128451_("Food"));
        if (nbt.m_128441_("owner_uuid")) {
            this.setBossUUID(nbt.m_128342_("owner_uuid"));
        } else {
            this.setBossUUID(null);
        }
        this.setAllowSpecial(nbt.m_128471_("allow_special"));
        this.setTargetMode(Utils.TargetMode.values()[nbt.m_128451_("auto_hostile")]);
        this.setFemale(nbt.m_128471_("is_female"));
        this.f_19804_.m_135381_(SKIN, (Object)nbt.m_128461_("skin"));
        this.setMovement(nbt.m_128451_("movement"), this.getBossUUID());
        this.setVirtualAmmo(nbt.m_128451_("virtual_ammo"));
    }

    public void initCosmetic() {
        boolean isFemale = ThreadLocalRandom.current().nextBoolean();
        this.m_6593_((Component)Component.m_237113_((String)Utils.randomName(isFemale)));
        this.setFemale(isFemale);
        this.f_19804_.m_135381_(SKIN, (Object)SkinManager.renerateRandom(isFemale));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(level, difficulty, reason, spawnData, dataTag);
        this.m_21559_(false);
        if (!this.persistedFromNBT) {
            boolean isFemale = ThreadLocalRandom.current().nextBoolean();
            this.m_6593_((Component)Component.m_237113_((String)Utils.randomName(isFemale)));
            this.setFemale(isFemale);
            this.f_19804_.m_135381_(SKIN, (Object)SkinManager.renerateRandom(isFemale));
        }
        return data;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHit) {
        super.m_7472_(source, looting, recentlyHit);
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack stack = this.inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            this.m_19983_(stack);
        }
    }

    private void passiveRegen() {
        this.setFood(this.getFood() - 1);
        this.m_5634_(1.0f);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.f_19797_ % 80 == 0) {
            AttributeInstance attr = this.m_21051_(Attributes.f_22279_);
            if ((double)this.getFood().intValue() >= (double)this.maxfood * 0.4) {
                if (attr != null && !attr.m_22109_(AgentAttribute.WELL_FEED_SPEED_BOOST)) {
                    attr.m_22118_(AgentAttribute.WELL_FEED_SPEED_BOOST);
                }
            } else if (attr != null && attr.m_22109_(AgentAttribute.WELL_FEED_SPEED_BOOST)) {
                attr.m_22130_(AgentAttribute.WELL_FEED_SPEED_BOOST);
            }
            if (this.m_21223_() < this.m_21233_() && (double)this.getFood().intValue() >= (double)this.maxfood * 0.25) {
                this.passiveRegen();
            }
        }
    }

    public boolean moveto(Entity pEntity, double pSpeed) {
        if (--this.pathCooldown <= 0) {
            this.pathCooldown = 10;
            return this.m_21573_().m_5624_(pEntity, pSpeed);
        }
        return true;
    }

    public void stopNav() {
        this.m_21573_().m_26573_();
        this.pathCooldown = 0;
    }

    public AbstractContainerMenu m_7208_(int containerID, Inventory inventory, Player player) {
        return new AgentInventoryMenu(containerID, inventory, this);
    }

    public void equipGun() {
        if (this.m_21205_() != this.inventory.m_8020_(4)) {
            this.m_21008_(InteractionHand.MAIN_HAND, this.inventory.m_8020_(4));
            IGunOperator op = IGunOperator.fromLivingEntity((LivingEntity)this);
            op.draw(() -> ((AbstractAgentEntity)this).m_21205_());
        }
    }

    public void equipMelee() {
        this.m_21008_(InteractionHand.MAIN_HAND, this.inventory.m_8020_(5));
    }

    public void equipSpecial(boolean offhand) {
        this.m_21008_(offhand ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND, this.inventory.m_8020_(6));
    }

    public ItemStack getSpecialSlot() {
        return this.inventory.m_8020_(6);
    }

    public ItemStack getGunSlot() {
        return this.inventory.m_8020_(4);
    }

    public boolean isEquipableGun(ItemStack stack) {
        return false;
    }

    public boolean isEquipableMelee(ItemStack stack) {
        return false;
    }

    public int getMaxVirtualAmmo() {
        return 0;
    }

    public int getAmmoPerCharge() {
        return 1;
    }
}

