/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.entity.extra;

import com.github.ptran779.aegisops.Utils;
import com.github.ptran779.aegisops.server.BlockInit;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class FallingDropPod
extends LivingEntity {
    private float xrand = 0.0f;
    private float zrand = 0.0f;
    private static final EntityDataAccessor<Float> DATA_HEALTH = SynchedEntityData.m_135353_(FallingDropPod.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public FallingDropPod(EntityType<? extends FallingDropPod> type, Level level) {
        super(type, level);
    }

    public void setDrift(float xrand, float zrand) {
        this.xrand = xrand;
        this.zrand = zrand;
    }

    public boolean m_6087_() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5), this.m_20186_(), this.m_20189_() + (this.f_19796_.m_188500_() - 0.5), 0.0, 0.1, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() - 0.5, this.m_20186_(), this.m_20189_() - 0.5 + (this.f_19796_.m_188500_() - 0.5), 0.0, 0.02, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + 0.5, this.m_20186_(), this.m_20189_() - 0.5 + (this.f_19796_.m_188500_() - 0.5), 0.0, 0.02, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() - 0.5, this.m_20186_(), this.m_20189_() + 0.5 + (this.f_19796_.m_188500_() - 0.5), 0.0, 0.02, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + 0.5, this.m_20186_(), this.m_20189_() + 0.5 + (this.f_19796_.m_188500_() - 0.5), 0.0, 0.02, 0.0);
        } else {
            if (!this.m_20197_().isEmpty()) {
                for (Entity passenger : this.m_20197_()) {
                    if (!(passenger instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)passenger;
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 40, 10, false, false));
                }
            }
            Vec3 motion = this.m_20184_();
            double downwardSpeed = Math.max(motion.f_82480_, -1.0);
            this.m_20334_(motion.f_82479_ + (double)this.xrand, downwardSpeed, motion.f_82481_ + (double)this.zrand);
            if (this.m_20096_()) {
                this.triggerCrash();
            }
        }
    }

    public boolean m_7310_(Entity passenger) {
        return this.m_20197_().isEmpty();
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction moveFunc) {
        if (passenger != null && this.m_20363_(passenger)) {
            moveFunc.m_20372_(passenger, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!this.m_9236_().f_46443_) {
            player.m_20329_((Entity)this);
        }
        return InteractionResult.SUCCESS;
    }

    private void triggerCrash() {
        this.m_20153_();
        Level level = this.m_9236_();
        ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 20, 0.3, 0.3, 0.3, 0.05);
        level.m_5594_(null, this.m_20183_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 1.5f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
        BlockPos groundPos = Utils.findSolidGroundBelow(this.m_20183_(), level);
        if (groundPos != null) {
            for (int i = 0; i < 8; ++i) {
                int dz;
                int dx = level.f_46441_.m_188503_(5) - 2;
                BlockPos firePos = groundPos.m_7918_(dx, 1, dz = level.f_46441_.m_188503_(5) - 2);
                if (!level.m_8055_(firePos).m_60795_() || !level.m_8055_(firePos.m_7495_()).m_60804_((BlockGetter)level, firePos.m_7495_())) continue;
                level.m_7731_(firePos, Blocks.f_50083_.m_49966_(), 11);
            }
            level.m_46597_(groundPos.m_7494_(), ((Block)BlockInit.DROP_POD.get()).m_49966_());
        }
        this.m_146870_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_HEALTH, (Object)Float.valueOf(100.0f));
    }

    public Iterable<ItemStack> m_6168_() {
        return Collections.emptyList();
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        return ItemStack.f_41583_;
    }

    public HumanoidArm m_5737_() {
        return null;
    }

    public void m_8061_(EquipmentSlot equipmentSlot, ItemStack itemStack) {
    }
}

