/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.entity.extra;

import com.github.ptran779.aegisops.entity.api.IEntityRender;
import com.github.ptran779.aegisops.entity.structure.DBTurret;
import com.github.ptran779.aegisops.network.EntityRenderPacket;
import com.github.ptran779.aegisops.network.PacketHandler;
import com.github.ptran779.aegisops.server.BlockInit;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class FallingHellPod
extends LivingEntity
implements IEntityRender {
    private float xrand = 0.0f;
    private float zrand = 0.0f;
    public float timeTrigger = 0.0f;
    private static final EntityDataAccessor<Boolean> DEPLOYED = SynchedEntityData.m_135353_(DBTurret.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public void setDrift(float xrand, float zrand) {
        this.xrand = xrand;
        this.zrand = zrand;
    }

    public FallingHellPod(EntityType<? extends FallingHellPod> type, Level level) {
        super(type, level);
    }

    public boolean isDeployed() {
        return (Boolean)this.f_19804_.m_135370_(DEPLOYED);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DEPLOYED, (Object)false);
    }

    public boolean m_6087_() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.01);
            Vec3 motion = this.m_20184_();
            double downwardSpeed = Math.max(motion.f_82480_, -1.0);
            if (this.isDeployed()) {
                if ((float)this.f_19797_ - this.timeTrigger > 20.0f) {
                    int i;
                    if (this.f_19797_ % 4 == 0) {
                        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                    }
                    for (i = 0; i < 2; ++i) {
                        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + 0.8 + (double)i * 0.3, this.m_20186_() + 2.4 - (double)i * 0.4, this.m_20189_(), 1, 0.0, 0.0, 0.1, 0.01);
                    }
                    for (i = 0; i < 2; ++i) {
                        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() - 0.8 - (double)i * 0.3, this.m_20186_() + 2.4 - (double)i * 0.4, this.m_20189_(), 1, 0.0, 0.0, 0.1, 0.01);
                    }
                    for (i = 0; i < 2; ++i) {
                        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + 2.4 - (double)i * 0.4, this.m_20189_() - 0.8 - (double)i * 0.3, 1, 0.1, 0.0, 0.0, 0.01);
                    }
                    for (i = 0; i < 2; ++i) {
                        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + 2.4 - (double)i * 0.4, this.m_20189_() + 0.8 + (double)i * 0.3, 1, 0.1, 0.0, 0.0, 0.01);
                    }
                    downwardSpeed = Math.max(motion.f_82480_, -0.5);
                }
            } else {
                BlockPos below = this.m_20183_();
                int groundY = this.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, below.m_123341_(), below.m_123343_());
                int currentY = this.m_146904_();
                if (currentY - groundY <= 60) {
                    this.f_19804_.m_135381_(DEPLOYED, (Object)true);
                    PacketHandler.CHANNELS.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new EntityRenderPacket(this.m_19879_(), 1));
                    this.resetRenderTick();
                }
            }
            if (!this.m_20197_().isEmpty()) {
                for (Entity passenger : this.m_20197_()) {
                    if (!(passenger instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)passenger;
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 40, 10, false, false));
                }
            }
            this.m_20334_(motion.f_82479_ + (double)this.xrand, downwardSpeed, motion.f_82481_ + (double)this.zrand);
            if (this.m_20096_()) {
                this.triggerCrash();
            }
        }
    }

    private void triggerCrash() {
        Level level = this.m_9236_();
        ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 20, 0.3, 0.3, 0.3, 0.05);
        level.m_5594_(null, this.m_20183_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
        level.m_5594_(null, this.m_20183_(), SoundEvents.f_11668_, SoundSource.BLOCKS, 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
        BlockPos botPos = this.m_20183_().m_7495_();
        BlockPos bePos = botPos.m_7495_();
        level.m_7731_(botPos, Blocks.f_50016_.m_49966_(), 3);
        level.m_7731_(bePos, ((Block)BlockInit.HELL_POD.get()).m_49966_(), 3);
        if (!this.m_20197_().isEmpty()) {
            this.m_20197_().forEach(entity -> {
                entity.m_8127_();
                entity.m_6021_((double)bePos.m_123341_() + 0.5, (double)bePos.m_123342_() + 0.1, (double)bePos.m_123343_() + 0.5);
            });
        }
        this.m_146870_();
    }

    public boolean m_7310_(Entity passenger) {
        return this.m_20197_().isEmpty();
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction moveFunc) {
        if (passenger != null && this.m_20363_(passenger)) {
            moveFunc.m_20372_(passenger, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_());
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!this.m_9236_().f_46443_) {
            player.m_20329_((Entity)this);
        }
        return InteractionResult.SUCCESS;
    }

    public Iterable<ItemStack> m_6168_() {
        return Collections.emptyList();
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        return ItemStack.f_41583_;
    }

    public HumanoidArm m_5737_() {
        return null;
    }

    public void m_8061_(EquipmentSlot equipmentSlot, ItemStack itemStack) {
    }

    @Override
    public void resetRenderTick() {
        this.timeTrigger = this.f_19797_;
    }
}

