/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.entity.inventory;

import com.github.ptran779.aegisops.entity.agent.AbstractAgentEntity;
import com.github.ptran779.aegisops.entity.inventory.AgentInventory;
import com.github.ptran779.aegisops.entity.inventory.ArmorSlot;
import com.github.ptran779.aegisops.entity.inventory.GunSlot;
import com.github.ptran779.aegisops.entity.inventory.MeleeSlot;
import com.github.ptran779.aegisops.server.MenuInit;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class AgentInventoryMenu
extends AbstractContainerMenu {
    private final AgentInventory agentInv;
    private final Container playerInv;
    public final AbstractAgentEntity agent;

    public AgentInventoryMenu(int containerId, Inventory playerInventory, FriendlyByteBuf buf) {
        this(containerId, playerInventory, (AbstractAgentEntity)playerInventory.f_35978_.m_9236_().m_6815_(buf.readInt()));
    }

    public AgentInventoryMenu(int containerId, Inventory playerInventory, AbstractAgentEntity agent) {
        super((MenuType)MenuInit.AEGISOPS_MENU.get(), containerId);
        this.agent = agent;
        this.agentInv = agent.inventory;
        this.playerInv = playerInventory;
        this.agentInv.syncArmor();
        this.loadInventoryMenu();
    }

    private void loadInventoryMenu() {
        for (int i = 7; i < this.agentInv.m_6643_(); ++i) {
            this.m_38897_(new Slot((Container)this.agentInv, i, 61 + (i - 7) * 18, 57));
        }
        this.m_38897_(new GunSlot(this.agentInv, this.agent.gunSlot, 14, 120));
        this.m_38897_(new MeleeSlot(this.agentInv, this.agent.meleeSlot, 34, 120));
        this.m_38897_(new Slot((Container)this.agentInv, this.agent.specialSlot, 24, 139));
        this.m_38897_(new ArmorSlot(this.agentInv, this.agent.gearSlots[0], 14, 82, EquipmentSlot.HEAD));
        this.m_38897_(new ArmorSlot(this.agentInv, this.agent.gearSlots[1], 34, 82, EquipmentSlot.CHEST));
        this.m_38897_(new ArmorSlot(this.agentInv, this.agent.gearSlots[2], 14, 101, EquipmentSlot.LEGS));
        this.m_38897_(new ArmorSlot(this.agentInv, this.agent.gearSlots[3], 34, 101, EquipmentSlot.FEET));
        for (int c = 0; c < 9; ++c) {
            this.m_38897_(new Slot(this.playerInv, c, 61 + c * 18, 141));
        }
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 9; ++c) {
                this.m_38897_(new Slot(this.playerInv, c + r * 9 + 9, 61 + c * 18, 85 + r * 17));
            }
        }
    }

    public ItemStack m_7648_(Player player, int stackIndex) {
        Slot slot = (Slot)this.f_38839_.get(stackIndex);
        ItemStack stack = slot.m_7993_();
        if (!slot.m_6657_() || stack.m_41613_() <= 0) {
            return ItemStack.f_41583_;
        }
        ItemStack copyStack = stack.m_41777_();
        ItemStack itemStack = slot.m_7993_();
        if (stackIndex < this.agentInv.m_6643_() && !this.m_38903_(itemStack, this.agentInv.m_6643_(), this.f_38839_.size(), false)) {
            return ItemStack.f_41583_;
        }
        if (!this.m_38903_(itemStack, 0, this.agentInv.m_6643_(), true)) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, itemStack);
        return copyStack;
    }

    public boolean m_6875_(Player player) {
        return this.agentInv.m_6542_(player);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.agentInv.loadArmor();
    }
}

