/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.entity.structure;

import com.github.ptran779.aegisops.Config.ServerConfig;
import com.github.ptran779.aegisops.Utils;
import com.github.ptran779.aegisops.entity.api.IEntityTarget;
import com.github.ptran779.aegisops.entity.extra.TurretBullet;
import com.github.ptran779.aegisops.entity.structure.AbstractAgentStruct;
import com.github.ptran779.aegisops.goal.common.CustomRangeTargetGoal;
import com.github.ptran779.aegisops.goal.structure.DBTurretAttackGoal;
import com.github.ptran779.aegisops.item.EngiHammerItem;
import com.github.ptran779.aegisops.network.EntityRenderPacket;
import com.github.ptran779.aegisops.network.PacketHandler;
import com.github.ptran779.aegisops.server.EntityInit;
import com.github.ptran779.aegisops.server.ItemInit;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class DBTurret
extends AbstractAgentStruct
implements IEntityTarget {
    public static final int T_OFFSET = -40;
    private Utils.TargetMode targetMode = Utils.TargetMode.OFF;
    public static final EntityDataAccessor<Boolean> DEPLOYED = SynchedEntityData.m_135353_(DBTurret.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> LEFT_BARREL = SynchedEntityData.m_135353_(DBTurret.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float cannonProgress = Float.MAX_VALUE;

    public DBTurret(EntityType<? extends Mob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public int getMaxCharge() {
        return (Integer)ServerConfig.BD_TURRET_CHARGE_MAX.get();
    }

    @Override
    public boolean haveWeapon() {
        return this.charge > 0;
    }

    @Override
    public Utils.TargetMode getTargetMode() {
        return this.targetMode;
    }

    @Override
    public void setTargetMode(Utils.TargetMode mode) {
        this.targetMode = mode;
    }

    @Override
    public Utils.TargetMode nextTargetMode() {
        return Utils.TargetMode.nextTargetMode(this.targetMode.ordinal());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DEPLOYED, (Object)false);
        this.f_19804_.m_135372_(LEFT_BARREL, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("deployed", ((Boolean)this.f_19804_.m_135370_(DEPLOYED)).booleanValue());
        nbt.m_128405_("auto_hostile", this.targetMode.ordinal());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.f_19804_.m_135381_(DEPLOYED, (Object)nbt.m_128471_("deployed"));
        this.targetMode = Utils.TargetMode.fromId(nbt.m_128451_("auto_hostile"));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(3, new CustomRangeTargetGoal<LivingEntity>(this, LivingEntity.class, 40, 24.0, 24.0, true, entity -> this.shouldTargetEntity(this, (LivingEntity)entity)));
        this.f_21345_.m_25352_(3, (Goal)new DBTurretAttackGoal(this, 24.0, 10));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.m_9236_().f_46443_ && this.sameTeam((LivingEntity)player)) {
            if (!((Boolean)this.f_19804_.m_135370_(DEPLOYED)).booleanValue()) {
                player.m_5661_((Component)Component.m_237113_((String)"Turret will be ready soon").m_130940_(ChatFormatting.GOLD), true);
            } else if (player.m_21205_().m_41720_() instanceof SwordItem) {
                Utils.TargetMode mode = this.nextTargetMode();
                this.setTargetMode(mode);
                String disp = switch (mode) {
                    default -> throw new IncompatibleClassChangeError();
                    case Utils.TargetMode.OFF -> "Turret will idle";
                    case Utils.TargetMode.HOSTILE_ONLY -> "Turret will aim at hostile";
                    case Utils.TargetMode.ENEMY_AGENTS -> "Turret will aim at other players";
                    case Utils.TargetMode.ALL -> "Turret will aim at both hostile and other players";
                };
                player.m_5661_((Component)Component.m_237113_((String)disp), true);
            } else if (player.m_21205_().m_41720_() instanceof EngiHammerItem) {
                this.m_19983_(new ItemStack((ItemLike)ItemInit.DB_TURRET_ITEM.get()));
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_175830_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5, 0.0, 2.0, 0.0, 0.02);
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11824_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.m_146870_();
            } else {
                player.m_5661_((Component)Component.m_237113_((String)("Turret has " + this.charge + "/" + this.getMaxCharge() + " charge")).m_130940_(ChatFormatting.GOLD), true);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && !((Boolean)this.f_19804_.m_135370_(DEPLOYED)).booleanValue()) {
            int off_tick = this.f_19797_ + -40;
            ServerLevel level = (ServerLevel)this.m_9236_();
            if (off_tick == 20) {
                level.m_6269_(null, (Entity)this, SoundEvents.f_11881_, SoundSource.BLOCKS, 1.2f, 1.0f);
                level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 20, 0.0, 1.0, 0.0, 0.02);
            } else if (off_tick == 100) {
                level.m_6269_(null, (Entity)this, SoundEvents.f_11889_, SoundSource.BLOCKS, 1.2f, 1.0f);
            } else if (off_tick == 180 || off_tick == 190) {
                level.m_6269_(null, (Entity)this, SoundEvents.f_12312_, SoundSource.BLOCKS, 1.2f, 1.0f);
                level.m_8767_((ParticleOptions)ParticleTypes.f_123749_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 20, 0.0, 2.0, 0.0, 0.02);
            } else if (off_tick == 200) {
                this.f_19804_.m_135381_(DEPLOYED, (Object)true);
            }
        }
    }

    public void shoot() {
        if (!((Boolean)this.f_19804_.m_135370_(DEPLOYED)).booleanValue()) {
            return;
        }
        if (this.charge <= 0) {
            return;
        }
        --this.charge;
        if (Utils.hasFriendlyInLineOfFire(this, this.m_5448_())) {
            return;
        }
        boolean gunBarrel = (Boolean)this.f_19804_.m_135370_(LEFT_BARREL) == false;
        this.f_19804_.m_135381_(LEFT_BARREL, (Object)gunBarrel);
        double offset = gunBarrel ? 0.35 : -0.35;
        float pitch = this.m_146909_();
        float yaw = this.m_6080_();
        TurretBullet bullet = new TurretBullet((EntityType<? extends TurretBullet>)((EntityType)EntityInit.TURRET_BULLET.get()), this.m_9236_());
        bullet.init((Double)ServerConfig.BD_TURRET_DPS.get());
        bullet.m_6034_(this.m_20185_() + (double)Mth.m_14089_((float)yaw) * offset, this.m_20188_() - 0.02, this.m_20189_() + (double)Mth.m_14031_((float)yaw) * offset);
        Vec3 look = Vec3.m_82498_((float)pitch, (float)yaw);
        double speed = 2.0;
        bullet.m_20256_(look.m_82490_(speed));
        bullet.m_5602_((Entity)this);
        this.m_9236_().m_7967_((Entity)bullet);
        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_11928_, SoundSource.HOSTILE, 0.6f, 1.2f);
        PacketHandler.CHANNELS.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new EntityRenderPacket(this.m_19879_(), 1));
    }

    @Override
    public void resetRenderTick() {
        this.cannonProgress = this.f_19797_;
    }
}

