/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.goal.common;

import com.github.ptran779.aegisops.Utils;
import com.github.ptran779.aegisops.attribute.AgentAttribute;
import com.github.ptran779.aegisops.client.animation.AgentLivingAnimation;
import com.github.ptran779.aegisops.entity.agent.AbstractAgentEntity;
import com.github.ptran779.aegisops.network.EntityRenderPacket;
import com.github.ptran779.aegisops.network.PacketHandler;
import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class AgentAttackGoal
extends Goal {
    protected final AbstractAgentEntity agent;
    protected int attackCoolDown = 0;
    protected final double meleeRangeSq;
    protected final double gunLowRangeSq;
    protected final double gunHighRangeSq;
    protected int strikeTick = -1;
    protected boolean meleeYes = false;
    protected boolean gunYes = false;
    double targetDistSq = 0.0;
    protected boolean skip = false;

    public AgentAttackGoal(AbstractAgentEntity agent, double meleeRange, double gunLowRange, double gunHighRange) {
        this.agent = agent;
        this.meleeRangeSq = meleeRange * meleeRange;
        this.gunLowRangeSq = gunLowRange * gunLowRange;
        this.gunHighRangeSq = gunHighRange * gunHighRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    private int computeAttackCooldown() {
        return (int)(20.0 / this.agent.m_21051_(AgentAttribute.AGENT_ATTACK_SPEED).m_22135_());
    }

    protected double getAttackReachSqr(LivingEntity target) {
        return Math.pow((this.agent.m_20205_() + target.m_20205_()) / 2.0f + 2.0f, 2.0);
    }

    protected void prepAttack() {
        float snapYaw = this.agent.m_6080_();
        this.agent.m_146922_(snapYaw);
        this.agent.m_5618_(snapYaw);
    }

    public boolean m_8036_() {
        return !this.agent.m_6117_() && this.agent.m_5448_() != null && this.agent.m_5448_().m_6084_() && this.WandECheck();
    }

    public boolean m_8045_() {
        return !this.skip && this.m_8036_();
    }

    private boolean WandECheck() {
        this.meleeYes = this.agent.inventory.meleeExist();
        this.gunYes = this.agent.inventory.gunExistWithAmmo();
        return this.meleeYes || this.gunYes;
    }

    public void m_8056_() {
        this.agent.m_21561_(true);
        this.attackCoolDown = this.computeAttackCooldown();
        this.skip = false;
    }

    public void m_8041_() {
        this.agent.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        this.agent.setAniMove(Utils.AniMove.NORM);
        this.agent.m_21561_(false);
        this.agent.stopNav();
        this.agent.op.aim(false);
        if (this.agent.m_5448_() == null) {
            this.agent.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        this.agent.m_5810_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity target = this.agent.m_5448_();
        if (target == null) {
            return;
        }
        this.agent.m_21563_().m_148051_((Entity)target);
        this.targetDistSq = this.agent.m_20280_((Entity)this.agent.m_5448_());
        if (this.strikeTick > 0) {
            if (--this.strikeTick == 10) {
                --this.strikeTick;
                Vec3 look = this.agent.m_20154_();
                double dashSpeed = 0.5;
                this.agent.m_20334_(look.f_82479_ * dashSpeed, this.agent.m_20184_().f_82480_, look.f_82481_ * dashSpeed);
                if (this.targetDistSq < this.getAttackReachSqr(target)) {
                    this.agent.m_7327_((Entity)target);
                    this.agent.m_21205_().m_41622_(1, (LivingEntity)this.agent, e -> e.m_21190_(InteractionHand.MAIN_HAND));
                }
            } else if (this.strikeTick <= 0) {
                this.agent.setAniMove(Utils.AniMove.NORM);
                this.attackCoolDown = this.computeAttackCooldown();
            }
            return;
        }
        if (this.attackCoolDown > 0) {
            --this.attackCoolDown;
        }
        if (this.attackCoolDown <= 0) {
            this.agent.setAniMove(Utils.AniMove.NORM);
            if (this.meleeYes && (this.targetDistSq < this.meleeRangeSq || !this.gunYes && this.targetDistSq < this.meleeRangeSq * 4.0)) {
                this.agent.equipMelee();
                if (this.getAttackReachSqr(target) + 2.0 > this.targetDistSq) {
                    this.prepAttack();
                    this.agent.stopNav();
                    this.strikeTick = 15;
                    PacketHandler.CHANNELS.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.agent), (Object)new EntityRenderPacket(this.agent.m_19879_(), 1));
                    this.agent.setAniMove(Utils.AniMove.ATTACK);
                } else if (!this.agent.moveto((Entity)target, this.agent.m_21051_(Attributes.f_22279_).m_22135_())) {
                    this.skip = true;
                }
            } else if (this.gunYes) {
                this.agent.equipGun();
                if (this.targetDistSq > this.gunHighRangeSq) {
                    this.agent.moveto((Entity)target, this.agent.m_21051_(Attributes.f_22279_).m_22135_());
                } else if (this.targetDistSq > this.gunLowRangeSq) {
                    this.agent.stopNav();
                    this.attackCoolDown = this.agent.shootGun(true) ? this.computeAttackCooldown() + (int)AgentLivingAnimation.RELOAD.f_232255_() * 20 : this.computeAttackCooldown();
                } else if (this.targetDistSq > this.meleeRangeSq || !this.meleeYes) {
                    this.attackCoolDown = this.agent.shootGun(false) ? this.computeAttackCooldown() + (int)AgentLivingAnimation.RELOAD.f_232255_() * 20 : this.computeAttackCooldown();
                }
            } else {
                this.skip = true;
            }
        }
    }
}

