/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.goal.special;

import com.github.ptran779.aegisops.Utils;
import com.github.ptran779.aegisops.entity.agent.AbstractAgentEntity;
import com.github.ptran779.aegisops.goal.AbstractThrottleGoal;
import com.github.ptran779.aegisops.item.ModularShieldItem;
import com.github.ptran779.aegisops.network.EntityRenderPacket;
import com.github.ptran779.aegisops.network.PacketHandler;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class ShieldBashGoal
extends AbstractThrottleGoal {
    AbstractAgentEntity agent;
    protected int tickProgress = -1;
    protected int phase = 0;
    protected final int cooldown;
    protected int lastCooldown;
    LivingEntity target;
    public static final int MAX_CHASE_TIME = 200;

    public ShieldBashGoal(AbstractAgentEntity agent, int checkInterval, int cooldown) {
        super((LivingEntity)agent, checkInterval);
        this.agent = agent;
        this.cooldown = cooldown;
        this.lastCooldown = agent.f_19797_;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    @Override
    public boolean m_8036_() {
        if (!(this.agent.f_19797_ - this.lastCooldown >= this.cooldown && this.agent.getAllowSpecial() && this.agent.getSpecialSlot().m_41720_() instanceof ModularShieldItem && super.m_8036_())) {
            return false;
        }
        this.target = this.agent.m_5448_();
        if (this.target == null || !this.target.m_6084_()) {
            return false;
        }
        Path path = this.agent.m_21573_().m_6570_((Entity)this.target, 0);
        this.resetThrottle();
        return path != null && path.m_77403_();
    }

    public boolean m_8045_() {
        return this.agent.getSpecialSlot().m_41720_() instanceof ModularShieldItem && this.phase <= 6 && this.agent.m_5448_() != null && this.agent.m_5448_().m_6084_();
    }

    public void m_8056_() {
        this.tickProgress = -1;
        this.phase = 0;
        this.agent.getSpecialSlot().m_41784_().m_128473_("DeployTick");
    }

    public void m_8041_() {
        this.lastCooldown = this.agent.f_19797_;
        this.phase = 0;
        this.agent.setAniMove(Utils.AniMove.NORM);
        this.agent.getSpecialSlot().m_41784_().m_128473_("DeployTick");
        this.agent.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        this.agent.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8037_() {
        int dummy = this.agent.f_19797_ - this.tickProgress;
        this.target = this.agent.m_5448_();
        if (this.target == null || !this.target.m_6084_()) {
            return;
        }
        this.agent.m_21563_().m_148051_((Entity)this.target);
        if (this.phase == 0) {
            if (this.tickProgress == -1) {
                this.agent.setSpecialMove(0);
                this.tickProgress = this.agent.f_19797_;
                PacketHandler.CHANNELS.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.agent), (Object)new EntityRenderPacket(this.agent.m_19879_(), 1));
            } else if (dummy == 15) {
                this.agent.equipSpecial(true);
            } else if (dummy == 20) {
                this.agent.getSpecialSlot().m_41784_().m_128356_("DeployTick", this.agent.m_9236_().m_46467_());
            } else if (dummy >= 80) {
                this.agent.m_9236_().m_6269_(null, (Entity)this.agent, SoundEvents.f_12577_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.agent.setSpecialMove(1);
                this.tickProgress = this.agent.f_19797_;
                PacketHandler.CHANNELS.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.agent), (Object)new EntityRenderPacket(this.agent.m_19879_(), 1));
                ++this.phase;
            }
        } else if (this.phase == 1) {
            if (dummy > 200) {
                this.phase = 7;
            } else if (this.agent.m_20280_((Entity)this.target) > 9.0) {
                this.agent.moveto((Entity)this.target, this.agent.m_21051_(Attributes.f_22279_).m_22135_() * 1.05);
            } else {
                this.agent.stopNav();
                this.agent.setSpecialMove(2);
                this.tickProgress = this.agent.f_19797_;
                PacketHandler.CHANNELS.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.agent), (Object)new EntityRenderPacket(this.agent.m_19879_(), 1));
                ++this.phase;
            }
        } else if (this.phase == 2) {
            this.agent.m_9236_().m_6269_(null, (Entity)this.agent, SoundEvents.f_11862_, SoundSource.BLOCKS, 1.0f, 1.0f);
            AABB scanArea = this.agent.m_20191_().m_82400_(8.0);
            List enemies = this.agent.m_9236_().m_6443_(Mob.class, scanArea, mob -> mob instanceof Monster && mob.m_6084_());
            for (Mob mob2 : enemies) {
                if (mob2.m_5448_() == null || mob2.m_5448_() == this.agent || !mob2.m_6779_((LivingEntity)this.agent)) continue;
                mob2.m_6710_((LivingEntity)this.agent);
            }
            LivingEntity livingEntity = this.target;
            if (livingEntity instanceof Mob) {
                Mob mob3 = (Mob)livingEntity;
                mob3.m_6710_((LivingEntity)this.agent);
            }
            ++this.phase;
            this.tickProgress = this.agent.f_19797_;
            this.agent.invincible = true;
        } else if (this.phase == 3) {
            if (dummy >= 100) {
                ++this.phase;
                this.tickProgress = this.agent.f_19797_;
                this.agent.setSpecialMove(3);
                PacketHandler.CHANNELS.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.agent), (Object)new EntityRenderPacket(this.agent.m_19879_(), 1));
            }
        } else if (this.phase == 4) {
            if (dummy == 30) {
                Vec3 forward = this.agent.m_20154_().m_82541_();
                AABB area = this.agent.m_20191_().m_82400_(3.0);
                List targets = this.agent.m_9236_().m_6443_(LivingEntity.class, area, e -> e != this.agent && e.m_6084_() && !this.agent.sameTeam((LivingEntity)e) && e.m_20280_((Entity)this.agent) <= 9.0 && this.isInFront(this.agent.m_20182_(), forward, e.m_20182_()));
                this.agent.m_9236_().m_6269_(null, (Entity)this.agent, SoundEvents.f_11668_, SoundSource.BLOCKS, 1.0f, 1.0f);
                for (LivingEntity target : targets) {
                    target.m_6469_(this.agent.m_269291_().m_269333_((LivingEntity)this.agent), (float)(4.0 + this.agent.m_21133_(Attributes.f_22281_)));
                    target.m_147240_(2.0, this.agent.m_20185_() - target.m_20185_(), this.agent.m_20189_() - target.m_20189_());
                }
            } else if (dummy >= 50) {
                this.agent.invincible = false;
                PacketHandler.CHANNELS.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.agent), (Object)new EntityRenderPacket(this.agent.m_19879_(), 1));
                this.tickProgress = this.agent.f_19797_;
                if (this.agent.inventory.gunExistWithAmmo()) {
                    this.agent.setSpecialMove(5);
                    this.agent.equipGun();
                    this.phase += 2;
                } else {
                    this.agent.setSpecialMove(4);
                    ++this.phase;
                }
            }
        } else if (this.phase == 5) {
            if (dummy >= 10) {
                this.phase += 2;
            }
        } else if (this.phase == 6) {
            if (dummy == 20 || dummy == 30 || dummy == 40) {
                this.agent.shootGun(false);
            } else if (dummy >= 60) {
                ++this.phase;
            }
        }
    }

    protected boolean isInFront(Vec3 selfPos, Vec3 forward, Vec3 targetPos) {
        Vec3 toTarget = targetPos.m_82546_(selfPos).m_82541_();
        double dot = forward.m_82526_(toTarget);
        double angle = Math.acos(dot) * 57.29577951308232;
        return angle <= 90.0;
    }
}

