/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.goal.special;

import com.github.ptran779.aegisops.Config.ServerConfig;
import com.github.ptran779.aegisops.Utils;
import com.github.ptran779.aegisops.entity.agent.AbstractAgentEntity;
import com.github.ptran779.aegisops.entity.structure.AbstractAgentStruct;
import com.github.ptran779.aegisops.goal.AbstractThrottleGoal;
import com.github.ptran779.aegisops.item.EngiHammerItem;
import com.github.ptran779.aegisops.network.EntityRenderPacket;
import com.github.ptran779.aegisops.network.PacketHandler;
import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;

public class WorkOnStructureGoal
extends AbstractThrottleGoal {
    AbstractAgentEntity agent;
    AbstractAgentStruct aStruct;
    protected int tickProgress = -1;

    public WorkOnStructureGoal(AbstractAgentEntity agent, int checkInterval) {
        super((LivingEntity)agent, checkInterval);
        this.agent = agent;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    @Override
    public boolean m_8036_() {
        if (!this.agent.getAllowSpecial() || this.aStruct != null) {
            return false;
        }
        if (!super.m_8036_()) {
            return false;
        }
        if (!(this.agent.getSpecialSlot().m_41720_() instanceof EngiHammerItem)) {
            return false;
        }
        this.aStruct = Utils.findNearestEntity(this.agent, AbstractAgentStruct.class, 16.0, entity -> entity.isFriendlyMod(this.agent, this.agent.m_9236_()) && entity.charge + (Integer)ServerConfig.ENGI_WORK_RECHARGE.get() <= entity.getMaxCharge());
        this.resetThrottle();
        return this.aStruct != null && this.aStruct.m_6084_();
    }

    public boolean m_8045_() {
        return this.aStruct != null && this.aStruct.m_6084_() && (this.agent.f_20916_ > 20 || this.agent.f_20916_ == 0);
    }

    public void m_8056_() {
        this.agent.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        this.tickProgress = -1;
    }

    public void m_8041_() {
        this.aStruct = null;
        this.agent.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        this.agent.setAniMove(Utils.AniMove.NORM);
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8037_() {
        if (this.aStruct == null) {
            return;
        }
        int dummy = this.agent.f_19797_ - this.tickProgress;
        this.agent.m_21563_().m_148051_((Entity)this.aStruct);
        if (this.agent.m_20280_((Entity)this.aStruct) > 4.0) {
            if (!this.agent.moveto((Entity)this.aStruct, this.agent.m_21051_(Attributes.f_22279_).m_22135_())) {
                this.aStruct = null;
            }
        } else if (this.tickProgress == -1) {
            PacketHandler.CHANNELS.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.agent), (Object)new EntityRenderPacket(this.agent.m_19879_(), 1));
            this.agent.setSpecialMove(0);
            this.tickProgress = this.agent.f_19797_;
        } else if (dummy == 10 || dummy == 20 || dummy == 30 || dummy == 40) {
            this.agent.m_9236_().m_6269_(null, (Entity)this.aStruct, SoundEvents.f_144135_, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (dummy == 60) {
            this.agent.equipSpecial(false);
        } else if (dummy == 85 || dummy == 100 || dummy == 115) {
            this.agent.m_9236_().m_6269_(null, (Entity)this.aStruct, SoundEvents.f_11668_, SoundSource.BLOCKS, 0.8f, 1.0f);
            ((ServerLevel)this.agent.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_175831_, this.aStruct.m_20185_(), this.aStruct.m_20186_() + 1.8, this.aStruct.m_20189_(), 10, 0.0, 1.0, 0.0, 0.02);
        } else if (dummy > 120) {
            this.aStruct.charge = Math.min(this.aStruct.charge + 20, this.aStruct.getMaxCharge());
            if (this.aStruct.m_21223_() < this.aStruct.m_21233_()) {
                this.aStruct.m_5634_(2.0f);
            }
            this.aStruct = null;
        }
    }
}

