/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.network;

import com.github.ptran779.aegisops.Utils;
import com.github.ptran779.aegisops.entity.agent.AbstractAgentEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class AgentHostilePacket {
    private final int entityId;
    private final int payload;

    public AgentHostilePacket(int entityId, int flag) {
        this.entityId = entityId;
        this.payload = flag;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.payload);
    }

    public static AgentHostilePacket decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        int payload = buf.readInt();
        return new AgentHostilePacket(entityId, payload);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Entity patt1144$temp = player.m_9236_().m_6815_(this.entityId);
            if (patt1144$temp instanceof AbstractAgentEntity) {
                AbstractAgentEntity agent = (AbstractAgentEntity)patt1144$temp;
                agent.setTargetMode(Utils.TargetMode.values()[this.payload]);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

