/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.network;

import com.github.ptran779.aegisops.entity.api.IEntityRender;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class EntityRenderPacket {
    private final int entityId;
    private final int payload;

    public EntityRenderPacket(int entityId, int payload) {
        this.entityId = entityId;
        this.payload = payload;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.payload);
    }

    public static EntityRenderPacket decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        int payload = buf.readInt();
        return new EntityRenderPacket(entityId, payload);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            Entity entity = level.m_6815_(this.entityId);
            if (!(entity instanceof IEntityRender)) {
                return;
            }
            IEntityRender iEntity = (IEntityRender)entity;
            iEntity.resetRenderTick();
        });
        ctx.get().setPacketHandled(true);
    }
}

