/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.server;

import com.github.ptran779.aegisops.Config.AgentConfigManager;
import com.github.ptran779.aegisops.Config.ServerConfig;
import com.github.ptran779.aegisops.Config.SkinManager;
import com.github.ptran779.aegisops.Utils;
import com.github.ptran779.aegisops.entity.extra.FallingHellPod;
import com.github.ptran779.aegisops.network.CameraModePacket;
import com.github.ptran779.aegisops.network.PacketHandler;
import com.github.ptran779.aegisops.server.EntityInit;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="aegisops", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeServerEvent {
    @SubscribeEvent
    public static void onConfigLoad(ServerStartingEvent event) {
        AgentConfigManager.serverGenerateDefault();
        SkinManager.reload();
    }

    @SubscribeEvent
    public static void deployHellPod(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ServerLevel level = event.getServer().m_129880_(Level.f_46428_);
        if (level == null) {
            return;
        }
        if (level.m_46467_() % (long)((Integer)ServerConfig.SPAWN_EVENT_PERIOD.get()).intValue() != 0L) {
            return;
        }
        for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
            if (level.f_46441_.m_188500_() >= (Double)ServerConfig.CHANCE_TO_SPAWN.get()) continue;
            double angle = level.f_46441_.m_188500_() * 2.0 * Math.PI;
            double distance = Mth.m_216263_((RandomSource)level.f_46441_, (double)((Integer)ServerConfig.MIN_SPAWN_DISTANCE.get()).intValue(), (double)((Integer)ServerConfig.MAX_SPAWN_DISTANCE.get()).intValue());
            double centerX = player.m_20185_() + Math.cos(angle) * distance;
            double centerZ = player.m_20189_() + Math.sin(angle) * distance;
            double centerY = level.m_151558_() - 1;
            int min = (Integer)ServerConfig.CLUSTER_SIZE_MIN.get();
            int max = (Integer)ServerConfig.CLUSTER_SIZE_MAX.get();
            int clusterSize = Mth.m_216271_((RandomSource)level.f_46441_, (int)min, (int)max);
            for (int i = 0; i < clusterSize; ++i) {
                double offsetX = centerX + (level.f_46441_.m_188500_() - 0.5) * 20.0;
                double offsetZ = centerZ + (level.f_46441_.m_188500_() - 0.5) * 20.0;
                Utils.summonReinforcement(offsetX, centerY, offsetZ, level);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        CompoundTag data;
        Player player = event.getEntity();
        CompoundTag persistentData = player.getPersistentData();
        if (!persistentData.m_128441_("PlayerPersisted")) {
            data = new CompoundTag();
            persistentData.m_128365_("PlayerPersisted", (Tag)data);
        } else {
            data = persistentData.m_128469_("PlayerPersisted");
        }
        if (!data.m_128471_("hasJoinedBefore")) {
            data.m_128379_("hasJoinedBefore", true);
            player.m_213846_((Component)Component.m_237113_((String)"Welcome to Aegis, Survivor."));
            FallingHellPod pod = new FallingHellPod((EntityType<? extends FallingHellPod>)((EntityType)EntityInit.FALLING_HELL_POD.get()), player.m_9236_());
            pod.m_6034_(player.m_20185_(), player.m_9236_().m_151558_() - 1, player.m_20189_());
            player.m_9236_().m_7967_((Entity)pod);
            player.m_7998_((Entity)pod, true);
            PacketHandler.CHANNELS.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new CameraModePacket());
        }
    }
}

