/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import carpet.api.settings.SettingsManager;
import carpet.patches.EntityPlayerMPFake;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_1934;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_4081;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.command.CommandRegister;
import org.carpetorgaddition.command.PlayerManagerCommand;
import org.carpetorgaddition.command.SpectatorCommand;
import org.carpetorgaddition.config.GlobalConfigs;
import org.carpetorgaddition.logger.LoggerRegister;
import org.carpetorgaddition.periodic.ServerComponentCoordinator;
import org.carpetorgaddition.periodic.express.ExpressManager;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerSerializer;
import org.carpetorgaddition.periodic.task.search.OfflinePlayerSearchTask;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.wheel.GameProfileCache;
import org.carpetorgaddition.wheel.Translation;
import org.carpetorgaddition.wheel.permission.PermissionManager;

public class CarpetOrgAdditionExtension
implements CarpetExtension {
    private static boolean settingsLoaded = false;

    public void onGameStarted() {
        CarpetOrgAdditionSettings.register();
        settingsLoaded = true;
    }

    public static SettingsManager getSettingManager() {
        return CarpetServer.settingsManager;
    }

    public static boolean isCarpetRuleLoaded() {
        return settingsLoaded;
    }

    public void onPlayerLoggedIn(class_3222 player) {
        CarpetOrgAdditionExtension.clearKnockback(player);
        ExpressManager expressManager = ServerComponentCoordinator.getCoordinator(FetcherUtils.getServer(player)).getExpressManager();
        expressManager.promptToReceive(player);
        PlayerManagerCommand.loadSafeAfk(player);
        MinecraftServer server = FetcherUtils.getServer(player);
        class_1934 gameMode = server.method_3761();
        if (gameMode != null) {
            SpectatorCommand instance = CommandRegister.getCommandInstance(SpectatorCommand.class);
            instance.loadPlayerPos(server, player);
        }
    }

    private static void clearKnockback(class_3222 player) {
        if (CarpetOrgAdditionSettings.fakePlayerSpawnNoKnockback.get().booleanValue() && player instanceof EntityPlayerMPFake) {
            player.method_18799(class_243.field_1353);
            player.method_20803(0);
            player.field_6017 = 0.0;
            player.method_6026().removeIf(effect -> ((class_1291)effect.method_5579().comp_349()).method_18792() == class_4081.field_18272);
        }
    }

    public void onServerLoadedWorlds(MinecraftServer server) {
        FakePlayerSerializer.autoLogin(server);
        PermissionManager.load(server);
        FetcherUtils.getRuleSelfManager(server).load();
    }

    public void onServerClosed(MinecraftServer server) {
        GameProfileCache.getInstance().save();
        PermissionManager.reset();
        GlobalConfigs.getInstance().save();
        OfflinePlayerSearchTask.clear();
    }

    public Map<String, String> canHasTranslations(String lang) {
        return Translation.getInstance().getTranslation();
    }

    public void registerLoggers() {
        LoggerRegister.register();
    }

    public void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 access) {
        CommandRegister.register(dispatcher, access);
    }
}

