/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.client.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1792;
import net.minecraft.class_2172;
import net.minecraft.class_2248;
import net.minecraft.class_7157;
import net.minecraft.class_8710;
import org.carpetorgaddition.client.command.AbstractClientCommand;
import org.carpetorgaddition.client.command.argument.ClientObjectArgumentType;
import org.carpetorgaddition.network.c2s.ObjectSearchTaskC2SPacket;
import org.carpetorgaddition.network.codec.ObjectSearchTaskCodecs;

public class ClientFinderCommand
extends AbstractClientCommand {
    public ClientFinderCommand(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 access) {
        super(dispatcher, access);
    }

    @Override
    public void register(String name) {
        this.dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)name).then(ClientCommandManager.literal((String)"item").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)ClientCommandManager.argument((String)"item", (ArgumentType)new ClientObjectArgumentType.ClientItemArgumentType(true)).executes(context -> this.searchItem((CommandContext<FabricClientCommandSource>)context, 64))).then(ClientCommandManager.argument((String)"range", (ArgumentType)IntegerArgumentType.integer((int)0, (int)256)).suggests(this.suggestionDefaultDistance()).executes(context -> this.searchItem((CommandContext<FabricClientCommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"range"))))).then(ClientCommandManager.literal((String)"from").then(ClientCommandManager.literal((String)"offline_player").executes(this::searchItem)))))).then(ClientCommandManager.literal((String)"block").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"block", (ArgumentType)new ClientObjectArgumentType.ClientBlockArgumentType(true)).executes(context -> this.searchBlock((CommandContext<FabricClientCommandSource>)context, 64))).then(ClientCommandManager.argument((String)"range", (ArgumentType)IntegerArgumentType.integer((int)0, (int)256)).suggests(this.suggestionDefaultDistance()).executes(context -> this.searchBlock((CommandContext<FabricClientCommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"range")))))));
    }

    private SuggestionProvider<FabricClientCommandSource> suggestionDefaultDistance() {
        return (context, builder) -> class_2172.method_9253((String[])new String[]{"64", "128", "256"}, (SuggestionsBuilder)builder);
    }

    private int searchItem(CommandContext<FabricClientCommandSource> context, int range) {
        List<class_1792> list = this.getItemList(context);
        ObjectSearchTaskCodecs.ItemSearchContext itemSearchContext = new ObjectSearchTaskCodecs.ItemSearchContext(range, list);
        JsonObject json = ObjectSearchTaskCodecs.ITEM_SEARCH_CODEC.encode(itemSearchContext);
        ObjectSearchTaskC2SPacket packet = new ObjectSearchTaskC2SPacket(ObjectSearchTaskC2SPacket.Type.ITEM, json);
        ClientPlayNetworking.send((class_8710)packet);
        return list.size();
    }

    private int searchItem(CommandContext<FabricClientCommandSource> context) {
        List<class_1792> list = this.getItemList(context);
        ObjectSearchTaskCodecs.OfflinePlayerItemSearchContext searchContext = new ObjectSearchTaskCodecs.OfflinePlayerItemSearchContext(list);
        JsonObject json = ObjectSearchTaskCodecs.OFFLINE_PLAYER_SEARCH_CODEC.encode(searchContext);
        ObjectSearchTaskC2SPacket packet = new ObjectSearchTaskC2SPacket(ObjectSearchTaskC2SPacket.Type.OFFLINE_PLAYER_ITEM, json);
        ClientPlayNetworking.send((class_8710)packet);
        return list.size();
    }

    private int searchBlock(CommandContext<FabricClientCommandSource> context, int range) {
        List<class_2248> list = ClientObjectArgumentType.getType(context, "block").stream().filter(t -> t instanceof class_2248).map(t -> (class_2248)t).toList();
        ObjectSearchTaskCodecs.BlockSearchContext searchContext = new ObjectSearchTaskCodecs.BlockSearchContext(range, list);
        JsonObject json = ObjectSearchTaskCodecs.BLOCK_SEARCH_CODEC.encode(searchContext);
        ObjectSearchTaskC2SPacket packet = new ObjectSearchTaskC2SPacket(ObjectSearchTaskC2SPacket.Type.BLOCK, json);
        ClientPlayNetworking.send((class_8710)packet);
        return list.size();
    }

    private List<class_1792> getItemList(CommandContext<FabricClientCommandSource> context) {
        return ClientObjectArgumentType.getType(context, "item").stream().filter(t -> t instanceof class_1792).map(t -> (class_1792)t).toList();
    }

    @Override
    public String getDefaultName() {
        return "clientfinder";
    }
}

