/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import carpet.patches.EntityPlayerMPFake;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1707;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3908;
import net.minecraft.class_747;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.periodic.ServerComponentCoordinator;
import org.carpetorgaddition.rule.value.OpenPlayerInventory;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.WorldUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.inventory.FabricPlayerAccessManager;
import org.carpetorgaddition.wheel.inventory.FabricPlayerAccessor;
import org.carpetorgaddition.wheel.inventory.OfflinePlayerEnderChestInventory;
import org.carpetorgaddition.wheel.inventory.OfflinePlayerInventory;
import org.carpetorgaddition.wheel.screen.OfflinePlayerInventoryScreenHandler;
import org.carpetorgaddition.wheel.screen.PlayerEnderChestScreenHandler;
import org.carpetorgaddition.wheel.screen.PlayerInventoryScreenHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerCommandExtension {
    public static RequiredArgumentBuilder<class_2168, ?> register(RequiredArgumentBuilder<class_2168, ?> builder) {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"inventory").requires(OpenPlayerInventory::isEnable)).executes(PlayerCommandExtension::openPlayerInventory))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"enderChest").requires(OpenPlayerInventory::isEnable)).executes(PlayerCommandExtension::openEnderChest))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"teleport").requires(CommandUtils.canUseCommand(CarpetOrgAdditionSettings.playerCommandTeleportFakePlayer))).executes(PlayerCommandExtension::fakePlayerTeleport));
    }

    private static int openPlayerInventory(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        String playerName = PlayerCommandExtension.getPlayerName(context);
        MinecraftServer server = source.method_9211();
        class_3222 argumentPlayer = PlayerCommandExtension.getPlayerNullable(playerName, server);
        class_3222 sourcePlayer = CommandUtils.getSourcePlayer(source);
        OpenPlayerInventory ruleValue = CarpetOrgAdditionSettings.playerCommandOpenPlayerInventoryOption.get();
        class_3222 class_32222 = argumentPlayer;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityPlayerMPFake.class, class_3222.class}, (Object)class_32222, n)) {
            case -1: {
                if (ruleValue.canOpenOfflinePlayer()) {
                    Optional<GameProfile> optional = OfflinePlayerInventory.getGameProfile(playerName, server);
                    if (optional.isEmpty()) {
                        throw PlayerCommandExtension.createNoFileFoundException();
                    }
                    GameProfile gameProfile = optional.get();
                    PlayerCommandExtension.openOfflinePlayerInventory(sourcePlayer, gameProfile);
                    break;
                }
                throw CommandUtils.createPlayerNotFoundException();
            }
            case 0: {
                EntityPlayerMPFake player = (EntityPlayerMPFake)class_32222;
                if (!ruleValue.canOpenFakePlayer()) break;
                PlayerCommandExtension.openOnlinePlayerInventory(sourcePlayer, (class_3222)player);
                break;
            }
            default: {
                class_3222 player = class_32222;
                if (ruleValue.canOpenRealPlayer()) {
                    PlayerCommandExtension.openOnlinePlayerInventory(sourcePlayer, player);
                    break;
                }
                throw CommandUtils.createNotFakePlayerException((class_1657)player);
            }
        }
        return 1;
    }

    public static void openOfflinePlayerInventory(class_3222 sourcePlayer, GameProfile gameProfile) throws CommandSyntaxException {
        MinecraftServer server = FetcherUtils.getServer(sourcePlayer);
        if (gameProfile == null) {
            throw PlayerCommandExtension.createNoFileFoundException();
        }
        OfflinePlayerInventory.checkPermission(server, gameProfile, sourcePlayer);
        class_747 factory = new class_747((syncId, playerInventory, player) -> {
            FabricPlayerAccessManager accessManager = ServerComponentCoordinator.getCoordinator(server).getAccessManager();
            FabricPlayerAccessor accessor = accessManager.getOrCreate(gameProfile);
            OfflinePlayerInventory inventory = new OfflinePlayerInventory(accessor);
            return new OfflinePlayerInventoryScreenHandler(syncId, playerInventory, inventory);
        }, PlayerCommandExtension.offlinePlayerName(gameProfile.getName()));
        sourcePlayer.method_17355((class_3908)factory);
    }

    public static CommandSyntaxException createNoFileFoundException() {
        return CommandUtils.createException("carpet.commands.player.inventory.offline.no_file_found", new Object[0]);
    }

    public static void openOnlinePlayerInventory(class_3222 sourcePlayer, class_3222 argumentPlayer) throws CommandSyntaxException {
        MinecraftServer server = FetcherUtils.getServer(sourcePlayer);
        OfflinePlayerInventory.checkPermission(server, argumentPlayer.method_7334(), sourcePlayer);
        class_747 screen = new class_747((syncId, inventory, player) -> new PlayerInventoryScreenHandler(syncId, inventory, argumentPlayer), argumentPlayer.method_5477());
        sourcePlayer.method_17355((class_3908)screen);
    }

    private static int openEnderChest(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        class_3222 sourcePlayer = CommandUtils.getSourcePlayer(context);
        String playerName = PlayerCommandExtension.getPlayerName(context);
        class_3222 argumentPlayer = PlayerCommandExtension.getPlayerNullable(playerName, server);
        OpenPlayerInventory ruleValue = CarpetOrgAdditionSettings.playerCommandOpenPlayerInventoryOption.get();
        class_3222 class_32222 = argumentPlayer;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityPlayerMPFake.class, class_3222.class}, (Object)class_32222, n)) {
            case -1: {
                if (ruleValue.canOpenOfflinePlayer()) {
                    Optional<GameProfile> optional = OfflinePlayerInventory.getGameProfile(playerName, server);
                    if (optional.isEmpty()) {
                        throw PlayerCommandExtension.createNoFileFoundException();
                    }
                    GameProfile gameProfile = optional.get();
                    PlayerCommandExtension.openOfflinePlayerEnderChest(sourcePlayer, gameProfile);
                    break;
                }
                throw CommandUtils.createPlayerNotFoundException();
            }
            case 0: {
                EntityPlayerMPFake player = (EntityPlayerMPFake)class_32222;
                if (!ruleValue.canOpenFakePlayer()) break;
                PlayerCommandExtension.openOnlinePlayerEnderChest(sourcePlayer, (class_3222)player);
                break;
            }
            default: {
                class_3222 player = class_32222;
                if (ruleValue.canOpenRealPlayer()) {
                    PlayerCommandExtension.openOnlinePlayerEnderChest(sourcePlayer, player);
                    break;
                }
                throw CommandUtils.createNotFakePlayerException((class_1657)player);
            }
        }
        return 1;
    }

    public static void openOfflinePlayerEnderChest(class_3222 sourcePlayer, GameProfile gameProfile) throws CommandSyntaxException {
        MinecraftServer server = FetcherUtils.getServer(sourcePlayer);
        OfflinePlayerInventory.checkPermission(server, gameProfile, sourcePlayer);
        class_747 factory = new class_747((syncId, playerInventory, player) -> {
            FabricPlayerAccessManager accessManager = ServerComponentCoordinator.getCoordinator(server).getAccessManager();
            FabricPlayerAccessor accessor = accessManager.getOrCreate(gameProfile);
            OfflinePlayerEnderChestInventory inventory = new OfflinePlayerEnderChestInventory(accessor);
            return class_1707.method_19245((int)syncId, (class_1661)playerInventory, (class_1263)inventory);
        }, PlayerCommandExtension.offlinePlayerName(gameProfile.getName()));
        sourcePlayer.method_17355((class_3908)factory);
    }

    public static void openOnlinePlayerEnderChest(class_3222 sourcePlayer, class_3222 argumentPlayer) throws CommandSyntaxException {
        MinecraftServer server = FetcherUtils.getServer(sourcePlayer);
        OfflinePlayerInventory.checkPermission(server, argumentPlayer.method_7334(), sourcePlayer);
        class_747 screen = new class_747((i, inventory, player) -> new PlayerEnderChestScreenHandler(i, inventory, argumentPlayer), argumentPlayer.method_5477());
        sourcePlayer.method_17355((class_3908)screen);
    }

    private static int fakePlayerTeleport(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_3222 fakePlayer = PlayerCommandExtension.getPlayer(context);
        CommandUtils.assertFakePlayer((class_1657)fakePlayer);
        FetcherUtils.getWorld(fakePlayer).method_43128(null, fakePlayer.method_23317(), fakePlayer.method_23318(), fakePlayer.method_23321(), class_3417.field_14915, fakePlayer.method_5634(), 1.0f, 1.0f);
        WorldUtils.teleport((class_1297)fakePlayer, (class_1297)player);
        class_2561 fakePlayerName = fakePlayer.method_5476();
        class_2561 playerName = player.method_5476();
        MessageUtils.sendMessage((class_2168)context.getSource(), "carpet.commands.player.tp.success", fakePlayerName, playerName);
        return 1;
    }

    private static class_2561 offlinePlayerName(String name) {
        return TextBuilder.translate("carpet.commands.player.inventory.offline.display_name", name);
    }

    @NotNull
    private static class_3222 getPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = PlayerCommandExtension.getPlayerNullable(PlayerCommandExtension.getPlayerName(context), ((class_2168)context.getSource()).method_9211());
        if (player == null) {
            throw CommandUtils.createPlayerNotFoundException();
        }
        return player;
    }

    @Nullable
    private static class_3222 getPlayerNullable(String name, MinecraftServer server) {
        return server.method_3760().method_14566(name);
    }

    private static String getPlayerName(CommandContext<class_2168> context) {
        return StringArgumentType.getString(context, (String)"player");
    }
}

