/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer.action;

import carpet.patches.EntityPlayerMPFake;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.class_2561;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.periodic.fakeplayer.action.AbstractPlayerAction;
import org.carpetorgaddition.periodic.fakeplayer.action.ActionSerializeType;
import org.carpetorgaddition.periodic.fakeplayer.action.FakePlayerActionManager;
import org.carpetorgaddition.periodic.fakeplayer.action.StopAction;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.wheel.TextJoiner;
import org.jetbrains.annotations.NotNull;

public class FakePlayerActionSerializer {
    private final AbstractPlayerAction action;
    public static final FakePlayerActionSerializer NO_ACTION = new FakePlayerActionSerializer();

    private FakePlayerActionSerializer() {
        this.action = new StopAction(null);
    }

    public FakePlayerActionSerializer(EntityPlayerMPFake fakePlayer) {
        FakePlayerActionManager actionManager = FetcherUtils.getFakePlayerActionManager(fakePlayer);
        this.action = actionManager.getAction();
    }

    public FakePlayerActionSerializer(JsonObject json) {
        for (ActionSerializeType value : ActionSerializeType.values()) {
            String serializedName = value.getSerializedName();
            if (!json.has(serializedName)) continue;
            JsonObject actionJson = json.getAsJsonObject(serializedName);
            AbstractPlayerAction deserialize = value.deserialize(actionJson);
            if (!deserialize.isValid()) break;
            this.action = deserialize;
            return;
        }
        this.action = new StopAction(null);
    }

    public void startAction(@NotNull EntityPlayerMPFake fakePlayer) {
        if (this == NO_ACTION || this.action.isStop()) {
            return;
        }
        if (this.action.equalFakePlayer(null)) {
            this.action.setFakePlayer(fakePlayer);
        } else if (!this.action.equalFakePlayer(fakePlayer)) {
            throw new IllegalArgumentException();
        }
        FakePlayerActionManager actionManager = FetcherUtils.getFakePlayerActionManager(fakePlayer);
        actionManager.setAction(this.action);
    }

    public void clearPlayer() {
        this.action.clearFakePlayer();
    }

    public boolean hasAction() {
        return !this.action.isStop();
    }

    public class_2561 toText() {
        TextJoiner joiner = new TextJoiner();
        joiner.append("carpet.commands.playerManager.info.action", new Object[0]);
        joiner.enter(this.action.getDisplayName());
        return joiner.join();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.action.isHidden() && !CarpetOrgAddition.ENABLE_HIDDEN_FUNCTION) {
            StopAction stopAction = new StopAction(null);
            json.add(stopAction.getActionSerializeType().getSerializedName(), (JsonElement)stopAction.toJson());
        } else {
            json.add(this.action.getActionSerializeType().getSerializedName(), (JsonElement)this.action.toJson());
        }
        return json;
    }
}

