/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.navigator;

import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.carpetorgaddition.network.s2c.WaypointUpdateS2CPacket;
import org.carpetorgaddition.periodic.navigator.AbstractNavigator;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.provider.TextProvider;
import org.jetbrains.annotations.NotNull;

public class BlockPosNavigator
extends AbstractNavigator {
    protected final class_2338 blockPos;
    protected final class_1937 world;

    public BlockPosNavigator(@NotNull class_3222 player, class_2338 blockPos, class_1937 world) {
        super(player);
        this.blockPos = blockPos;
        this.world = world;
    }

    @Override
    public void tick() {
        class_2561 text;
        if (FetcherUtils.getWorld(this.player).equals(this.world)) {
            class_2561 in = TextProvider.simpleBlockPos(this.blockPos);
            int distance = MathUtils.getBlockIntegerDistance(this.player.method_24515(), this.blockPos);
            text = this.getHUDText(this.blockPos.method_46558(), in, distance);
        } else {
            text = TextBuilder.combineAll(TextProvider.dimension(this.world), TextProvider.simpleBlockPos(this.blockPos));
        }
        MessageUtils.sendMessageToHud((class_1657)this.player, text);
    }

    @Override
    protected WaypointUpdateS2CPacket createPacket() {
        return new WaypointUpdateS2CPacket(this.blockPos, this.world);
    }

    @Override
    protected boolean updateRequired() {
        return false;
    }

    @Override
    public BlockPosNavigator copy(class_3222 player) {
        return new BlockPosNavigator(player, this.blockPos, this.world);
    }

    @Override
    protected boolean isArrive() {
        if (FetcherUtils.getWorld(this.player).equals(this.world) && MathUtils.getBlockIntegerDistance(this.player.method_24515(), this.blockPos) <= 8) {
            MessageUtils.sendMessageToHud((class_1657)this.player, TextBuilder.translate("carpet.commands.navigate.hud.reach", new Object[0]));
            this.clear();
            return true;
        }
        return false;
    }
}

