/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util;

import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.util.FetcherUtils;
import org.jetbrains.annotations.Nullable;

public class WorldUtils {
    public static final String OVERWORLD = "minecraft:overworld";
    public static final String THE_NETHER = "minecraft:the_nether";
    public static final String THE_END = "minecraft:the_end";
    public static final String SIMPLE_OVERWORLD = "overworld";
    public static final String SIMPLE_THE_NETHER = "the_nether";
    public static final String SIMPLE_THE_END = "the_end";

    private WorldUtils() {
    }

    @Deprecated(forRemoval=true)
    public static ArrayList<class_2338> allBlockPos(class_238 box) {
        int endX = (int)box.field_1320;
        int endY = (int)box.field_1325;
        int endZ = (int)box.field_1324;
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        for (int startX = (int)box.field_1323; startX < endX; ++startX) {
            for (int startY = (int)box.field_1322; startY < endY; ++startY) {
                for (int startZ = (int)box.field_1321; startZ < endZ; ++startZ) {
                    list.add(new class_2338(startX, startY, startZ));
                }
            }
        }
        return list;
    }

    public static class_124 getColor(class_1937 world) {
        return switch (WorldUtils.getDimensionId(world)) {
            case THE_NETHER -> class_124.field_1061;
            case THE_END -> class_124.field_1064;
            default -> class_124.field_1060;
        };
    }

    public static String toPosString(class_2338 blockPos) {
        return blockPos.method_10263() + " " + blockPos.method_10264() + " " + blockPos.method_10260();
    }

    public static String toWorldPosString(class_1937 world, class_2338 blockPos) {
        return WorldUtils.getDimensionId(world) + "[" + WorldUtils.toPosString(blockPos) + "]";
    }

    public static String getDimensionId(class_1937 world) {
        return world.method_27983().method_29177().toString();
    }

    public static class_3218 getWorld(MinecraftServer server, String dimension) {
        class_2960 identifier;
        String[] split = dimension.split(":");
        if (split.length == 1) {
            identifier = class_2960.method_60655((String)"minecraft", (String)dimension);
        } else if (split.length == 2) {
            identifier = class_2960.method_60655((String)split[0], (String)split[1]);
        } else {
            throw new IllegalArgumentException();
        }
        return server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)identifier));
    }

    public static class_5321<class_1937> getWorld(String worldId) {
        if (worldId.contains(":")) {
            String[] split = worldId.split(":");
            if (split.length != 2) {
                throw new IllegalArgumentException();
            }
            return class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60655((String)split[0], (String)split[1]));
        }
        return class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)worldId));
    }

    @Nullable
    public static class_1297 getEntityFromUUID(MinecraftServer server, UUID uuid) {
        for (class_3218 world : server.method_3738()) {
            class_1297 entity = world.method_66347(uuid);
            if (entity == null) continue;
            return entity;
        }
        return null;
    }

    public static void playSound(class_1937 world, class_2338 blockPos, class_3414 soundEvent, class_3419 soundCategory) {
        world.method_8396(null, blockPos, soundEvent, soundCategory, 1.0f, 1.0f);
    }

    public static void playSound(class_3222 player, class_3414 soundEvent, class_3419 soundCategory) {
        class_3218 world = FetcherUtils.getWorld(player);
        world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), soundEvent, soundCategory, 1.0f, 1.0f);
    }

    public static boolean canMappingPos(class_1937 world1, class_1937 world2) {
        return WorldUtils.isOverworld(world1) && WorldUtils.isTheNether(world2) || WorldUtils.isOverworld(world2) && WorldUtils.isTheNether(world1);
    }

    public static int getMaxArchitectureAltitude(class_1937 world) {
        return world.method_31600();
    }

    public static int getMinArchitectureAltitude(class_1937 world) {
        return world.method_31607();
    }

    public static boolean isOverworld(class_1937 world) {
        return world.method_27983() == class_1937.field_25179;
    }

    public static boolean isTheNether(class_1937 world) {
        return world.method_27983() == class_1937.field_25180;
    }

    public static boolean isTheEnd(class_1937 world) {
        return world.method_27983() == class_1937.field_25181;
    }

    public static void teleport(class_1297 source, class_3218 world, double x, double y, double z, float yaw, float pitch) {
        source.method_48105(world, x, y, z, Set.of(), yaw, pitch, true);
    }

    public static void teleport(class_1297 source, class_1297 target) {
        class_1937 class_19372 = target.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            WorldUtils.teleport(source, world, target.method_23317(), target.method_23318(), target.method_23321(), target.method_36454(), target.method_36455());
        }
    }

    public static boolean isOverworld(class_5321<class_1937> key) {
        return class_1937.field_25179.equals(key);
    }

    public static boolean isTheNether(class_5321<class_1937> key) {
        return class_1937.field_25180.equals(key);
    }
}

