/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import net.minecraft.class_2561;
import org.carpetorgaddition.wheel.TextBuilder;

public class TextJoiner {
    private final ArrayList<class_2561> list = new ArrayList();
    private int depth = 0;
    private String bullet = "- ";
    private String indent = "  ";

    public TextJoiner newline() {
        return this.append(TextBuilder.empty());
    }

    public TextJoiner append(class_2561 text) {
        if (this.depth == 0) {
            this.list.add(text);
        } else {
            this.list.add(TextBuilder.combineAll(this.indent(), text));
        }
        return this;
    }

    public TextJoiner append(String key, Object ... args) {
        class_2561 translate = TextBuilder.translate(key, args);
        return this.append(translate);
    }

    public TextJoiner literal() {
        return this.literal(" ");
    }

    public TextJoiner literal(String str) {
        return this.then(TextBuilder.create(str));
    }

    public TextJoiner then(class_2561 text) {
        if (this.list.isEmpty()) {
            this.append(text);
        } else {
            class_2561 last = this.list.removeLast();
            class_2561 combined = TextBuilder.combineAll(last, text);
            this.list.addLast(combined);
        }
        return this;
    }

    public TextJoiner enter(class_2561 text) {
        return this.enter(() -> this.append(text));
    }

    public TextJoiner enter(String key, Object ... args) {
        return this.enter(TextBuilder.translate(key, args));
    }

    public TextJoiner enter(Runnable runnable) {
        ++this.depth;
        runnable.run();
        --this.depth;
        return this;
    }

    private String indent() {
        if (this.depth == 0) {
            return "";
        }
        StringJoiner joiner = new StringJoiner("", "", this.bullet);
        for (int i = 0; i < this.depth; ++i) {
            joiner.add(this.indent);
        }
        return joiner.toString();
    }

    public void setBullet(char bullet) {
        this.bullet = bullet + " ";
    }

    public void unsetBullet() {
        this.bullet = "";
    }

    public void setIndent(int indent) {
        if (indent < 0) {
            throw new IllegalArgumentException("Invalid indentation value: " + indent);
        }
        this.indent = switch (indent) {
            case 0 -> "";
            case 1 -> " ";
            case 2 -> "  ";
            case 3 -> "   ";
            case 4 -> "    ";
            default -> " ".repeat(indent);
        };
    }

    public class_2561 join() {
        return TextBuilder.joinList(this.list);
    }

    public List<class_2561> collect() {
        return Collections.unmodifiableList(this.list);
    }
}

