/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel.predicate;

import carpet.CarpetServer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2168;
import net.minecraft.class_2293;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7157;
import net.minecraft.class_7923;
import org.carpetorgaddition.util.GenericUtils;
import org.carpetorgaddition.wheel.CommandRegistryAccessor;
import org.carpetorgaddition.wheel.TextBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemStackPredicate
implements Predicate<class_1799> {
    private final Predicate<class_1799> predicate;
    private final String input;
    private final boolean isWildcard;
    @Nullable
    private final class_1792 convert;
    public static final ItemStackPredicate EMPTY = new ItemStackPredicate(class_1802.field_8162);
    public static final ItemStackPredicate WILDCARD = new ItemStackPredicate();

    private ItemStackPredicate() {
        this.predicate = itemStack -> !itemStack.method_7960();
        this.input = "*";
        this.isWildcard = true;
        this.convert = null;
    }

    public ItemStackPredicate(CommandContext<class_2168> context, String arguments) {
        for (ParsedCommandNode commandNode : context.getNodes()) {
            ArgumentCommandNode node;
            CommandNode commandNode2 = commandNode.getNode();
            if (!(commandNode2 instanceof ArgumentCommandNode) || !Objects.equals((node = (ArgumentCommandNode)commandNode2).getName(), arguments)) continue;
            StringRange range = commandNode.getRange();
            this.input = context.getInput().substring(range.getStart(), range.getEnd());
            class_2293.class_2295 predicate = class_2293.method_9804(context, (String)arguments);
            this.isWildcard = this.isWildcard();
            this.predicate = this.isWildcard ? itemStack -> !itemStack.method_7960() && predicate.test(itemStack) : predicate;
            this.convert = ItemStackPredicate.tryConvert(this.input);
            return;
        }
        throw new IllegalArgumentException();
    }

    public ItemStackPredicate(@NotNull class_1792 item) {
        this.predicate = itemStack -> itemStack.method_31574(item);
        this.input = GenericUtils.getIdAsString(item);
        this.isWildcard = false;
        this.convert = item;
    }

    public static ItemStackPredicate of(Collection<class_1792> collection) {
        LinkedHashSet<class_1792> set = new LinkedHashSet<class_1792>(collection);
        return switch (set.size()) {
            case 0 -> EMPTY;
            case 1 -> new ItemStackPredicate(set.getFirst());
            default -> new MatchAnyItemPredicate(set);
        };
    }

    private ItemStackPredicate(LinkedHashSet<class_1792> set) {
        this.predicate = itemStack -> set.contains(itemStack.method_7909());
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (class_1792 item : set) {
            joiner.add(GenericUtils.getIdAsString(item));
        }
        this.input = joiner.toString();
        this.isWildcard = false;
        this.convert = null;
    }

    private ItemStackPredicate(Predicate<class_1799> predicate, String input) {
        this.input = input;
        this.isWildcard = this.isWildcard();
        this.predicate = this.isWildcard ? itemStack -> !itemStack.method_7960() && predicate.test((class_1799)itemStack) : predicate;
        this.convert = ItemStackPredicate.tryConvert(input);
    }

    @Nullable
    private static class_1792 tryConvert(String input) {
        if (input.startsWith("#") || input.startsWith("*") || input.matches(".*\\[.*]")) {
            return null;
        }
        try {
            return (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)input));
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public boolean isEmpty() {
        return this.test(class_1799.field_8037);
    }

    @Override
    public boolean test(class_1799 itemStack) {
        return this.predicate.test(itemStack);
    }

    public static ItemStackPredicate parse(String input) {
        CommandRegistryAccessor accessor = (CommandRegistryAccessor)CarpetServer.minecraft_server.method_3734();
        class_7157 access = accessor.carpet_Org_Addition$getAccess();
        try {
            StringReader reader = new StringReader(input);
            class_2293.class_2295 predicate = (class_2293.class_2295)class_2293.method_9801((class_7157)access).parse(reader);
            return new ItemStackPredicate((Predicate<class_1799>)predicate, input);
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isWildcard() {
        return "*".equals(this.input) || "*[]".equals(this.input);
    }

    public class_2561 getInitialUpperCase() {
        if (this.isEmpty()) {
            TextBuilder builder = new TextBuilder("[A]");
            builder.setColor(class_124.field_1063);
            builder.setHover(class_1802.field_8162.method_63680());
            return builder.build();
        }
        TextBuilder builder = null;
        if (this.input.startsWith("#")) {
            builder = new TextBuilder("[#]");
        } else if (this.input.startsWith("*")) {
            builder = new TextBuilder("[*]");
        } else if (this.input.contains("[")) {
            builder = new TextBuilder("[@]");
        }
        if (builder != null) {
            return builder.setHover(this.input, new Object[0]).build();
        }
        String[] split = this.input.split(":");
        int index = split.length == 1 ? 0 : 1;
        builder = new TextBuilder("[" + Character.toUpperCase(split[index].charAt(0)) + "]");
        class_2561 name = ((class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)this.input))).method_63680();
        return builder.setHover(name).build();
    }

    public class_2561 toText() throws class_151 {
        if (this.isEmpty()) {
            return class_1802.field_8162.method_63680();
        }
        if (this.isWildcard) {
            return TextBuilder.translate("carpet.command.item.predicate.wildcard", new Object[0]);
        }
        if (this.convert != null) {
            return this.convert.method_63680();
        }
        if (this.input.length() > 30) {
            String substring = this.input.substring(0, 30);
            class_2561 ellipsis = TextBuilder.create("...");
            class_2561 result = TextBuilder.combineAll(substring, ellipsis);
            TextBuilder builder = new TextBuilder(result).setGrayItalic().setHover(this.input, new Object[0]);
            return builder.build();
        }
        return TextBuilder.create(this.input);
    }

    @Deprecated(forRemoval=true)
    public class_1792 asItem() {
        if (this.isEmpty()) {
            return class_1802.field_8162;
        }
        if (this.isConvertible()) {
            return (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)this.input));
        }
        throw new UnsupportedOperationException(this.input + " cannot be converted to item");
    }

    public Optional<class_1792> getConvert() {
        return Optional.ofNullable(this.convert);
    }

    @Deprecated(forRemoval=true)
    public boolean isConvertible() {
        return !this.input.startsWith("#") && !this.input.startsWith("*") && !this.input.matches(".*\\[.*]");
    }

    public String getInput() {
        return this.input;
    }

    public String toString() {
        return this.input;
    }

    public static class MatchAnyItemPredicate
    extends ItemStackPredicate {
        private final LinkedHashSet<class_1792> items;

        private MatchAnyItemPredicate(LinkedHashSet<class_1792> items) {
            super(items);
            this.items = items;
        }

        @Override
        public class_2561 toText() throws class_151 {
            if (this.getInput().length() > 30) {
                String substring = this.getInput().substring(0, 30);
                class_2561 ellipsis = TextBuilder.create("...");
                class_2561 result = TextBuilder.combineAll(substring, ellipsis);
                StringJoiner joiner = new StringJoiner(",\n");
                for (class_1792 item : this.items) {
                    joiner.add(GenericUtils.getIdAsString(item));
                }
                return new TextBuilder(result).setGrayItalic().setStringHover(joiner.toString()).build();
            }
            return super.toText();
        }
    }
}

