/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel.traverser;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import org.carpetorgaddition.wheel.traverser.ChunkTraverser;
import org.carpetorgaddition.wheel.traverser.WorldTraverser;
import org.jetbrains.annotations.NotNull;

public class BlockEntityTraverser
extends WorldTraverser<class_2586> {
    private final class_1937 world;

    public BlockEntityTraverser(class_1937 world, class_2338 sourcePos, int range) {
        super(world, sourcePos, range);
        this.world = world;
    }

    public BlockEntityTraverser(class_1937 world, class_2338 from, class_2338 to) {
        super(from, to);
        this.world = world;
    }

    @Override
    @NotNull
    public Iterator<class_2586> iterator() {
        return new Itr();
    }

    private class Itr
    implements Iterator<class_2586> {
        private class_2586 next;
        private Iterator<class_2586> current;
        private boolean alreadyNext = false;
        private final Iterator<Optional<class_2791>> chunkIterator;

        private Itr() {
            ChunkTraverser traverser = new ChunkTraverser(BlockEntityTraverser.this.world, BlockEntityTraverser.this.from, BlockEntityTraverser.this.to);
            this.chunkIterator = traverser.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.alreadyNext) {
                return this.next != null;
            }
            this.alreadyNext = true;
            while (this.current != null || this.chunkIterator.hasNext()) {
                if (this.current == null) {
                    Optional<class_2818> optional = this.chunkIterator.next().filter(chunk -> chunk instanceof class_2818).map(chunk -> (class_2818)chunk);
                    if (optional.isEmpty()) continue;
                    this.current = optional.get().method_12214().values().iterator();
                }
                while (this.current.hasNext()) {
                    class_2586 blockEntity = this.current.next();
                    if (!BlockEntityTraverser.this.contains(blockEntity.method_11016())) continue;
                    this.next = blockEntity;
                    return true;
                }
                this.current = null;
            }
            return false;
        }

        @Override
        public class_2586 next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.alreadyNext = false;
            class_2586 blockEntity = this.next;
            this.next = null;
            return blockEntity;
        }
    }
}

