/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel.traverser;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.WorldUtils;

public abstract class WorldTraverser<T>
implements Iterable<T> {
    protected final int minX;
    protected final int minY;
    protected final int minZ;
    protected final int maxX;
    protected final int maxY;
    protected final int maxZ;
    protected final class_2338 from;
    protected final class_2338 to;

    public WorldTraverser(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = Math.max(minX, -30000000);
        this.minY = Math.max(minY, -20000000);
        this.minZ = Math.max(minZ, -30000000);
        this.maxX = Math.min(maxX, 30000000);
        this.maxY = Math.min(maxY, 20000000);
        this.maxZ = Math.min(maxZ, 30000000);
        this.from = new class_2338(this.minX, this.minY, this.minZ);
        this.to = new class_2338(this.maxX, this.maxY, this.maxZ);
    }

    public WorldTraverser(class_1937 world, class_2338 sourcePos, int range) {
        this(sourcePos.method_10263() - range, WorldUtils.getMinArchitectureAltitude(world), sourcePos.method_10260() - range, sourcePos.method_10263() + range, WorldUtils.getMaxArchitectureAltitude(world), sourcePos.method_10260() + range);
    }

    public WorldTraverser(class_2338 from, class_2338 to) {
        this(Math.min(from.method_10263(), to.method_10263()), Math.min(from.method_10264(), to.method_10264()), Math.min(from.method_10260(), to.method_10260()), Math.max(from.method_10263(), to.method_10263()), Math.max(from.method_10264(), to.method_10264()), Math.max(from.method_10260(), to.method_10260()));
    }

    public WorldTraverser(class_238 box) {
        this((int)box.field_1323, (int)box.field_1322, (int)box.field_1321, (int)box.field_1320, (int)box.field_1325, (int)box.field_1324);
    }

    public int size() {
        return this.length() * this.width() * this.height();
    }

    public int length() {
        return Math.max(this.maxX - this.minX + 1, 0);
    }

    public int height() {
        return Math.max(this.maxY - this.minY + 1, 0);
    }

    public int width() {
        return Math.max(this.maxZ - this.minZ + 1, 0);
    }

    public class_238 toBox() {
        return new class_238((double)this.minX, (double)this.minY, (double)this.minZ, (double)(this.maxX + 1), (double)(this.maxY + 1), (double)(this.maxZ + 1));
    }

    public boolean contains(class_2338 blockPos) {
        int x = blockPos.method_10263();
        int y = blockPos.method_10264();
        int z = blockPos.method_10260();
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY && z >= this.minZ && z <= this.maxZ;
    }

    public class_2338 randomBlockPos() {
        int x = MathUtils.randomInt(this.minX, this.maxX);
        int y = MathUtils.randomInt(this.minY, this.maxY);
        int z = MathUtils.randomInt(this.minZ, this.maxZ);
        return new class_2338(x, y, z);
    }

    public class_2338 getMaxBlockPos() {
        return this.to;
    }

    public class_2338 getMinBlockPos() {
        return this.from;
    }
}

