/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import carpet.patches.EntityPlayerMPFake;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.minecraft.class_5217;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.command.AbstractServerCommand;
import org.carpetorgaddition.command.LocationsCommand;
import org.carpetorgaddition.periodic.PlayerComponentCoordinator;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.WorldUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.Waypoint;
import org.carpetorgaddition.wheel.permission.PermissionLevel;
import org.carpetorgaddition.wheel.permission.PermissionManager;
import org.carpetorgaddition.wheel.provider.TextProvider;

public class NavigatorCommand
extends AbstractServerCommand {
    private static final String START_NAVIGATION = "carpet.commands.navigate.start_navigation";

    public NavigatorCommand(CommandDispatcher<class_2168> dispatcher, class_7157 access) {
        super(dispatcher, access);
    }

    @Override
    public void register(String name) {
        this.dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(CommandUtils.canUseCommand(CarpetOrgAdditionSettings.commandNavigate))).then(class_2170.method_9247((String)"entity").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(context -> this.navigateToEntity((CommandContext<class_2168>)context, false, "entity"))).then(class_2170.method_9247((String)"continue").executes(context -> this.navigateToEntity((CommandContext<class_2168>)context, true, "entity")))))).then(class_2170.method_9247((String)"player").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> this.navigateToEntity((CommandContext<class_2168>)context, false, "player"))).then(class_2170.method_9247((String)"continue").executes(context -> this.navigateToEntity((CommandContext<class_2168>)context, true, "player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"waypoint").requires(CommandUtils.canUseCommand(CarpetOrgAdditionSettings.commandLocations))).then(class_2170.method_9244((String)"waypoint", (ArgumentType)StringArgumentType.string()).suggests(LocationsCommand.suggestion()).executes(this::navigateToWaypoint)))).then(class_2170.method_9247((String)"stop").executes(this::stopNavigate))).then(class_2170.method_9247((String)"uuid").then(class_2170.method_9244((String)"uuid", (ArgumentType)StringArgumentType.string()).executes(this::navigateToEntityForUUID)))).then(class_2170.method_9247((String)"blockPos").then(class_2170.method_9244((String)"blockPos", (ArgumentType)class_2262.method_9698()).executes(this::navigateToBlock)))).then(class_2170.method_9247((String)"spawnpoint").executes(this::navigateToSpawnPoint))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"death").requires((Predicate)PermissionManager.register("navigate.death", PermissionLevel.PASS))).executes(context -> this.navigateToLastDeathLocation((CommandContext<class_2168>)context, true))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> this.navigateToLastDeathLocation((CommandContext<class_2168>)context, false)))));
    }

    private int navigateToEntity(CommandContext<class_2168> context, boolean isContinue, String arguments) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_1297 entity = class_2186.method_9313(context, (String)arguments);
        TextBuilder builder = TextBuilder.of(START_NAVIGATION, player.method_5476(), entity.method_5476());
        PlayerComponentCoordinator.getManager(player).getNavigatorManager().setNavigator(entity, isContinue);
        if (this.shouldBeBroadcast(entity, player)) {
            builder.setGrayItalic();
            MessageUtils.broadcastMessage(((class_2168)context.getSource()).method_9211(), builder.build());
        } else {
            MessageUtils.sendMessage((class_2168)context.getSource(), builder.build());
        }
        return 1;
    }

    private int navigateToWaypoint(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        String waypointArgument = StringArgumentType.getString(context, (String)"waypoint");
        try {
            Waypoint waypoint = Waypoint.load(server, waypointArgument);
            PlayerComponentCoordinator.getManager(player).getNavigatorManager().setNavigator(waypoint);
            MessageUtils.sendMessage(context, START_NAVIGATION, player.method_5476(), "[" + waypointArgument + "]");
        }
        catch (IOException | NullPointerException e) {
            throw CommandUtils.createException("carpet.commands.locations.list.parse", waypointArgument);
        }
        return 1;
    }

    private int navigateToEntityForUUID(CommandContext<class_2168> context) throws CommandSyntaxException {
        UUID uuid;
        class_3222 player = CommandUtils.getSourcePlayer(context);
        try {
            uuid = UUID.fromString(StringArgumentType.getString(context, (String)"uuid"));
        }
        catch (IllegalArgumentException e) {
            throw CommandUtils.createException("carpet.commands.navigate.parse_uuid_fail", new Object[0]);
        }
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        for (class_3218 world : server.method_3738()) {
            class_1297 entity = world.method_66347(uuid);
            if (entity == null) continue;
            PlayerComponentCoordinator.getManager(player).getNavigatorManager().setNavigator(entity, false);
            TextBuilder builder = TextBuilder.of(START_NAVIGATION, player.method_5476(), entity.method_5476());
            if (this.shouldBeBroadcast(entity, player)) {
                builder.setGrayItalic();
                MessageUtils.broadcastMessage(((class_2168)context.getSource()).method_9211(), builder.build());
            } else {
                MessageUtils.sendMessage((class_2168)context.getSource(), builder.build());
            }
            return 1;
        }
        throw class_2186.field_9863.create();
    }

    private boolean shouldBeBroadcast(class_1297 entity, class_3222 player) {
        if (entity == player || entity instanceof EntityPlayerMPFake) {
            return false;
        }
        return entity instanceof class_3222;
    }

    private int stopNavigate(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        PlayerComponentCoordinator.getManager(player).getNavigatorManager().clearNavigator();
        MessageUtils.sendMessageToHud((class_1657)player, TextBuilder.translate("carpet.commands.navigate.hud.stop", new Object[0]));
        return 1;
    }

    private int navigateToBlock(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_2338 blockPos = class_2262.method_48299(context, (String)"blockPos");
        class_3218 world = FetcherUtils.getWorld(player);
        PlayerComponentCoordinator.getManager(player).getNavigatorManager().setNavigator(blockPos, (class_1937)world);
        MessageUtils.sendMessage(context, START_NAVIGATION, player.method_5476(), TextProvider.blockPos(blockPos, WorldUtils.getColor((class_1937)world)));
        return 1;
    }

    private int navigateToSpawnPoint(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_2561 spawnPoint = TextBuilder.translate("carpet.commands.navigate.name.spawnpoint", new Object[0]);
        try {
            class_5217.class_12064 respawnData = Objects.requireNonNull(player.method_67564()).comp_4913();
            class_2338 respawnPos = respawnData.method_74897();
            class_3218 world = FetcherUtils.getServer(player).method_3847(respawnData.method_74894());
            PlayerComponentCoordinator.getManager(player).getNavigatorManager().setNavigator(respawnPos, (class_1937)world, spawnPoint);
        }
        catch (NullPointerException e) {
            throw CommandUtils.createException("carpet.commands.navigate.unable_to_find", player.method_5476(), spawnPoint);
        }
        MessageUtils.sendMessage(context, START_NAVIGATION, player.method_5476(), spawnPoint);
        return 1;
    }

    private int navigateToLastDeathLocation(CommandContext<class_2168> context, boolean self) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_3222 target = self ? player : CommandUtils.getArgumentPlayer(context);
        Optional lastDeathPos = target.method_43122();
        class_2561 death = TextBuilder.translate("carpet.commands.navigate.name.last_death_location", new Object[0]);
        if (lastDeathPos.isEmpty()) {
            throw CommandUtils.createException("carpet.commands.navigate.unable_to_find", target.method_5476(), death);
        }
        class_2561 name = self ? death : TextBuilder.translate("carpet.commands.navigate.hud.of", target.method_5476(), death);
        class_4208 globalPos = (class_4208)lastDeathPos.get();
        PlayerComponentCoordinator.getManager(player).getNavigatorManager().setNavigator(globalPos.comp_2208(), (class_1937)((class_2168)context.getSource()).method_9211().method_3847(globalPos.comp_2207()), name);
        TextBuilder builder = TextBuilder.of(START_NAVIGATION, player.method_5476(), name);
        if (self || player == target) {
            MessageUtils.sendMessage(player, builder.build());
        } else {
            builder.setGrayItalic();
            MessageUtils.broadcastMessage(((class_2168)context.getSource()).method_9211(), builder.build());
        }
        return 1;
    }

    @Override
    public String getDefaultName() {
        return "navigate";
    }
}

