/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import carpet.fakes.ServerPlayerInterface;
import carpet.helpers.EntityPlayerActionPack;
import carpet.patches.EntityPlayerMPFake;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_11561;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2245;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.command.AbstractServerCommand;
import org.carpetorgaddition.exception.CommandExecuteIOException;
import org.carpetorgaddition.periodic.ServerComponentCoordinator;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerSafeAfkInterface;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerSerializer;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerStartupAction;
import org.carpetorgaddition.periodic.fakeplayer.PlayerSerializationManager;
import org.carpetorgaddition.periodic.task.ServerTaskManager;
import org.carpetorgaddition.periodic.task.SilentLogoutTask;
import org.carpetorgaddition.periodic.task.batch.BatchKillFakePlayer;
import org.carpetorgaddition.periodic.task.batch.BatchSpawnFakePlayerTask;
import org.carpetorgaddition.periodic.task.schedule.DelayedLoginTask;
import org.carpetorgaddition.periodic.task.schedule.DelayedLogoutTask;
import org.carpetorgaddition.periodic.task.schedule.PlayerScheduleTask;
import org.carpetorgaddition.periodic.task.schedule.ReLoginTask;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.GenericUtils;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.FakePlayerCreateContext;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.WorldFormat;
import org.carpetorgaddition.wheel.page.PageManager;
import org.carpetorgaddition.wheel.page.PagedCollection;
import org.carpetorgaddition.wheel.permission.PermissionLevel;
import org.carpetorgaddition.wheel.permission.PermissionManager;
import org.carpetorgaddition.wheel.provider.CommandProvider;
import org.carpetorgaddition.wheel.provider.TextProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerManagerCommand
extends AbstractServerCommand {
    private static final String SAFEAFK_PROPERTIES = "safeafk.properties";

    public PlayerManagerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 access) {
        super(dispatcher, access);
    }

    @Override
    public void register(String name) {
        RequiredArgumentBuilder loginNode = class_2170.method_9244((String)"delayed", (ArgumentType)IntegerArgumentType.integer((int)1));
        for (TimeUnit unit : TimeUnit.values()) {
            loginNode.then(class_2170.method_9247((String)unit.getName()).executes(context -> this.addDelayedLoginTask((CommandContext<class_2168>)context, unit)));
        }
        RequiredArgumentBuilder logoutNode = class_2170.method_9244((String)"delayed", (ArgumentType)IntegerArgumentType.integer((int)1));
        for (TimeUnit unit : TimeUnit.values()) {
            logoutNode.then(class_2170.method_9247((String)unit.getName()).executes(context -> this.addDelayedLogoutTask((CommandContext<class_2168>)context, unit)));
        }
        RequiredArgumentBuilder startupNameNode = class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this.defaultSuggests());
        for (FakePlayerStartupAction action : FakePlayerStartupAction.values()) {
            startupNameNode.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)action.toString()).executes(context -> this.addStartupFunction((CommandContext<class_2168>)context, action, 1))).then(class_2170.method_9244((String)"delay", (ArgumentType)class_2245.method_48287((int)1)).suggests((context, builder) -> class_2172.method_9253((String[])new String[]{"1t", "3t", "5t"}, (SuggestionsBuilder)builder)).executes(context -> this.addStartupFunction((CommandContext<class_2168>)context, action, IntegerArgumentType.getInteger((CommandContext)context, (String)"delay"))))).then(class_2170.method_9247((String)"clear").executes(context -> this.addStartupFunction((CommandContext<class_2168>)context, action, -1))));
        }
        LiteralArgumentBuilder startupNode = class_2170.method_9247((String)"startup");
        startupNode.then((ArgumentBuilder)startupNameNode);
        this.dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(CommandUtils.canUseCommand(CarpetOrgAdditionSettings.commandPlayerManager))).then(class_2170.method_9247((String)"save").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> this.savePlayerData((CommandContext<class_2168>)context, false))).then(class_2170.method_9244((String)"comment", (ArgumentType)StringArgumentType.string()).executes(context -> this.savePlayerData((CommandContext<class_2168>)context, true)))))).then(class_2170.method_9247((String)"spawn").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this.defaultSuggests()).executes(this::spawnPlayer)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"modify").then(class_2170.method_9247((String)"comment").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this.defaultSuggests()).executes(context -> this.setComment((CommandContext<class_2168>)context, true))).then(class_2170.method_9244((String)"comment", (ArgumentType)StringArgumentType.string()).executes(context -> this.setComment((CommandContext<class_2168>)context, false)))))).then(class_2170.method_9247((String)"resave").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(this::modifyPlayer)))).then((ArgumentBuilder)startupNode))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"group").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this.defaultSuggests()).then(class_2170.method_9244((String)"group", (ArgumentType)StringArgumentType.string()).suggests(this.groupSuggests()).executes(this::addToGroup))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this.defaultSuggests()).then(class_2170.method_9244((String)"group", (ArgumentType)StringArgumentType.string()).suggests(this.groupSuggests()).executes(this::removeFromGroup))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").then(class_2170.method_9247((String)"group").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"group", (ArgumentType)StringArgumentType.string()).suggests(this.groupSuggests()).executes(context -> this.listGroup((CommandContext<class_2168>)context, serializer -> true))).then(class_2170.method_9244((String)"filter", (ArgumentType)StringArgumentType.string()).executes(context -> this.listGroup((CommandContext<class_2168>)context, this.serializerPredicate((CommandContext<class_2168>)context))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"ungrouped").executes(context -> this.listUngrouped((CommandContext<class_2168>)context, serializer -> true))).then(class_2170.method_9244((String)"filter", (ArgumentType)StringArgumentType.string()).executes(context -> this.listUngrouped((CommandContext<class_2168>)context, this.serializerPredicate((CommandContext<class_2168>)context)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"all").executes(context -> this.listAll((CommandContext<class_2168>)context, serializer -> true))).then(class_2170.method_9244((String)"filter", (ArgumentType)StringArgumentType.string()).executes(context -> this.listAll((CommandContext<class_2168>)context, this.serializerPredicate((CommandContext<class_2168>)context)))))))).then(class_2170.method_9247((String)"reload").executes(this::reload))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"autologin").requires((Predicate)PermissionManager.register("playerManager.autologin", PermissionLevel.PASS))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this.defaultSuggests()).then(class_2170.method_9244((String)"autologin", (ArgumentType)BoolArgumentType.bool()).executes(this::setAutoLogin))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(context -> this.list((CommandContext<class_2168>)context, null))).then(class_2170.method_9244((String)"filter", (ArgumentType)StringArgumentType.string()).executes(context -> this.list((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"filter")))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this.defaultSuggests()).executes(this::remove)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"schedule").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"relogin").requires((Predicate)PermissionManager.register("playerManager.schedule.relogin", PermissionLevel.PASS))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this.reLoginTaskSuggests()).then(class_2170.method_9244((String)"interval", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((context, builder) -> class_2172.method_9253((String[])new String[]{"1", "3", "5"}, (SuggestionsBuilder)builder)).executes(this::setReLogin))).then(class_2170.method_9247((String)"stop").executes(this::stopReLogin))))).then(class_2170.method_9247((String)"login").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this.defaultSuggests()).then((ArgumentBuilder)loginNode)))).then(class_2170.method_9247((String)"logout").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then((ArgumentBuilder)logoutNode)))).then(class_2170.method_9247((String)"cancel").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(this.cancelSuggests()).executes(this::cancelScheduleTask)))).then(class_2170.method_9247((String)"list").executes(this::listScheduleTask)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"safeafk").then(class_2170.method_9247((String)"set").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> this.safeAfk((CommandContext<class_2168>)context, 5.0f, false))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"threshold", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> this.safeAfk((CommandContext<class_2168>)context, FloatArgumentType.getFloat((CommandContext)context, (String)"threshold"), false))).then(class_2170.method_9244((String)"save", (ArgumentType)BoolArgumentType.bool()).executes(context -> this.safeAfk((CommandContext<class_2168>)context, FloatArgumentType.getFloat((CommandContext)context, (String)"threshold"), BoolArgumentType.getBool((CommandContext)context, (String)"save")))))))).then(class_2170.method_9247((String)"list").executes(this::listSafeAfk))).then(class_2170.method_9247((String)"cancel").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> this.cancelSafeAfk((CommandContext<class_2168>)context, false))).then(class_2170.method_9244((String)"save", (ArgumentType)BoolArgumentType.bool()).executes(context -> this.cancelSafeAfk((CommandContext<class_2168>)context, true)))))).then(class_2170.method_9247((String)"query").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(this::querySafeAfk))))).then(class_2170.method_9247((String)"batch").then(class_2170.method_9244((String)"prefix", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"start", (ArgumentType)IntegerArgumentType.integer((int)1)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"end", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"spawn").executes(context -> this.batchSpawn((CommandContext<class_2168>)context, false))).then(class_2170.method_9244((String)"at", (ArgumentType)class_2277.method_9737()).executes(context -> this.batchSpawn((CommandContext<class_2168>)context, true))))).then(class_2170.method_9247((String)"kill").executes(this::batchKill))).then(class_2170.method_9247((String)"drop").executes(this::batchDrop))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"trial").executes(context -> this.batchTrial((CommandContext<class_2168>)context, false))).then(class_2170.method_9244((String)"at", (ArgumentType)class_2277.method_9737()).executes(context -> this.batchTrial((CommandContext<class_2168>)context, true)))))))));
    }

    private int listGroup(CommandContext<class_2168> context, Predicate<FakePlayerSerializer> predicate) throws CommandSyntaxException {
        String group = StringArgumentType.getString(context, (String)"group");
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        PlayerSerializationManager manager = FetcherUtils.getFakePlayerSerializationManager(server);
        HashMap<String, HashSet<FakePlayerSerializer>> map = manager.listGroup(predicate);
        HashSet<FakePlayerSerializer> set = map.get(group);
        if (set == null) {
            throw CommandUtils.createException("carpet.commands.playerManager.group.non_existent", group);
        }
        List<Supplier> list = set.stream().map(FakePlayerSerializer::toTextSupplier).toList();
        PagedCollection collection = FetcherUtils.getPageManager(server).newPagedCollection((class_2168)context.getSource());
        collection.addContent(list);
        MessageUtils.sendEmptyMessage(context);
        MessageUtils.sendMessage(context, "carpet.commands.playerManager.group.list", group);
        collection.print();
        return collection.length();
    }

    private int listUngrouped(CommandContext<class_2168> context, Predicate<FakePlayerSerializer> predicate) throws CommandSyntaxException {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        PlayerSerializationManager manager = FetcherUtils.getFakePlayerSerializationManager(server);
        HashMap<String, HashSet<FakePlayerSerializer>> map = manager.listGroup(predicate);
        HashSet<FakePlayerSerializer> set = map.get(null);
        if (set == null) {
            class_2561 translate = TextBuilder.translate("carpet.commands.playerManager.group.name.ungrouped", new Object[0]);
            throw CommandUtils.createException("carpet.commands.playerManager.group.non_existent", translate);
        }
        List<Supplier> list = set.stream().map(FakePlayerSerializer::toTextSupplier).toList();
        PagedCollection collection = FetcherUtils.getPageManager(server).newPagedCollection((class_2168)context.getSource());
        collection.addContent(list);
        MessageUtils.sendEmptyMessage(context);
        MessageUtils.sendMessage(context, "carpet.commands.playerManager.group.list.ungrouped", new Object[0]);
        collection.print();
        return collection.length();
    }

    private int listAll(CommandContext<class_2168> context, Predicate<FakePlayerSerializer> predicate) throws CommandSyntaxException {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        PlayerSerializationManager manager = FetcherUtils.getFakePlayerSerializationManager(server);
        List<Supplier> list = manager.list().stream().filter(predicate).map(FakePlayerSerializer::toTextSupplier).toList();
        PagedCollection collection = FetcherUtils.getPageManager(server).newPagedCollection((class_2168)context.getSource());
        collection.addContent(list);
        MessageUtils.sendEmptyMessage(context);
        MessageUtils.sendMessage(context, "carpet.commands.playerManager.group.list.all", new Object[0]);
        collection.print();
        return collection.length();
    }

    private int addToGroup(CommandContext<class_2168> context) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)"name");
        String group = StringArgumentType.getString(context, (String)"group");
        FakePlayerSerializer serializer = this.getFakePlayerSerializer(context, name);
        serializer.addToGroup(group);
        MessageUtils.sendMessage(context, "carpet.commands.playerManager.group.add", serializer.getDisplayName(), group);
        return 1;
    }

    private int removeFromGroup(CommandContext<class_2168> context) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)"name");
        String group = StringArgumentType.getString(context, (String)"group");
        FakePlayerSerializer serializer = this.getFakePlayerSerializer(context, name);
        if (!serializer.removeFromGroup(group)) {
            throw CommandUtils.createException("carpet.commands.playerManager.group.remove.fail", new Object[0]);
        }
        MessageUtils.sendMessage(context, "carpet.commands.playerManager.group.remove", serializer.getDisplayName(), group);
        return 1;
    }

    private int reload(CommandContext<class_2168> context) {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        PlayerSerializationManager manager = FetcherUtils.getFakePlayerSerializationManager(server);
        manager.reload();
        MessageUtils.sendMessage(context, "carpet.commands.playerManager.reload", new Object[0]);
        return 1;
    }

    private Predicate<FakePlayerSerializer> serializerPredicate(CommandContext<class_2168> context) {
        return serializer -> this.serializerPredicate((FakePlayerSerializer)serializer, StringArgumentType.getString((CommandContext)context, (String)"filter"));
    }

    private Predicate<FakePlayerSerializer> serializerPredicate(@Nullable String filter) {
        if (filter == null) {
            return serializer -> true;
        }
        return serializer -> this.serializerPredicate((FakePlayerSerializer)serializer, filter);
    }

    private boolean serializerPredicate(FakePlayerSerializer serializer, String filter) {
        Predicate<String> predicate = s -> s.contains(filter.toLowerCase(Locale.ROOT));
        return predicate.test(serializer.getFakePlayerName().toLowerCase()) || predicate.test(serializer.getComment());
    }

    @NotNull
    private SuggestionProvider<class_2168> cancelSuggests() {
        return (context, builder) -> {
            ServerTaskManager manager = ServerComponentCoordinator.getCoordinator((CommandContext<class_2168>)context).getServerTaskManager();
            Stream<String> stream = manager.stream(PlayerScheduleTask.class).map(PlayerScheduleTask::getPlayerName);
            return class_2172.method_9264(stream, (SuggestionsBuilder)builder);
        };
    }

    private SuggestionProvider<class_2168> defaultSuggests() {
        return (context, builder) -> {
            Stream<String> stream = FetcherUtils.getFakePlayerSerializationManager(((class_2168)context.getSource()).method_9211()).list().stream().map(FakePlayerSerializer::getFakePlayerName).map(StringArgumentType::escapeIfRequired);
            return class_2172.method_9264(stream, (SuggestionsBuilder)builder);
        };
    }

    private SuggestionProvider<class_2168> groupSuggests() {
        return (context, builder) -> {
            PlayerSerializationManager manager = FetcherUtils.getFakePlayerSerializationManager(((class_2168)context.getSource()).method_9211());
            Stream<String> stream = manager.listGroup(serializer -> true).keySet().stream().filter(Objects::nonNull).map(StringArgumentType::escapeIfRequired);
            return class_2172.method_9264(stream, (SuggestionsBuilder)builder);
        };
    }

    @NotNull
    private SuggestionProvider<class_2168> reLoginTaskSuggests() {
        return (context, builder) -> {
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            ServerTaskManager manager = ServerComponentCoordinator.getCoordinator(server).getServerTaskManager();
            List<String> taskList = manager.stream(ReLoginTask.class).map(ReLoginTask::getPlayerName).toList();
            List<String> onlineList = server.method_3760().method_14571().stream().map(FetcherUtils::getPlayerName).toList();
            HashSet<String> players = new HashSet<String>();
            players.addAll(taskList);
            players.addAll(onlineList);
            return class_2172.method_9264(players.stream(), (SuggestionsBuilder)builder);
        };
    }

    private int safeAfk(CommandContext<class_2168> context, float threshold, boolean save) throws CommandSyntaxException {
        EntityPlayerMPFake fakePlayer = CommandUtils.getArgumentFakePlayer(context);
        if (threshold >= fakePlayer.method_6063()) {
            throw CommandUtils.createException("carpet.commands.playerManager.safeafk.threshold_too_high", new Object[0]);
        }
        if (threshold <= 0.0f) {
            threshold = -1.0f;
        }
        FakePlayerSafeAfkInterface safeAfk = (FakePlayerSafeAfkInterface)fakePlayer;
        safeAfk.carpet_Org_Addition$setHealthThreshold(threshold);
        if (save) {
            try {
                this.saveSafeAfkThreshold(context, threshold, fakePlayer);
            }
            catch (IOException e) {
                throw CommandExecuteIOException.of(e);
            }
        } else {
            String command = CommandProvider.setupSafeAfkPermanentlyChange(fakePlayer, threshold);
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.safeafk.successfully_set_up", fakePlayer.method_5476(), Float.valueOf(threshold), TextProvider.clickRun(command));
        }
        return (int)threshold;
    }

    private int listSafeAfk(CommandContext<class_2168> context) {
        List<class_3222> list = ((class_2168)context.getSource()).method_9211().method_3760().method_14571().stream().filter(player -> player instanceof EntityPlayerMPFake).toList();
        int count = 0;
        for (class_3222 player2 : list) {
            float threshold = ((FakePlayerSafeAfkInterface)player2).carpet_Org_Addition$getHealthThreshold();
            if (threshold < 0.0f) continue;
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.safeafk.list.each", player2.method_5476(), Float.valueOf(threshold));
            ++count;
        }
        if (count == 0) {
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.safeafk.list.empty", new Object[0]);
        }
        return count;
    }

    private int cancelSafeAfk(CommandContext<class_2168> context, boolean remove) throws CommandSyntaxException {
        EntityPlayerMPFake fakePlayer = CommandUtils.getArgumentFakePlayer(context);
        FakePlayerSafeAfkInterface safeAfk = (FakePlayerSafeAfkInterface)fakePlayer;
        safeAfk.carpet_Org_Addition$setHealthThreshold(-1.0f);
        if (remove) {
            try {
                this.saveSafeAfkThreshold(context, -1.0f, fakePlayer);
            }
            catch (IOException e) {
                throw CommandExecuteIOException.of(e);
            }
        } else {
            String key = "carpet.commands.playerManager.safeafk.successfully_set_up.cancel";
            class_2561 command = TextProvider.clickRun(CommandProvider.cancelSafeAfkPermanentlyChange(fakePlayer));
            MessageUtils.sendMessage(context, key, fakePlayer.method_5476(), command);
        }
        return 1;
    }

    private int querySafeAfk(CommandContext<class_2168> context) throws CommandSyntaxException {
        EntityPlayerMPFake fakePlayer = CommandUtils.getArgumentFakePlayer(context);
        float threshold = ((FakePlayerSafeAfkInterface)fakePlayer).carpet_Org_Addition$getHealthThreshold();
        String key = "carpet.commands.playerManager.safeafk.list.each";
        MessageUtils.sendMessage(context, key, fakePlayer.method_5476(), Float.valueOf(threshold));
        return (int)threshold;
    }

    private void saveSafeAfkThreshold(CommandContext<class_2168> context, float threshold, EntityPlayerMPFake fakePlayer) throws IOException {
        String playerName = FetcherUtils.getPlayerName((class_1657)fakePlayer);
        WorldFormat worldFormat = new WorldFormat(((class_2168)context.getSource()).method_9211(), null, new String[0]);
        File file = worldFormat.file(SAFEAFK_PROPERTIES);
        if (file.isFile() || file.createNewFile()) {
            BufferedWriter writer;
            BufferedReader reader;
            Properties properties = new Properties();
            try (BufferedReader bufferedReader = reader = IOUtils.toReader(file);){
                properties.load(reader);
            }
            if (threshold > 0.0f) {
                properties.setProperty(playerName, String.valueOf(threshold));
                MessageUtils.sendMessage(context, "carpet.commands.playerManager.safeafk.successfully_set_up.save", fakePlayer.method_5476(), Float.valueOf(threshold));
            } else {
                properties.remove(playerName);
                MessageUtils.sendMessage(context, "carpet.commands.playerManager.safeafk.successfully_set_up.remove", fakePlayer.method_5476());
            }
            try (BufferedWriter bufferedWriter = writer = IOUtils.toWriter(file);){
                properties.store(writer, null);
            }
        }
    }

    public static void loadSafeAfk(class_3222 player) {
        WorldFormat worldFormat;
        File file;
        if (player instanceof EntityPlayerMPFake && (file = (worldFormat = new WorldFormat(FetcherUtils.getServer(player), null, new String[0])).file(SAFEAFK_PROPERTIES)).isFile()) {
            Properties properties = new Properties();
            try {
                BufferedReader reader;
                try (BufferedReader bufferedReader = reader = IOUtils.toReader(file);){
                    properties.load(reader);
                }
            }
            catch (IOException e) {
                CarpetOrgAddition.LOGGER.error("\u5047\u73a9\u5bb6\u5b89\u5168\u6302\u673a\u9608\u503c\u52a0\u8f7d\u65f6\u51fa\u9519", (Throwable)e);
                return;
            }
            try {
                FakePlayerSafeAfkInterface safeAfk = (FakePlayerSafeAfkInterface)player;
                String value = properties.getProperty(FetcherUtils.getPlayerName((class_1657)player));
                if (value == null) {
                    return;
                }
                float threshold = Float.parseFloat(value);
                safeAfk.carpet_Org_Addition$setHealthThreshold(threshold);
                String key = "carpet.commands.playerManager.safeafk.successfully_set_up.auto";
                TextBuilder builder = TextBuilder.of(key, player.method_5476(), Float.valueOf(threshold));
                builder.setGrayItalic();
                MessageUtils.broadcastMessage(FetcherUtils.getServer(player), builder.build());
            }
            catch (NumberFormatException e) {
                CarpetOrgAddition.LOGGER.error("{}\u5b89\u5168\u6302\u673a\u9608\u503c\u8bbe\u7f6e\u5931\u8d25", (Object)FetcherUtils.getPlayerName((class_1657)player), (Object)e);
            }
        }
    }

    private int list(CommandContext<class_2168> context, @Nullable String filter) throws CommandSyntaxException {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        PlayerSerializationManager manager = this.getSerializationManager(server);
        HashMap<String, HashSet<FakePlayerSerializer>> map = manager.listGroup(this.serializerPredicate(filter));
        if (map.isEmpty()) {
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.list.no_player", new Object[0]);
            return 0;
        }
        if (map.size() == 1) {
            Map.Entry<String, HashSet<FakePlayerSerializer>> entry = map.entrySet().iterator().next();
            List<Supplier> list = entry.getValue().stream().sorted(Comparator.naturalOrder()).map(FakePlayerSerializer::toTextSupplier).toList();
            PageManager pageManager = FetcherUtils.getPageManager(server);
            PagedCollection collection = pageManager.newPagedCollection((class_2168)context.getSource());
            collection.addContent(list);
            MessageUtils.sendEmptyMessage(context);
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.group.list.all", new Object[0]);
            collection.print();
            return list.size();
        }
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        MessageUtils.sendMessage(context, "carpet.commands.playerManager.list.expand", new Object[0]);
        TextBuilder ungrouped = null;
        for (Map.Entry<String, HashSet<FakePlayerSerializer>> entry : map.entrySet()) {
            if (entry.getKey() == null) {
                ungrouped = TextBuilder.of("carpet.commands.playerManager.group.name.ungrouped", new Object[0]);
                this.setStyle(ungrouped, entry.getValue().size(), CommandProvider.listUngroupedPlayer(filter));
                continue;
            }
            TextBuilder builder = new TextBuilder("[" + entry.getKey() + "]");
            this.setStyle(builder, entry.getValue().size(), CommandProvider.listGroupPlayer(entry.getKey(), filter));
            list.add(builder.build());
        }
        if (ungrouped != null) {
            list.add(ungrouped.build());
        }
        TextBuilder builder = TextBuilder.of("carpet.commands.playerManager.group.name.all", new Object[0]);
        this.setStyle(builder, manager.size(), CommandProvider.listAllPlayer(filter));
        list.add(builder.build());
        class_2561 message = TextBuilder.joinList(list, TextBuilder.create(" "));
        MessageUtils.sendMessage((class_2168)context.getSource(), message);
        return list.size();
    }

    private void setStyle(TextBuilder builder, int size, String command) {
        builder.setColor(class_124.field_1075);
        builder.setHover("carpet.commands.playerManager.group.player", size);
        builder.setCommand(command);
    }

    private int setComment(CommandContext<class_2168> context, boolean remove) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)"name");
        String comment = remove ? null : StringArgumentType.getString(context, (String)"comment");
        FakePlayerSerializer serializer = this.getFakePlayerSerializer(context, name);
        serializer.setComment(comment);
        if (remove) {
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.comment.remove", serializer.getDisplayName());
        } else {
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.comment.modify", serializer.getDisplayName(), comment);
        }
        return 1;
    }

    private int setAutoLogin(CommandContext<class_2168> context) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)"name");
        boolean autologin = BoolArgumentType.getBool(context, (String)"autologin");
        FakePlayerSerializer serializer = this.getFakePlayerSerializer(context, name);
        serializer.setAutologin(autologin);
        if (autologin) {
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.autologin.setup", serializer.getDisplayName());
        } else {
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.autologin.cancel", serializer.getDisplayName());
        }
        return 1;
    }

    private int savePlayerData(CommandContext<class_2168> context, boolean hasComment) throws CommandSyntaxException {
        String comment;
        EntityPlayerMPFake fakePlayer = CommandUtils.getArgumentFakePlayer(context);
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        PlayerSerializationManager manager = this.getSerializationManager(server);
        String name = FetcherUtils.getPlayerName((class_1657)fakePlayer);
        if (IOUtils.isValidFileName(name)) {
            throw CommandUtils.createException("carpet.command.file.name.valid", new Object[0]);
        }
        Optional<FakePlayerSerializer> optional = manager.get(name);
        if (optional.isPresent()) {
            String command = CommandProvider.playerManagerResave(name);
            class_2561 clickResave = TextProvider.clickRun(command);
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.save.file_already_exist", clickResave);
            return 0;
        }
        String string = comment = hasComment ? StringArgumentType.getString(context, (String)"comment") : "";
        if (CarpetOrgAdditionSettings.playerManagerForceComment.get().booleanValue() && comment.isBlank()) {
            throw CommandUtils.createException("carpet.rule.message.playerManagerForceComment", new Object[0]);
        }
        FakePlayerSerializer serializer = comment.isBlank() ? new FakePlayerSerializer(fakePlayer) : new FakePlayerSerializer(fakePlayer, comment);
        manager.add(serializer);
        MessageUtils.sendMessage((class_2168)context.getSource(), "carpet.commands.playerManager.save.success", fakePlayer.method_5476());
        return 1;
    }

    private int modifyPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        EntityPlayerMPFake fakePlayer = CommandUtils.getArgumentFakePlayer(context);
        String name = FetcherUtils.getPlayerName((class_1657)fakePlayer);
        FakePlayerSerializer oldSerializer = this.getFakePlayerSerializer(context, name);
        PlayerSerializationManager manager = FetcherUtils.getFakePlayerSerializationManager(((class_2168)context.getSource()).method_9211());
        FakePlayerSerializer newSerializer = new FakePlayerSerializer(fakePlayer, oldSerializer);
        manager.add(newSerializer);
        MessageUtils.sendMessage((class_2168)context.getSource(), "carpet.commands.playerManager.save.resave", fakePlayer.method_5476());
        return 1;
    }

    private int spawnPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)"name");
        try {
            FakePlayerSerializer serializer = this.getFakePlayerSerializer(context, name);
            CarpetOrgAdditionSettings.playerSummoner.set(((class_2168)context.getSource()).method_44023());
            serializer.spawn(((class_2168)context.getSource()).method_9211());
        }
        catch (RuntimeException e) {
            throw CommandUtils.createException(e, "carpet.commands.playerManager.spawn.fail", new Object[0]);
        }
        finally {
            CarpetOrgAdditionSettings.playerSummoner.remove();
        }
        return 1;
    }

    private FakePlayerSerializer getFakePlayerSerializer(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        PlayerSerializationManager manager = this.getSerializationManager(context);
        Optional<FakePlayerSerializer> optional = manager.get(name);
        if (optional.isEmpty()) {
            throw CommandUtils.createException("carpet.commands.playerManager.cannot_find_file", name);
        }
        return optional.get();
    }

    private int remove(CommandContext<class_2168> context) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)"name");
        PlayerSerializationManager manager = this.getSerializationManager(context);
        Optional<FakePlayerSerializer> optional = manager.get(name);
        if (optional.isEmpty()) {
            throw CommandUtils.createException("carpet.commands.playerManager.delete.non_existent", new Object[0]);
        }
        if (manager.remove(optional.get())) {
            MessageUtils.sendMessage((class_2168)context.getSource(), "carpet.commands.playerManager.delete.success", new Object[0]);
            return 1;
        }
        throw CommandUtils.createException("carpet.commands.playerManager.delete.fail", new Object[0]);
    }

    private int addStartupFunction(CommandContext<class_2168> context, FakePlayerStartupAction action, int delay) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)"name");
        FakePlayerSerializer serializer = this.getFakePlayerSerializer(context, name);
        serializer.addStartupFunction(action, delay);
        return delay;
    }

    private int setReLogin(CommandContext<class_2168> context) throws CommandSyntaxException {
        if (this.fixMemoryLeak(context)) {
            String name = StringArgumentType.getString(context, (String)"name");
            int interval = IntegerArgumentType.getInteger(context, (String)"interval");
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            ServerTaskManager manager = ServerComponentCoordinator.getCoordinator(context).getServerTaskManager();
            Optional<ReLoginTask> optional = manager.stream(ReLoginTask.class).filter(task -> Objects.equals(task.getPlayerName(), name)).findFirst();
            if (optional.isEmpty()) {
                class_3222 player = server.method_3760().method_14566(name);
                if (player == null) {
                    throw CommandUtils.createException("argument.entity.notfound.player", new Object[0]);
                }
                CommandUtils.assertFakePlayer((class_1657)player);
                manager.addTask(new ReLoginTask((EntityPlayerMPFake)player, interval, server, (class_2168)context.getSource()));
            } else {
                optional.get().setInterval(interval);
                MessageUtils.sendMessage(context, "carpet.commands.playerManager.schedule.relogin.set_interval", name, interval);
            }
            return interval;
        }
        return 0;
    }

    private int batchSpawn(CommandContext<class_2168> context, boolean at) throws CommandSyntaxException {
        return PlayerManagerCommand.batchSpawn(context, at, xva$0 -> GenericUtils.pass(xva$0));
    }

    private int batchTrial(CommandContext<class_2168> context, boolean at) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        class_2168 serverSource = server.method_3739();
        ServerTaskManager taskManager = ServerComponentCoordinator.getCoordinator(server).getServerTaskManager();
        return PlayerManagerCommand.batchSpawn(context, at, fakePlayer -> CommandUtils.handlingException(() -> taskManager.addTask(new SilentLogoutTask(source, (EntityPlayerMPFake)fakePlayer, 30)), serverSource));
    }

    private static int batchSpawn(CommandContext<class_2168> context, boolean at, Consumer<EntityPlayerMPFake> consumer) throws CommandSyntaxException {
        FakePlayerCreateContext fakePlayerCreateContext;
        int start = IntegerArgumentType.getInteger(context, (String)"start");
        int end = IntegerArgumentType.getInteger(context, (String)"end");
        int temp = Math.min(start, end);
        int count = (end = Math.max(start, end)) - (start = temp) + 1;
        if (count > 256) {
            throw CommandUtils.createException("carpet.commands.playerManager.batch.exceeds_limit", count, 256);
        }
        Object prefix = StringArgumentType.getString(context, (String)"prefix");
        prefix = ((String)prefix).endsWith("_") ? prefix : (String)prefix + "_";
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        class_11561 cache = server.method_73550().comp_4407();
        if (cache == null) {
            CarpetOrgAddition.LOGGER.warn("Server user cache is null");
            return 0;
        }
        ServerTaskManager taskManager = ServerComponentCoordinator.getCoordinator(server).getServerTaskManager();
        class_243 vec3d = at ? class_2277.method_9736(context, (String)"at") : source.method_9222();
        Optional<class_3222> optional = CommandUtils.getSourcePlayerNullable(source);
        if (optional.isEmpty()) {
            fakePlayerCreateContext = new FakePlayerCreateContext(vec3d, 0.0, 0.0, (class_5321<class_1937>)FetcherUtils.getWorld(source).method_27983(), class_1934.field_9215, false, consumer);
        } else {
            class_3222 player = optional.get();
            fakePlayerCreateContext = new FakePlayerCreateContext(vec3d, player.method_36454(), player.method_36455(), (class_5321<class_1937>)FetcherUtils.getWorld(player).method_27983(), player.field_13974.method_14257(), player.method_31549().field_7479, consumer);
        }
        taskManager.addTask(new BatchSpawnFakePlayerTask(server, source, cache, fakePlayerCreateContext, (String)prefix, start, end));
        return end - start + 1;
    }

    private int batchKill(CommandContext<class_2168> context) throws CommandSyntaxException {
        int start = IntegerArgumentType.getInteger(context, (String)"start");
        int end = IntegerArgumentType.getInteger(context, (String)"end");
        int temp = Math.min(start, end);
        end = Math.max(start, end);
        start = temp;
        Object prefix = StringArgumentType.getString(context, (String)"prefix");
        prefix = ((String)prefix).endsWith("_") ? prefix : (String)prefix + "_";
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        ServerTaskManager taskManager = ServerComponentCoordinator.getCoordinator(server).getServerTaskManager();
        taskManager.addTask(new BatchKillFakePlayer(server, source, (String)prefix, start, end));
        return end - start + 1;
    }

    private int batchDrop(CommandContext<class_2168> context) {
        int start = IntegerArgumentType.getInteger(context, (String)"start");
        int end = IntegerArgumentType.getInteger(context, (String)"end");
        int temp = Math.min(start, end);
        end = Math.max(start, end);
        start = temp;
        Object prefix = StringArgumentType.getString(context, (String)"prefix");
        prefix = ((String)prefix).endsWith("_") ? prefix : (String)prefix + "_";
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        int count = 0;
        class_3324 playerManager = server.method_3760();
        for (int i = start; i <= end; ++i) {
            class_3222 player = playerManager.method_14566((String)prefix + i);
            if (!(player instanceof EntityPlayerMPFake)) continue;
            EntityPlayerMPFake fakePlayer = (EntityPlayerMPFake)player;
            EntityPlayerActionPack actionPack = ((ServerPlayerInterface)fakePlayer).getActionPack();
            actionPack.drop(-2, true);
            ++count;
        }
        return count;
    }

    private boolean fixMemoryLeak(CommandContext<class_2168> context) {
        if (CarpetOrgAdditionSettings.fakePlayerSpawnMemoryLeakFix.get().booleanValue()) {
            return true;
        }
        String command = CommandProvider.setCarpetRule("fakePlayerSpawnMemoryLeakFix", "true");
        class_2561 here = TextBuilder.of("carpet.command.text.click.here", new Object[0]).setSuggest(command).setColor(class_124.field_1075).setHover("carpet.command.text.click.input", command).build();
        MessageUtils.sendMessage(context, "carpet.commands.playerManager.schedule.relogin.condition", here);
        return false;
    }

    private int stopReLogin(CommandContext<class_2168> context) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)"name");
        ServerTaskManager manager = ServerComponentCoordinator.getCoordinator(context).getServerTaskManager();
        Optional<ReLoginTask> optional = manager.stream(ReLoginTask.class).filter(task -> Objects.equals(task.getPlayerName(), name)).findFirst();
        if (optional.isEmpty()) {
            throw CommandUtils.createException("carpet.commands.playerManager.schedule.cancel.fail", new Object[0]);
        }
        optional.ifPresent(task -> task.onCancel(context));
        return 1;
    }

    private int addDelayedLoginTask(CommandContext<class_2168> context, TimeUnit unit) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        ServerTaskManager taskManager = ServerComponentCoordinator.getCoordinator(context).getServerTaskManager();
        String name = StringArgumentType.getString(context, (String)"name");
        Optional<DelayedLoginTask> optional = taskManager.stream(DelayedLoginTask.class).filter(task -> Objects.equals(name, task.getPlayerName())).findFirst();
        long tick = unit.getDelayed(context);
        class_2561 time = new TextBuilder(TextProvider.tickToTime(tick)).setHover(TextProvider.tickToRealTime(tick)).build();
        if (optional.isEmpty()) {
            FakePlayerSerializer serializer = this.getFakePlayerSerializer(context, name);
            taskManager.addTask(new DelayedLoginTask(server, source, serializer, tick));
            String key = server.method_3760().method_14566(name) == null ? "carpet.commands.playerManager.schedule.login" : "carpet.commands.playerManager.schedule.login.try";
            MessageUtils.sendMessage(context, key, serializer.getDisplayName(), time);
        } else {
            DelayedLoginTask task2 = optional.get();
            TextBuilder builder = new TextBuilder(name);
            builder.setHover(task2.getInfo());
            task2.setDelayed(tick);
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.schedule.login.modify", builder.build(), time);
        }
        return (int)tick;
    }

    private int addDelayedLogoutTask(CommandContext<class_2168> context, TimeUnit unit) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        EntityPlayerMPFake fakePlayer = CommandUtils.getArgumentFakePlayer(context);
        long tick = unit.getDelayed(context);
        class_2561 time = new TextBuilder(TextProvider.tickToTime(tick)).setHover(TextProvider.tickToRealTime(tick)).build();
        ServerTaskManager manager = ServerComponentCoordinator.getCoordinator(server).getServerTaskManager();
        Optional<DelayedLogoutTask> optional = manager.stream(DelayedLogoutTask.class).filter(task -> fakePlayer.equals((Object)task.getFakePlayer())).findFirst();
        if (optional.isEmpty()) {
            manager.addTask(new DelayedLogoutTask(server, source, fakePlayer, tick));
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.schedule.logout", fakePlayer.method_5476(), time);
        } else {
            optional.get().setDelayed(tick);
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.schedule.logout.modify", fakePlayer.method_5476(), time);
        }
        return (int)tick;
    }

    private int cancelScheduleTask(CommandContext<class_2168> context) throws CommandSyntaxException {
        ServerTaskManager manager = ServerComponentCoordinator.getCoordinator(context).getServerTaskManager();
        String name = StringArgumentType.getString(context, (String)"name");
        List<PlayerScheduleTask> list = manager.stream(PlayerScheduleTask.class).filter(task -> Objects.equals(task.getPlayerName(), name)).toList();
        if (list.isEmpty()) {
            throw CommandUtils.createException("carpet.commands.playerManager.schedule.cancel.fail", new Object[0]);
        }
        list.forEach(task -> task.onCancel(context));
        return list.size();
    }

    private int listScheduleTask(CommandContext<class_2168> context) {
        ServerTaskManager manager = ServerComponentCoordinator.getCoordinator(context).getServerTaskManager();
        List<PlayerScheduleTask> list = manager.stream(PlayerScheduleTask.class).toList();
        if (list.isEmpty()) {
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.schedule.list.empty", new Object[0]);
        } else {
            list.forEach(task -> task.sendEachMessage((class_2168)context.getSource()));
        }
        return list.size();
    }

    private PlayerSerializationManager getSerializationManager(MinecraftServer server) {
        return FetcherUtils.getFakePlayerSerializationManager(server);
    }

    private PlayerSerializationManager getSerializationManager(CommandContext<class_2168> context) {
        return this.getSerializationManager(((class_2168)context.getSource()).method_9211());
    }

    @Override
    public String getDefaultName() {
        return "playerManager";
    }

    public static enum TimeUnit {
        TICK,
        SECOND,
        MINUTE,
        HOUR;


        private String getName() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "t";
                case 1 -> "s";
                case 2 -> "min";
                case 3 -> "h";
            };
        }

        private long getDelayed(CommandContext<class_2168> context) {
            int delayed = IntegerArgumentType.getInteger(context, (String)"delayed");
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> delayed;
                case 1 -> (long)delayed * 20L;
                case 2 -> (long)delayed * 1200L;
                case 3 -> (long)delayed * 72000L;
            };
        }
    }
}

