/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import carpet.CarpetServer;
import carpet.api.settings.CarpetRule;
import carpet.api.settings.RuleHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import org.apache.commons.lang3.mutable.MutableInt;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.command.AbstractServerCommand;
import org.carpetorgaddition.mixin.accessor.carpet.SettingsManagerAccessor;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.TextBuilder;

public class RuleSearchCommand
extends AbstractServerCommand {
    public RuleSearchCommand(CommandDispatcher<class_2168> dispatcher, class_7157 access) {
        super(dispatcher, access);
    }

    @Override
    public void register(String name) {
        this.dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(CommandUtils.canUseCommand(CarpetOrgAdditionSettings.commandRuleSearch))).then(class_2170.method_9244((String)"rule", (ArgumentType)StringArgumentType.greedyString()).executes(this::listRule)));
    }

    private int listRule(CommandContext<class_2168> context) {
        String filter = StringArgumentType.getString(context, (String)"rule");
        if (filter.matches("\".*\"")) {
            filter = filter.substring(1, filter.length() - 1);
        }
        class_2561 text = TextBuilder.of("carpet.commands.ruleSearch.feedback", filter).setBold().build();
        MessageUtils.sendMessage((class_2168)context.getSource(), text);
        if (filter.isEmpty()) {
            return 0;
        }
        return this.listRule(context, filter);
    }

    private int listRule(CommandContext<class_2168> context, String filter) {
        MutableInt ruleCount = new MutableInt(0);
        CarpetServer.forEachManager(settingsManager -> {
            SettingsManagerAccessor accessor = (SettingsManagerAccessor)settingsManager;
            Collection rules = settingsManager.getCarpetRules();
            for (CarpetRule rule : rules) {
                if (RuleHelper.translatedName((CarpetRule)rule).contains(filter)) {
                    MessageUtils.sendMessage((class_2168)context.getSource(), accessor.displayInteractiveSettings(rule));
                    ruleCount.increment();
                    continue;
                }
                if (!RuleHelper.translatedDescription((CarpetRule)rule).contains(filter)) continue;
                class_2561 message = new TextBuilder(accessor.displayInteractiveSettings(rule)).setItalic().build();
                MessageUtils.sendMessage((class_2168)context.getSource(), message);
                ruleCount.increment();
            }
        });
        return ruleCount.getValue();
    }

    @Override
    public String getDefaultName() {
        return "ruleSearch";
    }
}

