/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.mixin.util.carpet;

import carpet.patches.EntityPlayerMPFake;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2535;
import net.minecraft.class_2709;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_8792;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.periodic.task.batch.BatchSpawnFakePlayerTask;
import org.carpetorgaddition.periodic.task.schedule.ReLoginTask;
import org.carpetorgaddition.util.GenericUtils;
import org.carpetorgaddition.wheel.ThreadContextPropagator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityPlayerMPFake.class})
public class EntityPlayerMPFakeMixin {
    @WrapOperation(method={"createFake"}, at={@At(value="INVOKE", target="Ljava/util/concurrent/CompletableFuture;whenCompleteAsync(Ljava/util/function/BiConsumer;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;")})
    private static <T> CompletableFuture<T> whenCompleteAsync(CompletableFuture<Optional<GameProfile>> instance, BiConsumer<? super T, ? super Throwable> action, Executor executor, Operation<CompletableFuture<T>> original) {
        Consumer<EntityPlayerMPFake> onFakePlayerSpawning = GenericUtils.FAKE_PLAYER_SPAWNING.get();
        if (onFakePlayerSpawning == null) {
            return (CompletableFuture)original.call(new Object[]{instance, action, executor});
        }
        BiConsumer<Object, Throwable> biConsumer = (value, throwable) -> {
            try {
                GenericUtils.INTERNAL_FAKE_PLAYER_SPAWNING.set(onFakePlayerSpawning);
                action.accept((Object)value, (Throwable)throwable);
            }
            finally {
                GenericUtils.INTERNAL_FAKE_PLAYER_SPAWNING.remove();
            }
        };
        return (CompletableFuture)original.call(new Object[]{instance, biConsumer, executor});
    }

    @WrapOperation(method={"createFake"}, at={@At(value="INVOKE", target="Ljava/util/concurrent/CompletableFuture;whenCompleteAsync(Ljava/util/function/BiConsumer;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;")})
    private static <T> CompletableFuture<T> fakePlayerLoginMessage(CompletableFuture<T> instance, BiConsumer<? super T, ? super Throwable> action, Executor executor, Operation<CompletableFuture<T>> original) {
        ThreadContextPropagator<Boolean> propagator = CarpetOrgAdditionSettings.hiddenLoginMessages;
        Boolean external = propagator.getExternal();
        Boolean hiddenBatchSpawn = BatchSpawnFakePlayerTask.batchSpawnHiddenMessage.get();
        BiConsumer<Object, Throwable> consumer = (value, throwable) -> {
            try {
                BatchSpawnFakePlayerTask.internalBatchSpawnHiddenMessage.set(hiddenBatchSpawn);
                propagator.setInternal(external);
                action.accept((Object)value, (Throwable)throwable);
            }
            finally {
                propagator.setInternal(false);
                BatchSpawnFakePlayerTask.internalBatchSpawnHiddenMessage.set(false);
            }
        };
        return (CompletableFuture)original.call(new Object[]{instance, consumer, executor});
    }

    @Inject(method={"lambda$createFake$2"}, at={@At(value="INVOKE", target="Lcarpet/patches/EntityPlayerMPFake;getAbilities()Lnet/minecraft/entity/player/PlayerAbilities;")})
    private static void spawn(CallbackInfo ci, @Local EntityPlayerMPFake fakePlayer) {
        Consumer<EntityPlayerMPFake> consumer = GenericUtils.INTERNAL_FAKE_PLAYER_SPAWNING.get();
        if (consumer == null) {
            return;
        }
        consumer.accept(fakePlayer);
    }

    @WrapOperation(method={"lambda$createFake$2"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/PlayerManager;onPlayerConnect(Lnet/minecraft/network/ClientConnection;Lnet/minecraft/server/network/ServerPlayerEntity;Lnet/minecraft/server/network/ConnectedClientData;)V")})
    private static void onPlayerConnect(class_3324 instance, class_2535 connection, class_3222 player, class_8792 clientData, Operation<Void> original, @Local EntityPlayerMPFake fakePlayer) {
        boolean internal = CarpetOrgAdditionSettings.hiddenLoginMessages.getInternal();
        try {
            original.call(new Object[]{instance, connection, player, clientData});
        }
        catch (NullPointerException e) {
            if (internal) {
                CarpetOrgAddition.LOGGER.warn("Fake player attempts to join game after server shutdown", (Throwable)e);
            }
            throw e;
        }
    }

    @WrapOperation(method={"createFake"}, at={@At(value="INVOKE", target="Ljava/util/concurrent/CompletableFuture;whenCompleteAsync(Ljava/util/function/BiConsumer;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;")})
    private static <T> CompletableFuture<T> homePositionSpawn(CompletableFuture<T> instance, BiConsumer<? super T, ? super Throwable> action, Executor executor, Operation<CompletableFuture<T>> original) {
        Boolean shouldHomePosition = ReLoginTask.HOME_POSITION.get();
        BiConsumer<Object, Throwable> consumer = (value, throwable) -> {
            try {
                ReLoginTask.INTERNAL_HOME_POSITION.set(shouldHomePosition);
                action.accept((Object)value, (Throwable)throwable);
            }
            finally {
                ReLoginTask.INTERNAL_HOME_POSITION.set(false);
            }
        };
        return (CompletableFuture)original.call(new Object[]{instance, consumer, executor});
    }

    @WrapOperation(method={"lambda$createFake$2"}, at={@At(value="INVOKE", target="Lcarpet/patches/EntityPlayerMPFake;teleport(Lnet/minecraft/server/world/ServerWorld;DDDLjava/util/Set;FFZ)Z")})
    private static boolean homePositionSpawn(EntityPlayerMPFake instance, class_3218 serverWorld, double x, double y, double z, Set<class_2709> set, float yaw, float pitch, boolean b, Operation<Boolean> original) {
        if (ReLoginTask.INTERNAL_HOME_POSITION.get().booleanValue()) {
            return false;
        }
        return (Boolean)original.call(new Object[]{instance, serverWorld, x, y, z, set, Float.valueOf(yaw), Float.valueOf(pitch), b});
    }

    @WrapWithCondition(method={"lambda$createFake$2"}, at={@At(value="INVOKE", target="Lcarpet/patches/EntityPlayerMPFake;stopRiding()V")})
    private static boolean stopRiding(EntityPlayerMPFake instance) {
        return ReLoginTask.INTERNAL_HOME_POSITION.get() == false;
    }
}

